/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.services.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.annotation.Component;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.IBizCtrl;
import com.kingdee.bos.framework.batch.BatchExecuteParamsEntry;
import com.kingdee.bos.framework.batch.BatchExecuteResult;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.services.core.BusinessServices;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.manage.FaCardInfo;
import com.kingdee.eas.fi.fa.manage.FaCurCardCollection;
import com.kingdee.eas.fi.fa.manage.FaCurCardFactory;
import com.kingdee.eas.fi.fa.manage.FaCurCardInfo;
import com.kingdee.eas.fi.fa.manage.IFaCurCard;
import com.kingdee.eas.fi.fa.manage.services.IFaBatchSubmitService;
import com.kingdee.eas.fi.fa.manage.services.impl.FaCardSubmit;
import com.kingdee.eas.framework.CoreBaseInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(value={"com.kingdee.eas.fi.fa.manage.services.IFaBatchSubmitService"})
public class FaBatchSubmitService
extends BusinessServices
implements IFaBatchSubmitService {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.fa.bsf.manage.impl.FaBatchSubmitService");

    public FaBatchSubmitService(Context context) {
        super(context);
    }

    public Class[] getParameterTypes() {
        return new Class[]{IObjectPK.class};
    }

    public BatchExecuteParamsEntry[] getParameters(List<String> idList) {
        BatchExecuteParamsEntry[] paramEntries = new BatchExecuteParamsEntry[idList.size()];
        BatchExecuteParamsEntry entry = null;
        Class[] paramTypes = this.getParameterTypes();
        for (int i = 0; i < idList.size(); ++i) {
            entry = new BatchExecuteParamsEntry(paramTypes);
            entry.add((Object)new ObjectUuidPK(idList.get(i)));
            paramEntries[i] = entry;
        }
        return paramEntries;
    }

    public Object getId(BatchExecuteParamsEntry paramEntry) {
        return paramEntry.get(0);
    }

    @Override
    public Map<String, Object> batchSubmit(String bosType, String[] billIDs) throws BOSException, EASBizException {
        IBizCtrl bizCtrl = (IBizCtrl)BOSObjectFactory.createBOSObject((Context)this.getContext(), (BOSObjectType)BOSObjectType.create((String)bosType));
        ArrayList<String> idList = new ArrayList<String>(billIDs.length);
        for (int i = 0; i < billIDs.length; ++i) {
            idList.add(billIDs[i]);
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        BatchExecuteResult exeResult = new BatchExecuteResult(idList.size());
        FaCurCardCollection cards = null;
        try {
            cards = this.getFaCurCardCollection(billIDs);
            IFaCurCard icard = FaCurCardFactory.getLocalInstance((Context)this.getContext());
            for (int i = 0; i < cards.size(); ++i) {
                FaCurCardInfo faCardInfo = cards.get(i);
                try {
                    FaCardSubmit cardSubmit = new FaCardSubmit(this.getContext());
                    cardSubmit.checkBeforeSubmit((FaCardInfo)faCardInfo);
                    icard.submit((CoreBaseInfo)faCardInfo);
                    exeResult.setException(i, null);
                    continue;
                }
                catch (Exception e) {
                    logger.error((Object)e);
                    exeResult.setException(i, (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (exeResult.getBatchResult() == null) {
            Throwable[] exps = exeResult.getExceptions();
            int errorCount = result.size();
            for (int i = 0; i < exps.length; ++i) {
                if (exps[i] == null) continue;
                ++errorCount;
                result.put(cards.get(i).getId().toString(), exps[i].getMessage());
            }
            result.put("ERROR_COUNT", String.valueOf(errorCount));
        } else {
            result.put("ERROR_COUNT", 0);
        }
        return result;
    }

    private FaCurCardCollection getFaCurCardCollection(String[] billIDs) throws EASBizException, BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("assetCat.*"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("currency.precision"));
        sic.add(new SelectorItemInfo("assetCat.isLeaf"));
        sic.add(new SelectorItemInfo("assetCat.isDeductInputTax"));
        sic.add(new SelectorItemInfo("assetCat.calcuByEvaluate"));
        sic.add(new SelectorItemInfo("assetCat.DepreciationPolicy.*"));
        sic.add(new SelectorItemInfo("originMethod.isLeaf"));
        sic.add(new SelectorItemInfo("originMethod.number"));
        sic.add(new SelectorItemInfo("useStatus.isLeaf"));
        sic.add(new SelectorItemInfo("useStatus.isDepreciation"));
        sic.add(new SelectorItemInfo("economicPurp.isLeaf"));
        sic.add(new SelectorItemInfo("dept.isLeaf"));
        sic.add(new SelectorItemInfo("accountAsset.isLeaf"));
        sic.add(new SelectorItemInfo("accountAccuDepr.isLeaf"));
        sic.add(new SelectorItemInfo("accountDecValue.isLeaf"));
        sic.add(new SelectorItemInfo("faCurFacility.*"));
        sic.add(new SelectorItemInfo("faCurDepartment.*"));
        sic.add(new SelectorItemInfo("faCurCostCenter.*"));
        sic.add(new SelectorItemInfo("faCurCostCenter.asstActType.*"));
        sic.add(new SelectorItemInfo("faCurCostCenter.asstActItem.*"));
        sic.add(new SelectorItemInfo("faCurCostCenter.faCurAsstActComposit.asstActItem.*"));
        sic.add(new SelectorItemInfo("faCurCostCenter.faCurAsstActComposit.asstActType.*"));
        sic.add(new SelectorItemInfo("faCurCostCenter.accountView.isLeaf"));
        sic.add(new SelectorItemInfo("faCurCostCenter.accountView.longName"));
        sic.add(new SelectorItemInfo("faCurCostCenter.accountView.name"));
        sic.add(new SelectorItemInfo("accountAsset.longName"));
        sic.add(new SelectorItemInfo("accountAccuDepr.longName"));
        sic.add(new SelectorItemInfo("accountDecValue.longName"));
        sic.add(new SelectorItemInfo("deprMethod.*"));
        sic.add(new SelectorItemInfo("period.beginDate"));
        sic.add(new SelectorItemInfo("period.endDate"));
        sic.add(new SelectorItemInfo("period.periodYear"));
        sic.add(new SelectorItemInfo("period.periodNumber"));
        sic.add(new SelectorItemInfo("evalDeprMode.*"));
        sic.add(new SelectorItemInfo("assetCat.id"));
        sic.add(new SelectorItemInfo("assetCat.numberRule"));
        sic.add(new SelectorItemInfo("assetCat.number"));
        sic.add(new SelectorItemInfo("dept.id"));
        sic.add(new SelectorItemInfo("dept.name"));
        sic.add(new SelectorItemInfo("dept.number"));
        sic.add(new SelectorItemInfo("CU.id"));
        sic.add(new SelectorItemInfo("CU.name"));
        sic.add(new SelectorItemInfo("CU.number"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("effectedStatus"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("company.baseCurrency.id"));
        sic.add(new SelectorItemInfo("company.baseCurrency.name"));
        sic.add(new SelectorItemInfo("company.baseCurrency.number"));
        HashSet<String> idset = new HashSet<String>();
        for (int i = 0; i < billIDs.length; ++i) {
            idset.add(billIDs[i]);
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("id", idset, CompareType.INCLUDE));
        view.setSelector(sic);
        FaCurCardCollection cards = FaCurCardFactory.getLocalInstance((Context)this.getContext()).getFaCurCardCollection(view);
        return cards;
    }
}

