/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.services.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.cdo.CommonDataObject;
import com.kingdee.bos.cdo.ICommonDataObject;
import com.kingdee.bos.cdo.utils.CDOUtils;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.basedata.FACardDefaultValueCollection;
import com.kingdee.eas.fi.fa.basedata.FACardDefaultValueFactory;
import com.kingdee.eas.fi.fa.basedata.FACardDefaultValueInfo;
import com.kingdee.eas.fi.fa.manage.BarCodeStatusEnum;
import com.kingdee.eas.fi.fa.manage.FaBizStatusEnum;
import com.kingdee.eas.fi.fa.manage.FaCardOriginEnum;
import com.kingdee.eas.fi.fa.manage.FaChangeStatusEnmu;
import com.kingdee.eas.fi.fa.manage.FaClearStatusEnum;
import com.kingdee.eas.fi.fa.manage.FaCurCardInfo;
import com.kingdee.eas.fi.fa.manage.FaCurCostCenterCollection;
import com.kingdee.eas.fi.fa.manage.FaCurCostCenterInfo;
import com.kingdee.eas.fi.fa.manage.FaCurDepartmentCollection;
import com.kingdee.eas.fi.fa.manage.FaCurDepartmentInfo;
import com.kingdee.eas.fi.fa.manage.FaFromUnitCatEnum;
import com.kingdee.eas.fi.fa.manage.FaManageUtils;
import com.kingdee.eas.fi.fa.manage.GroupNumberStatusEnum;
import com.kingdee.eas.fi.fa.manage.services.impl.DataProvider;
import com.kingdee.eas.fi.fa.manage.services.model.IModelCreate;
import com.kingdee.eas.fi.fa.manage.services.util.FaServerUtil;
import com.kingdee.eas.framework.BlockedStatusEnum;
import com.kingdee.eas.framework.CheckedStatusEnum;
import com.kingdee.eas.framework.DeletedStatusEnum;
import com.kingdee.eas.framework.EffectedStatusEnum;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.DateTimeUtils;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;

public class FaCardModelCreator
implements IModelCreate {
    private static BigDecimal ZERO = new BigDecimal("0.00");
    private Context context = null;

    public ICommonDataObject createModel(String bosType, String mainOrgUnitId, Context context) throws BOSException, EASBizException {
        this.context = context;
        FaCurCardInfo obj = null;
        if ("42AC39EC".equals(bosType)) {
            obj = this.createFaCurCard(mainOrgUnitId);
        }
        return (CommonDataObject)CDOUtils.convertObjectInfoToCDO((Context)context, obj);
    }

    public ICommonDataObject copyModel(ICommonDataObject dataObject) throws BOSException, EASBizException {
        IObjectValue srcObj = CDOUtils.convertCDOToObjectInfo((Context)this.context, (ICommonDataObject)dataObject);
        IObjectValue objCopy = new DataProvider(this.context).billCopy((AbstractObjectValue)srcObj);
        this.setFieldsNull(objCopy);
        return CDOUtils.convertObjectInfoToCDO((Context)this.context, (IObjectValue)objCopy);
    }

    private FaCurCardInfo createFaCurCard(String mainOrgUnitId) throws BOSException, EASBizException {
        FaCurCardInfo aFaCurCardInfo = new FaCurCardInfo();
        aFaCurCardInfo.setId(BOSUuid.create((BOSObjectType)aFaCurCardInfo.getBOSType()));
        CompanyOrgUnitInfo mainOrgUnit = null;
        if (mainOrgUnitId != null) {
            SelectorItemCollection sic = FaServerUtil.getOrgInfoSelector(OrgType.Company);
            mainOrgUnit = CompanyOrgUnitFactory.getLocalInstance((Context)this.context).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(mainOrgUnitId), sic);
        } else {
            mainOrgUnit = (CompanyOrgUnitInfo)FaServerUtil.getDefaultMainBizOrg(this.context, OrgType.Company, "fa_card_addNew");
        }
        if (mainOrgUnit == null) {
            return aFaCurCardInfo;
        }
        PeriodInfo currenctPeriod = this.getCurrentPeriod(mainOrgUnit);
        Date today = new Date(System.currentTimeMillis());
        today = DateTimeUtils.truncateDate((Date)today);
        today = FaServerUtil.getBizDate(mainOrgUnit, currenctPeriod);
        aFaCurCardInfo.setPeriod(currenctPeriod);
        aFaCurCardInfo.setAccountDate(today);
        aFaCurCardInfo.setFiAccountDate(today);
        HashMap hmParam = FaManageUtils.getFAParameter((BOSUuid)mainOrgUnit.getId(), (Context)this.context);
        if (hmParam != null && hmParam.size() > 0 && hmParam.get("FA_027") != null && hmParam.get("FA_027").equals("true")) {
            aFaCurCardInfo.setFiAccountDate(today);
        }
        aFaCurCardInfo.put("isFromCardUI", (Object)Boolean.TRUE);
        aFaCurCardInfo.setStartUseDate(today);
        aFaCurCardInfo.setUseYears(ZERO);
        aFaCurCardInfo.setAssetAmt(ZERO);
        aFaCurCardInfo.setOriginAmt(ZERO);
        aFaCurCardInfo.setAddons(null);
        aFaCurCardInfo.setAssetValue(ZERO);
        aFaCurCardInfo.setBuyValue(ZERO);
        aFaCurCardInfo.setBuyAccuDepr(ZERO);
        aFaCurCardInfo.setUseTermCount(ZERO);
        aFaCurCardInfo.setDeprTermCount(ZERO);
        aFaCurCardInfo.setAccuDepr(ZERO);
        aFaCurCardInfo.setNeatRemValue(ZERO);
        aFaCurCardInfo.setAccuDeprTYear(ZERO);
        aFaCurCardInfo.setDecValue(ZERO);
        aFaCurCardInfo.setNeatValue(ZERO);
        aFaCurCardInfo.setNeatAmt(ZERO);
        aFaCurCardInfo.setAccuDeprAccuCleanTYear(ZERO);
        aFaCurCardInfo.setOriginDif(ZERO);
        aFaCurCardInfo.setAccuDeprChg(ZERO);
        aFaCurCardInfo.setAccuDeprChgTYear(ZERO);
        aFaCurCardInfo.setDecValueChg(ZERO);
        aFaCurCardInfo.setInitEvalValue(ZERO);
        aFaCurCardInfo.setEvalLeftPeriod(ZERO);
        aFaCurCardInfo.setAccuDeprAccuChg(ZERO);
        aFaCurCardInfo.setAccuDeprAccuClean(ZERO);
        aFaCurCardInfo.setDeprTTerm(ZERO);
        aFaCurCardInfo.setAccuDeprAccuChgTYear(ZERO);
        aFaCurCardInfo.setAccuDeprAll(ZERO);
        aFaCurCardInfo.setDecValueAccuChg(ZERO);
        aFaCurCardInfo.setTreatmentIncome(null);
        aFaCurCardInfo.setFairValue(ZERO);
        aFaCurCardInfo.setLeftYearUp(0);
        aFaCurCardInfo.setDeprCount(0);
        aFaCurCardInfo.setLastPeriodCount(0);
        aFaCurCardInfo.setLastBillID(null);
        aFaCurCardInfo.setIsEvaledBefore(false);
        aFaCurCardInfo.setHasSplited(false);
        aFaCurCardInfo.setHasEvaled(false);
        aFaCurCardInfo.setHasChanged(FaChangeStatusEnmu.HasNotChanged);
        aFaCurCardInfo.setHasCleared(FaClearStatusEnum.HasNotCleared);
        aFaCurCardInfo.setHasDisabled(false);
        aFaCurCardInfo.setBizStatus(FaBizStatusEnum.ADDING);
        aFaCurCardInfo.setCheckedStatus(CheckedStatusEnum.UNAUDITED);
        aFaCurCardInfo.setDeletedStatus(DeletedStatusEnum.NORMAL);
        aFaCurCardInfo.setEffectedStatus(EffectedStatusEnum.TEMPSTORE);
        aFaCurCardInfo.setGroupNumberStatus(GroupNumberStatusEnum.EFFECTED);
        aFaCurCardInfo.setBarCodeStatus(BarCodeStatusEnum.EFFECTED);
        aFaCurCardInfo.setBlockedStatus(BlockedStatusEnum.UNBLOCKED);
        aFaCurCardInfo.setFiVouchered(false);
        aFaCurCardInfo.setOriginType(FaFromUnitCatEnum.NULL);
        aFaCurCardInfo.setCU(ContextUtil.getCurrentCtrlUnit((Context)this.context));
        aFaCurCardInfo.setCompany(mainOrgUnit);
        aFaCurCardInfo.setHandler(ContextUtil.getCurrentUserInfo((Context)this.context));
        aFaCurCardInfo.setCreator(ContextUtil.getCurrentUserInfo((Context)this.context));
        aFaCurCardInfo.setBizDate(today);
        aFaCurCardInfo.setHasNew(true);
        aFaCurCardInfo.setOriginFlag(FaCardOriginEnum.ADDNEW);
        aFaCurCardInfo.setIsNeedReDepr(false);
        aFaCurCardInfo.setSpecs("");
        aFaCurCardInfo.setMfr("");
        aFaCurCardInfo.setPaperNo("");
        aFaCurCardInfo.setRemark("");
        aFaCurCardInfo.setAssetName("");
        aFaCurCardInfo.setPArea("");
        aFaCurCardInfo.setUseStatus(null);
        aFaCurCardInfo.setKeeper(null);
        aFaCurCardInfo.setAccountAsset(null);
        aFaCurCardInfo.setMeasureUnitWL(null);
        aFaCurCardInfo.setAccountAccuDepr(null);
        aFaCurCardInfo.setOriginUnit("");
        aFaCurCardInfo.setStoreCity(null);
        aFaCurCardInfo.setMeasureUnit(null);
        aFaCurCardInfo.setDeprMethod(null);
        aFaCurCardInfo.setAccountDecValue(null);
        aFaCurCardInfo.setDept(null);
        aFaCurCardInfo.setAssetCat(null);
        aFaCurCardInfo.setOriginMethod(null);
        CurrencyInfo currency = this.getBaseCurrency(mainOrgUnit);
        aFaCurCardInfo.setCurrency(currency);
        aFaCurCardInfo.setExRate(new BigDecimal(1.0));
        if (!"true".equals(hmParam.get("FA_036").toString())) {
            aFaCurCardInfo.setEvalAssetValue(ZERO);
            aFaCurCardInfo.setEvalTaxLeftPeriod(ZERO);
            aFaCurCardInfo.setEvalReInAccountDate(new Date());
            aFaCurCardInfo.setEvalDeprPeriodNum(ZERO);
            aFaCurCardInfo.setEvalMonthRate(ZERO);
            aFaCurCardInfo.setEvalRemValue(ZERO);
            aFaCurCardInfo.setEvalAddDepr(ZERO);
            aFaCurCardInfo.setEvalDecValue(ZERO);
            aFaCurCardInfo.setEvalYearDepr(ZERO);
            aFaCurCardInfo.setEvalNeatLeftRate(ZERO);
            aFaCurCardInfo.setEvalUseTermCount(ZERO);
        }
        aFaCurCardInfo.setInputTax(ZERO);
        FaCurCostCenterInfo aFaCurCostCenterInfo = new FaCurCostCenterInfo();
        aFaCurCostCenterInfo.setApportionScale(new BigDecimal("100.00"));
        aFaCurCostCenterInfo.setSeq(1);
        FaCurCostCenterCollection costCenterColl = new FaCurCostCenterCollection();
        costCenterColl.add(aFaCurCostCenterInfo);
        aFaCurCardInfo.put("faCurCostCenter", (Object)costCenterColl);
        this.setDefaultValue(aFaCurCardInfo);
        return aFaCurCardInfo;
    }

    private void setDefaultValue(FaCurCardInfo faCurCardInfo) throws BOSException {
        CompanyOrgUnitInfo mainOrgUnit = faCurCardInfo.getCompany();
        FACardDefaultValueCollection coll = FACardDefaultValueFactory.getLocalInstance((Context)this.context).getFACardDefaultValueCollection("select id,assetAmt,originMethod.*,useStatus.*,economicPurp.*,storeCity.*,dept.*,useDept.* where company.id = '" + mainOrgUnit.getId().toString() + "'");
        if (coll == null || coll.size() == 0) {
            return;
        }
        FACardDefaultValueInfo defaultValue = coll.get(0);
        faCurCardInfo.setAssetAmt(defaultValue.getAssetAmt());
        faCurCardInfo.setOriginMethod(defaultValue.getOriginMethod());
        faCurCardInfo.setUseStatus(defaultValue.getUseStatus());
        faCurCardInfo.setEconomicPurp(defaultValue.getEconomicPurp());
        faCurCardInfo.setStoreCity(defaultValue.getStoreCity());
        faCurCardInfo.setDept(defaultValue.getDept());
        if (defaultValue.getUseDept() != null) {
            FaCurDepartmentInfo useDeptInfo = new FaCurDepartmentInfo();
            BOSUuid id = BOSUuid.create((BOSObjectType)useDeptInfo.getBOSType());
            useDeptInfo.setId(id);
            useDeptInfo.setFaCurCard(faCurCardInfo);
            useDeptInfo.setUseDepartment(defaultValue.getUseDept());
            useDeptInfo.setSeq(1);
            FaCurDepartmentCollection departmentColl = faCurCardInfo.getFaCurDepartment();
            departmentColl.clear();
            departmentColl.add(useDeptInfo);
        }
    }

    private CurrencyInfo getBaseCurrency(CompanyOrgUnitInfo mainOrgUnit) {
        return mainOrgUnit.getBaseCurrency();
    }

    protected PeriodInfo getCurrentPeriod(CompanyOrgUnitInfo mainOrgUnit) throws EASBizException, BOSException {
        return SystemStatusCtrolUtils.getCurrentPeriod((Context)this.context, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)mainOrgUnit);
    }

    private void setFieldsNull(IObjectValue obj) {
        FaCurCardInfo cardInfo = (FaCurCardInfo)obj;
        cardInfo.setNumber(null);
        cardInfo.setGroupNumber(null);
        cardInfo.setEffectedStatus(EffectedStatusEnum.TEMPSTORE);
        cardInfo.setCheckedStatus(CheckedStatusEnum.UNAUDITED);
    }
}

