/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.services.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.cdo.CommonDataObject;
import com.kingdee.bos.cdo.ICommonDataObject;
import com.kingdee.bos.cdo.utils.CDOUtils;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.manage.FaClearBillInfo;
import com.kingdee.eas.fi.fa.manage.services.impl.DataProvider;
import com.kingdee.eas.fi.fa.manage.services.model.IModelCreate;
import com.kingdee.eas.fi.fa.manage.services.util.FaServerUtil;
import com.kingdee.eas.framework.BlockedStatusEnum;
import com.kingdee.eas.framework.CheckedStatusEnum;
import com.kingdee.eas.framework.DeletedStatusEnum;
import com.kingdee.eas.framework.EffectedStatusEnum;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.DateTimeUtils;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Date;

public class FaClearBillModelCreator
implements IModelCreate {
    private static BigDecimal ZERO = new BigDecimal("0.00");
    private Context context = null;

    public ICommonDataObject createModel(String bosType, String mainOrgUnitId, Context context) throws BOSException, EASBizException {
        this.context = context;
        FaClearBillInfo obj = null;
        if ("25F51970".equals(bosType)) {
            obj = this.createFaClearBillInfo(mainOrgUnitId);
        }
        CommonDataObject commonDataObject = (CommonDataObject)CDOUtils.convertObjectInfoToCDO((Context)context, obj);
        return commonDataObject;
    }

    public ICommonDataObject copyModel(ICommonDataObject dataObject) throws BOSException, EASBizException {
        IObjectValue srcObj = CDOUtils.convertCDOToObjectInfo((Context)this.context, (ICommonDataObject)dataObject);
        IObjectValue objCopy = new DataProvider(this.context).billCopy((AbstractObjectValue)srcObj);
        this.setFieldsNull(objCopy);
        return CDOUtils.convertObjectInfoToCDO((Context)this.context, (IObjectValue)objCopy);
    }

    private FaClearBillInfo createFaClearBillInfo(String mainOrgUnitId) throws BOSException, EASBizException {
        FaClearBillInfo clearBillInfo = new FaClearBillInfo();
        CompanyOrgUnitInfo mainOrgUnit = null;
        if (mainOrgUnitId != null) {
            SelectorItemCollection sic = FaServerUtil.getOrgInfoSelector(OrgType.Company);
            mainOrgUnit = CompanyOrgUnitFactory.getLocalInstance((Context)this.context).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(mainOrgUnitId), sic);
        } else {
            mainOrgUnit = (CompanyOrgUnitInfo)FaServerUtil.getDefaultMainBizOrg(this.context, OrgType.Company, "fa_cardclean_addnew");
        }
        if (mainOrgUnit == null) {
            return clearBillInfo;
        }
        PeriodInfo currenctPeriod = this.getCurrentPeriod(mainOrgUnit);
        Date today = new Date(System.currentTimeMillis());
        today = DateTimeUtils.truncateDate((Date)today);
        today = FaServerUtil.getBizDate(mainOrgUnit, currenctPeriod);
        clearBillInfo.setPeriod(currenctPeriod);
        clearBillInfo.setCheckedStatus(CheckedStatusEnum.UNAUDITED);
        clearBillInfo.setDeletedStatus(DeletedStatusEnum.NORMAL);
        clearBillInfo.setBlockedStatus(BlockedStatusEnum.UNBLOCKED);
        clearBillInfo.setEffectedStatus(EffectedStatusEnum.TEMPSTORE);
        clearBillInfo.setFiVouchered(false);
        clearBillInfo.setCU(ContextUtil.getCurrentCtrlUnit((Context)this.context));
        clearBillInfo.setCompany(mainOrgUnit);
        clearBillInfo.setHandler(ContextUtil.getCurrentUserInfo((Context)this.context));
        clearBillInfo.setCreator(ContextUtil.getCurrentUserInfo((Context)this.context));
        clearBillInfo.setCreateTime(new Timestamp(System.currentTimeMillis()));
        clearBillInfo.setClearDate(this.getAccountDate(mainOrgUnit, currenctPeriod));
        this.setRuleNumber(clearBillInfo, mainOrgUnit);
        return clearBillInfo;
    }

    private Date getAccountDate(CompanyOrgUnitInfo companyOrgUnitInfo, PeriodInfo currenctPeriod) throws EASBizException, BOSException {
        Date today = new Date(System.currentTimeMillis());
        if (currenctPeriod == null) {
            return today;
        }
        if (today.before(currenctPeriod.getBeginDate())) {
            today = currenctPeriod.getBeginDate();
        }
        if (today.after(currenctPeriod.getEndDate())) {
            today = currenctPeriod.getEndDate();
        }
        return today;
    }

    protected PeriodInfo getCurrentPeriod(CompanyOrgUnitInfo mainOrgUnit) throws EASBizException, BOSException {
        return SystemStatusCtrolUtils.getCurrentPeriod((Context)this.context, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)mainOrgUnit);
    }

    private void setFieldsNull(IObjectValue obj) {
        FaClearBillInfo clearBillInfo = (FaClearBillInfo)obj;
        clearBillInfo.setNumber(null);
        clearBillInfo.setEffectedStatus(EffectedStatusEnum.TEMPSTORE);
        clearBillInfo.setCheckedStatus(CheckedStatusEnum.UNAUDITED);
    }

    private void setRuleNumber(FaClearBillInfo faClearBillInfo, CompanyOrgUnitInfo mainOrgUnit) throws EASBizException, BOSException {
        String number = null;
        CompanyOrgUnitInfo company = mainOrgUnit;
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)this.context);
        boolean isCodingRule = iCodingRuleManager.isExist((IObjectValue)faClearBillInfo, company.getId().toString());
        boolean isViewCodeRule = iCodingRuleManager.isAddView((IObjectValue)faClearBillInfo, company.getId().toString());
        number = isCodingRule && isViewCodeRule ? iCodingRuleManager.readNumber((IObjectValue)faClearBillInfo, company.getId().toString()) : "";
        faClearBillInfo.setNumber(number);
    }
}

