/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.services.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.annotation.Component;
import com.kingdee.bos.bsf.annotation.Description;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.services.core.BusinessServices;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodTypeInfo;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.basedata.FaCatCollection;
import com.kingdee.eas.fi.fa.basedata.FaCatFactory;
import com.kingdee.eas.fi.fa.basedata.FaCatInfo;
import com.kingdee.eas.fi.fa.manage.app.FaLocalUtils;
import com.kingdee.eas.fi.fa.manage.services.FaContrastDifferenceDetailService;
import com.kingdee.eas.fi.fa.manage.services.impl.FaContrastCalculator;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(value={"com.kingdee.eas.fi.fa.manage.services.FaContrastDifferenceDetailService"})
@Description(value="\u5bf9\u8d26\u5dee\u5f02\u660e\u7ec6\u5b9e\u73b0")
public class FaContrastDifferenceDetailServiceImpl
extends BusinessServices
implements FaContrastDifferenceDetailService {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.fa.manage.services.impl.FaContrastDetailServiceImpl");
    private DateFormat format = new SimpleDateFormat("yyyy-MM-dd");
    private BigDecimal ZERO = new BigDecimal("0.00");

    public FaContrastDifferenceDetailServiceImpl(Context context) {
        super(context);
    }

    @Override
    public Map<String, Object> query(Map<String, Object> condition) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap();
        String companyId = (String)condition.get("companyId");
        String periodYear = (String)condition.get("periodYear");
        String periodNumber = (String)condition.get("periodNumber");
        String accountNumber = (String)condition.get("accountNumber");
        String accountType = (String)condition.get("accountType");
        String aspectDC = (String)condition.get("aspectDC");
        String faCatNumber = (String)condition.get("faCatNumber");
        String isUseCatNumber = (String)condition.get("isUseCatNumber");
        String isUseCardAcct = (String)condition.get("isUseCardAcct");
        String isIncludeUnposted = (String)condition.get("isIncludeUnposted");
        String isUseEvaValue = (String)condition.get("isUseEvaValue");
        if ("sumBegin".equals(aspectDC) || "sumEnd".equals(aspectDC)) {
            throw new BOSException("\u4e0d\u80fd\u5bf9\u671f\u521d\u4f59\u989d\u3001\u671f\u672b\u4f59\u989d\u8fdb\u884c\u8054\u67e5\u660e\u7ec6\uff01");
        }
        String tempTableName = this.createTempTable();
        result = this.insertTempTable(this.getContext(), tempTableName, companyId, Integer.parseInt(periodYear), Integer.parseInt(periodNumber), accountNumber, accountType, aspectDC, faCatNumber, isUseCatNumber, isUseCardAcct, isIncludeUnposted, isUseEvaValue);
        return result;
    }

    private String createTempTable() throws BOSException {
        String tempTableName = null;
        StringBuffer createTableSql = new StringBuffer();
        createTableSql.append("create table fa_contrast_detail (FID VARCHAR(44), FBillID VARCHAR(44), ");
        createTableSql.append("FBillType NVARCHAR(80), FBillNumber NVARCHAR(80), FBillDate DateTime, ");
        createTableSql.append("FBillAmount DECIMAL(19,4), FVoucherID VARCHAR(44), FVoucherPeriod NVARCHAR(80), ");
        createTableSql.append("FVoucherNumber NVARCHAR(80), FVoucherAmount DECIMAL(19,4), FDiffAmount DECIMAL(19,4), ");
        createTableSql.append("FDiffType INT, FIsSum INT, FAccountID VARCHAR(44))");
        try {
            tempTableName = TempTablePool.getInstance((Context)this.getContext()).createTempTable(createTableSql.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return tempTableName;
    }

    private Map<String, Object> insertTempTable(Context context, String tempTableName, String companyId, int periodYear, int periodNumber, String accountNumber, String accountType, String aspectDC, String faCatNumber, String isUseCatNumber, String isUseCardAcct, String isIncludeUnposted, String isUseEvaValue) throws EASBizException, BOSException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        CompanyOrgUnitInfo companyInfo = new CompanyOrgUnitInfo();
        companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)this.getContext()).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
        PeriodInfo periodInfo = this.getPeriodInfo(companyInfo, periodYear, periodNumber);
        AccountViewInfo accountViewInfo = new AccountViewInfo();
        ArrayList<String> accNumberList = new ArrayList<String>();
        if (!"Nothing".equals(accountNumber)) {
            String oql = "select id, name, number, longNumber where companyID = '" + companyId + "' and number = '" + accountNumber + "' and accountTableID = '" + companyInfo.getAccountTable().getId() + "'";
            accountViewInfo = AccountViewFactory.getLocalInstance((Context)context).getAccountViewInfo(oql);
            accNumberList.add(accountViewInfo.getLongNumber());
        } else {
            FaContrastCalculator calculator = new FaContrastCalculator(this.getContext());
            HashMap parameter = calculator.getDefaultContrastSolution(calculator.getContrastSolutions(companyId));
            HashMap accountMap = parameter.get("AccountMap") != null ? (HashMap)parameter.get("AccountMap") : new HashMap();
            HashMap accMap = accountMap.get(accountType) != null ? (HashMap)accountMap.get(accountType) : new HashMap();
            HashSet<String> accountIdSet = new HashSet<String>();
            for (String key : accMap.keySet()) {
                accountIdSet.add((String)accMap.get(key));
            }
            accNumberList = this.getAccountViewLongNumberList(accountIdSet);
        }
        FaCatInfo catInfo = null;
        String faCatId = null;
        if (!"noCat".equals(faCatNumber)) {
            String oql = "select id, number, name where company = '" + companyId + "' and number = '" + faCatNumber + "'";
            FaCatCollection faCatColl = FaCatFactory.getLocalInstance((Context)context).getFaCatCollection(oql);
            catInfo = faCatColl.get(0);
            faCatId = catInfo.getId().toString();
        }
        boolean isCurrentPeriod = this.isCurrentPeriod(context, companyId, periodYear, periodNumber);
        String voucherBizStatus = null;
        voucherBizStatus = "true".equals(isIncludeUnposted) ? "(1,3,5)" : "(5)";
        if ("ASSET".equals(accountType)) {
            if ("true".equals(isUseEvaValue)) {
                if ("sumDebit".equals(aspectDC)) {
                    this.insertEvaValueDebitDiffDetail(context, tempTableName, companyInfo, periodInfo, accNumberList, faCatId, isUseCatNumber, isUseCardAcct, isCurrentPeriod, voucherBizStatus);
                } else if ("sumCredit".equals(aspectDC)) {
                    this.insertEvaValueCreditDiffDetail(context, tempTableName, companyInfo, periodInfo, accNumberList, faCatId, isUseCatNumber, isUseCardAcct, voucherBizStatus);
                }
            } else if ("sumDebit".equals(aspectDC)) {
                this.insertAssetValueDebitDiffDetail(context, tempTableName, companyInfo, periodInfo, accNumberList, faCatId, isUseCatNumber, isUseCardAcct, isCurrentPeriod, voucherBizStatus);
            } else if ("sumCredit".equals(aspectDC)) {
                this.insertAssetValueCreditDiffDetail(context, tempTableName, companyInfo, periodInfo, accNumberList, faCatId, isUseCatNumber, isUseCardAcct, voucherBizStatus);
            }
        } else if ("DEPRE".equals(accountType)) {
            if ("sumDebit".equals(aspectDC)) {
                this.insertAccuDeprDebitDiffDetail(context, tempTableName, companyInfo, periodInfo, accNumberList, faCatId, isUseCatNumber, isUseCardAcct, voucherBizStatus);
            } else if ("sumCredit".equals(aspectDC)) {
                this.insertAccuDeprCreditDiffDetail(context, tempTableName, companyInfo, periodInfo, accNumberList, faCatId, isUseCatNumber, isUseCardAcct, isCurrentPeriod, voucherBizStatus);
            }
        } else if ("DECVALUE".equals(accountType)) {
            if ("sumDebit".equals(aspectDC)) {
                this.insertDecValueDebitDiffDetail(context, tempTableName, companyInfo, periodInfo, accNumberList, faCatId, isUseCatNumber, isUseCardAcct, voucherBizStatus);
            } else if ("sumCredit".equals(aspectDC)) {
                this.insertDecValueCreditDiffDetail(context, tempTableName, companyInfo, periodInfo, accNumberList, faCatId, isUseCatNumber, isUseCardAcct, isCurrentPeriod, voucherBizStatus);
            }
        }
        this.dealWithDiffAmount(context, tempTableName);
        StringBuffer sql = new StringBuffer();
        sql.append(" update ").append(tempTableName);
        sql.append("    set FDiffAmount = FBillAmount, FDiffType = 3, FVoucherPeriod = null ");
        sql.append("  where FBillID is not null ");
        sql.append("    and FVoucherID is null ");
        DbUtil.execute((Context)context, (String)sql.toString());
        sql = new StringBuffer();
        int entryDC = "sumDebit".equals(aspectDC) ? 1 : 0;
        sql.append(" Insert into ").append(tempTableName);
        sql.append(" (FID, FVoucherID, FVoucherPeriod, FVoucherNumber, FVoucherAmount, FDiffAmount, FDiffType, FBillAmount) ");
        sql.append(" select newbosid('00000000') FID, gl.fid FVoucherID, N'" + this.getPeriodString(periodInfo) + "' FVoucherPeriod,");
        sql.append("   gl.fnumber FVoucherNumber, temp.localAmount FVoucherAmount, 0-temp.localAmount FDiffAmount, 4 FDiffType, null FBillAmount ");
        sql.append("  from t_gl_voucher gl ");
        sql.append(" inner join (");
        sql.append("select voucher.fid voucherid, ven.faccountid accountid,sum(ven.flocalamount) localAmount ");
        sql.append("  from t_gl_voucher voucher ");
        sql.append(" inner join t_gl_voucherentry ven on ven.fbillid = voucher.fid ");
        sql.append(" inner join t_bd_accountview acc on acc.fid = ven.faccountid ");
        sql.append(" where voucher.fcompanyid = '").append(companyId).append("' ");
        sql.append("   and voucher.fperiodid = '").append(periodInfo.getId()).append("' ");
        sql.append("   and voucher.fbizstatus in ").append(voucherBizStatus);
        sql.append("   and ven.fentrydc = " + entryDC);
        if (accNumberList.size() == 1) {
            sql.append(" and (acc.Flongnumber = '").append((String)accNumberList.get(0)).append("' or acc.Flongnumber like '").append((String)accNumberList.get(0)).append("%') ");
        } else if (accNumberList.size() > 1) {
            int size = accNumberList.size();
            for (int i = 0; i < size; ++i) {
                sql.append(i == 0 ? " and (acc.Flongnumber = '" + (String)accNumberList.get(i) + "' or acc.Flongnumber like '" + (String)accNumberList.get(0) + "%' " : " or acc.Flongnumber = '" + (String)accNumberList.get(i) + "' or acc.Flongnumber like '" + (String)accNumberList.get(0) + "%' ");
                sql.append(i == size - 1 ? " ) " : "");
            }
        }
        sql.append(" group by voucher.fid, ven.faccountid");
        sql.append(" ) temp on temp.voucherid = gl.fid ");
        sql.append(" where not exists (");
        sql.append("select 1 from ").append(tempTableName).append(" where gl.fid = FVoucherID) ");
        DbUtil.execute((Context)context, (String)sql.toString());
        this.buildSumData(context, tempTableName);
        CurrencyInfo baseCurrencyInfo = CurrencyFactory.getLocalInstance((Context)context).getCurrencyInfo((IObjectPK)new ObjectUuidPK(companyInfo.getBaseCurrency().getId()));
        StringBuffer title = new StringBuffer();
        String dc = entryDC == 1 ? "\u672c\u671f\u501f\u65b9" : "\u672c\u671f\u8d37\u65b9";
        title.append(companyInfo.getName()).append("\u3000|\u3000").append(this.getPeriodString(periodInfo)).append("\u3000|\u3000");
        if (accountViewInfo.getNumber() != null && accountViewInfo.getName() != null) {
            if (!"noCat".equals(faCatNumber) && catInfo != null && catInfo.getName() != null && catInfo.getNumber() != null) {
                title.append(catInfo.getNumber()).append(" ").append(catInfo.getName()).append("-");
            }
            title.append(accountViewInfo.getNumber()).append(" ").append(accountViewInfo.getName()).append("\u3000|\u3000");
        } else {
            String itemKeyRes = null;
            if ("ASSET".equals(accountType)) {
                itemKeyRes = "FixedAssets_OriginalValue";
            } else if ("DEPRE".equals(accountType)) {
                itemKeyRes = "Accu_Depreciation";
            } else if ("DECVALUE".equals(accountType)) {
                itemKeyRes = "DecValue";
            }
            title.append(FaLocalUtils.getResource((Context)context, (String)"com.kingdee.eas.fi.fa.manage.FaContrastResource", (String)itemKeyRes)).append("\u3000|\u3000");
        }
        title.append(dc);
        result.put("title", title.toString());
        result.put("queryId", tempTableName);
        result.put("precision", baseCurrencyInfo.getPrecision());
        return result;
    }

    private void buildSumData(Context context, String tempTableName) throws BOSException {
        String updateIsSumSql = "update " + tempTableName + " set FIsSum = 0 where 1 = 1";
        DbUtil.execute((Context)context, (String)updateIsSumSql);
        StringBuffer sql = new StringBuffer();
        sql.append("Insert into ").append(tempTableName).append("(FBillAmount, FVoucherAmount, FDiffAmount, FIsSum, FDiffType) ").append("select isnull(sum(isnull(FBillAmount, 0)), 0), isnull(sum(isnull(FVoucherAmount, 0)), 0), isnull(sum(isnull(FDiffAmount, 0)), 0), 1 FIsSum, FDiffType ").append("  from ").append(tempTableName).append(" where FIsSum = 0 ").append("group by FDiffType");
        DbUtil.execute((Context)context, (String)sql.toString());
        sql = new StringBuffer();
        sql.append("Insert into ").append(tempTableName).append("(FBillAmount, FVoucherAmount, FDiffAmount, FIsSum) ").append("select isnull(sum(isnull(FBillAmount, 0)), 0), isnull(sum(isnull(FVoucherAmount, 0)), 0), isnull(sum(isnull(FDiffAmount, 0)), 0), 1 FIsSum ").append(" from ").append(tempTableName).append(" where FIsSum = 0 ");
        DbUtil.execute((Context)context, (String)sql.toString());
    }

    private boolean isCurrentPeriod(Context ctx, String companyId, int periodYear, int periodNumber) throws EASBizException, BOSException {
        PeriodInfo periodInfo = FaLocalUtils.getCurrentPeriod((Context)ctx, (String)companyId);
        return periodInfo.getPeriodYear() == periodYear && periodInfo.getPeriodNumber() == periodNumber;
    }

    private List<String> getAccountViewLongNumberList(Set<String> accountIdSet) throws EASBizException, BOSException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("longNumber"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", accountIdSet, CompareType.INCLUDE));
        view.setSelector(selector);
        view.setFilter(filter);
        AccountViewCollection accountViewColl = AccountViewFactory.getLocalInstance((Context)this.getContext()).getAccountViewCollection(view);
        ArrayList<String> numberList = new ArrayList<String>();
        for (AccountViewInfo accountViewInfo : accountViewColl) {
            numberList.add(accountViewInfo.getLongNumber());
        }
        return numberList;
    }

    private void insertEvaValueDebitDiffDetail(Context context, String tempTableName, CompanyOrgUnitInfo companyInfo, PeriodInfo periodInfo, List<String> accNumberList, String faCatId, String isUseCatNumber, String isUseCardAcct, boolean isCurrentPeriod, String voucherBizStatus) throws EASBizException, BOSException {
        String periodToString = this.getPeriodString(periodInfo);
        StringBuffer insertSql = new StringBuffer();
        insertSql.append(" Insert into " + tempTableName + " (FID, FBillID, FBillType, FBillNumber, FBillDate, FBillAmount, ");
        insertSql.append("FVoucherID, FVoucherPeriod, FVoucherNumber, FVoucherAmount, FAccountID) ");
        StringBuffer sql = new StringBuffer();
        sql = this.getFaCurCardDiffDetailSQL(periodToString, companyInfo, periodInfo, accNumberList, isUseCatNumber, isUseCardAcct, isCurrentPeriod, voucherBizStatus, faCatId, "finitevalvalue", 1, "faccountassetid");
        DbUtil.execute((Context)context, (String)(insertSql.toString() + sql.toString()));
        sql = new StringBuffer();
        sql = this.getFaEvaValueDiffDetailSQL(periodToString, companyInfo, periodInfo, accNumberList, isUseCatNumber, isUseCardAcct, voucherBizStatus, faCatId, 1);
        DbUtil.execute((Context)context, (String)(insertSql.toString() + sql.toString()));
    }

    private void insertEvaValueCreditDiffDetail(Context context, String tempTableName, CompanyOrgUnitInfo companyInfo, PeriodInfo periodInfo, List<String> accNumberList, String faCatId, String isUseCatNumber, String isUseCardAcct, String voucherBizStatus) throws EASBizException, BOSException {
        String periodToString = this.getPeriodString(periodInfo);
        StringBuffer insertSql = new StringBuffer();
        insertSql.append(" Insert into " + tempTableName + " (FID, FBillID, FBillType, FBillNumber, FBillDate, FBillAmount, ");
        insertSql.append("FVoucherID, FVoucherPeriod, FVoucherNumber, FVoucherAmount, FAccountID) ");
        StringBuffer sql = new StringBuffer();
        sql = this.getFaClearBillDiffDetailSQL(periodToString, companyInfo, periodInfo, accNumberList, isUseCatNumber, isUseCardAcct, voucherBizStatus, faCatId, "fclrevalvalue", 0, "faccountassetid");
        DbUtil.execute((Context)context, (String)(insertSql.toString() + sql.toString()));
        sql = new StringBuffer();
        sql = this.getFaEvaValueDiffDetailSQL(periodToString, companyInfo, periodInfo, accNumberList, isUseCatNumber, isUseCardAcct, voucherBizStatus, faCatId, 0);
        DbUtil.execute((Context)context, (String)(insertSql.toString() + sql.toString()));
    }

    private void insertAssetValueDebitDiffDetail(Context context, String tempTableName, CompanyOrgUnitInfo companyInfo, PeriodInfo periodInfo, List<String> accNumberList, String faCatId, String isUseCatNumber, String isUseCardAcct, boolean isCurrentPeriod, String voucherBizStatus) throws EASBizException, BOSException {
        String periodToString = this.getPeriodString(periodInfo);
        StringBuffer insertSql = new StringBuffer();
        insertSql.append(" Insert into " + tempTableName + " (FID, FBillID, FBillType, FBillNumber, FBillDate, FBillAmount, ");
        insertSql.append("FVoucherID, FVoucherPeriod, FVoucherNumber, FVoucherAmount, FAccountID) ");
        StringBuffer sql = new StringBuffer();
        sql = this.getFaCurCardDiffDetailSQL(periodToString, companyInfo, periodInfo, accNumberList, isUseCatNumber, isUseCardAcct, isCurrentPeriod, voucherBizStatus, faCatId, "fassetvalue", 1, "faccountassetid");
        DbUtil.execute((Context)context, (String)(insertSql.toString() + sql.toString()));
        sql = new StringBuffer();
        sql = this.getFaChangeBillAmountCHGDiffDetailSQL(periodToString, companyInfo, periodInfo, accNumberList, isUseCatNumber, isUseCardAcct, voucherBizStatus, faCatId, "ASSET", "toriginchg", 1, "faccountassetid");
        DbUtil.execute((Context)context, (String)(insertSql.toString() + sql.toString()));
        sql = new StringBuffer();
        if ("true".equals(isUseCatNumber)) {
            sql = this.getFaChangeBillCatCHGDiffDetailSQL(periodToString, companyInfo, periodInfo, accNumberList, voucherBizStatus, faCatId, "fassetvalue", "toriginchg", 1);
            DbUtil.execute((Context)context, (String)(insertSql.toString() + sql.toString()));
        }
        sql = new StringBuffer();
        if ("true".equals(isUseCardAcct)) {
            sql = this.getFaChangeBillAccountCHGDiffDetailSQL(periodToString, companyInfo, periodInfo, accNumberList, voucherBizStatus, "fassetvalue", "toriginchg", 1, "faccountassetid");
            DbUtil.execute((Context)context, (String)(insertSql.toString() + sql.toString()));
        }
        sql = new StringBuffer();
        sql = this.getFaEvaluateBillDiffDetailSQL(periodToString, companyInfo, periodInfo, accNumberList, isUseCatNumber, isUseCardAcct, voucherBizStatus, faCatId, 1);
        DbUtil.execute((Context)context, (String)(insertSql.toString() + sql.toString()));
    }

    private void insertAssetValueCreditDiffDetail(Context context, String tempTableName, CompanyOrgUnitInfo companyInfo, PeriodInfo periodInfo, List<String> accNumberList, String faCatId, String isUseCatNumber, String isUseCardAcct, String voucherBizStatus) throws EASBizException, BOSException {
        String periodToString = this.getPeriodString(periodInfo);
        StringBuffer insertSql = new StringBuffer();
        insertSql.append(" Insert into " + tempTableName + " (FID, FBillID, FBillType, FBillNumber, FBillDate, FBillAmount, ");
        insertSql.append("FVoucherID, FVoucherPeriod, FVoucherNumber, FVoucherAmount, FAccountID) ");
        StringBuffer sql = new StringBuffer();
        sql = this.getFaChangeBillAmountCHGDiffDetailSQL(periodToString, companyInfo, periodInfo, accNumberList, isUseCatNumber, isUseCardAcct, voucherBizStatus, faCatId, "ASSET", "toriginchg", 0, "faccountassetid");
        DbUtil.execute((Context)context, (String)(insertSql.toString() + sql.toString()));
        sql = new StringBuffer();
        sql = this.getFaClearBillDiffDetailSQL(periodToString, companyInfo, periodInfo, accNumberList, isUseCatNumber, isUseCardAcct, voucherBizStatus, faCatId, "fclroriginal", 0, "faccountassetid");
        DbUtil.execute((Context)context, (String)(insertSql.toString() + sql.toString()));
        sql = new StringBuffer();
        sql = this.getFaEvaluateBillDiffDetailSQL(periodToString, companyInfo, periodInfo, accNumberList, isUseCatNumber, isUseCardAcct, voucherBizStatus, faCatId, 0);
        DbUtil.execute((Context)context, (String)(insertSql.toString() + sql.toString()));
    }

    private void insertAccuDeprDebitDiffDetail(Context context, String tempTableName, CompanyOrgUnitInfo companyInfo, PeriodInfo periodInfo, List<String> accNumberList, String faCatId, String isUseCatNumber, String isUseCardAcct, String voucherBizStatus) throws EASBizException, BOSException {
        String periodToString = this.getPeriodString(periodInfo);
        StringBuffer insertSql = new StringBuffer();
        insertSql.append(" Insert into " + tempTableName + " (FID, FBillID, FBillType, FBillNumber, FBillDate, FBillAmount, ");
        insertSql.append("FVoucherID, FVoucherPeriod, FVoucherNumber, FVoucherAmount, FAccountID) ");
        StringBuffer sql = new StringBuffer();
        sql = this.getFaChangeBillAmountCHGDiffDetailSQL(periodToString, companyInfo, periodInfo, accNumberList, isUseCatNumber, isUseCardAcct, voucherBizStatus, faCatId, "DEPRE", "taccudeprchg", 1, "faccountaccudeprid");
        DbUtil.execute((Context)context, (String)(insertSql.toString() + sql.toString()));
        sql = new StringBuffer();
        sql = this.getFaClearBillDiffDetailSQL(periodToString, companyInfo, periodInfo, accNumberList, isUseCatNumber, isUseCardAcct, voucherBizStatus, faCatId, "fclraddupdep", 1, "faccountaccudeprid");
        DbUtil.execute((Context)context, (String)(insertSql.toString() + sql.toString()));
        sql = new StringBuffer();
        sql = this.getFaEvaluateBillAccuDeprDiffDetailSQL(periodToString, companyInfo, periodInfo, accNumberList, isUseCatNumber, isUseCardAcct, voucherBizStatus, faCatId);
        DbUtil.execute((Context)context, (String)(insertSql.toString() + sql.toString()));
    }

    private void insertAccuDeprCreditDiffDetail(Context context, String tempTableName, CompanyOrgUnitInfo companyInfo, PeriodInfo periodInfo, List<String> accNumberList, String faCatId, String isUseCatNumber, String isUseCardAcct, boolean isCurrentPeriod, String voucherBizStatus) throws EASBizException, BOSException {
        String periodToString = this.getPeriodString(periodInfo);
        StringBuffer insertSql = new StringBuffer();
        insertSql.append(" Insert into " + tempTableName + " (FID, FBillID, FBillType, FBillNumber, FBillDate, FBillAmount, ");
        insertSql.append("FVoucherID, FVoucherPeriod, FVoucherNumber, FVoucherAmount, FAccountID) ");
        StringBuffer sql = new StringBuffer();
        sql = this.getFaCurCardDiffDetailSQL(periodToString, companyInfo, periodInfo, accNumberList, isUseCatNumber, isUseCardAcct, isCurrentPeriod, voucherBizStatus, faCatId, "faccudepr", 0, "faccountaccudeprid");
        DbUtil.execute((Context)context, (String)(insertSql.toString() + sql.toString()));
        sql = new StringBuffer();
        sql = this.getFaChangeBillAmountCHGDiffDetailSQL(periodToString, companyInfo, periodInfo, accNumberList, isUseCatNumber, isUseCardAcct, voucherBizStatus, faCatId, "DEPRE", "taccudeprchg", 0, "faccountaccudeprid");
        DbUtil.execute((Context)context, (String)(insertSql.toString() + sql.toString()));
        sql = new StringBuffer();
        if ("true".equals(isUseCatNumber)) {
            sql = this.getFaChangeBillCatCHGDiffDetailSQL(periodToString, companyInfo, periodInfo, accNumberList, voucherBizStatus, faCatId, "faccudepr", "taccudeprchg", 0);
            DbUtil.execute((Context)context, (String)(insertSql.toString() + sql.toString()));
        }
        sql = new StringBuffer();
        if ("true".equals(isUseCardAcct)) {
            sql = this.getFaChangeBillAccountCHGDiffDetailSQL(periodToString, companyInfo, periodInfo, accNumberList, voucherBizStatus, "faccudepr", "taccudeprchg", 0, "faccountaccudeprid");
            DbUtil.execute((Context)context, (String)(insertSql.toString() + sql.toString()));
        }
        sql = new StringBuffer();
        sql = this.getFaDepreciationDiffDetailSQL(periodToString, companyInfo, periodInfo, accNumberList, isUseCatNumber, isUseCardAcct, voucherBizStatus, faCatId);
        DbUtil.execute((Context)context, (String)(insertSql.toString() + sql.toString()));
    }

    private StringBuffer insertDecValueDebitDiffDetail(Context context, String tempTableName, CompanyOrgUnitInfo companyInfo, PeriodInfo periodInfo, List<String> accNumberList, String faCatId, String isUseCatNumber, String isUseCardAcct, String voucherBizStatus) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        String periodToString = this.getPeriodString(periodInfo);
        StringBuffer insertSql = new StringBuffer();
        insertSql.append(" Insert into " + tempTableName + " (FID, FBillID, FBillType, FBillNumber, FBillDate, FBillAmount, ");
        insertSql.append("FVoucherID, FVoucherPeriod, FVoucherNumber, FVoucherAmount, FAccountID) ");
        sql = new StringBuffer();
        sql = this.getFaClearBillDiffDetailSQL(periodToString, companyInfo, periodInfo, accNumberList, isUseCatNumber, isUseCardAcct, voucherBizStatus, faCatId, "fclrdecprep", 1, "faccountdecvalueid");
        DbUtil.execute((Context)context, (String)(insertSql.toString() + sql.toString()));
        sql = new StringBuffer();
        sql = this.getFaDecValueDiffDetailSQL(periodToString, companyInfo, periodInfo, accNumberList, isUseCatNumber, isUseCardAcct, voucherBizStatus, faCatId, 1);
        DbUtil.execute((Context)context, (String)(insertSql.toString() + sql.toString()));
        return sql;
    }

    private void insertDecValueCreditDiffDetail(Context context, String tempTableName, CompanyOrgUnitInfo companyInfo, PeriodInfo periodInfo, List<String> accNumberList, String faCatId, String isUseCatNumber, String isUseCardAcct, boolean isCurrentPeriod, String voucherBizStatus) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        String periodToString = this.getPeriodString(periodInfo);
        StringBuffer insertSql = new StringBuffer();
        insertSql.append(" Insert into " + tempTableName + " (FID, FBillID, FBillType, FBillNumber, FBillDate, FBillAmount, ");
        insertSql.append("FVoucherID, FVoucherPeriod, FVoucherNumber, FVoucherAmount, FAccountID) ");
        sql = new StringBuffer();
        sql = this.getFaCurCardDiffDetailSQL(periodToString, companyInfo, periodInfo, accNumberList, isUseCatNumber, isUseCardAcct, isCurrentPeriod, voucherBizStatus, faCatId, "fdecvalue", 0, "faccountdecvalueid");
        DbUtil.execute((Context)context, (String)(insertSql.toString() + sql.toString()));
        sql = new StringBuffer();
        if ("true".equals(isUseCatNumber)) {
            sql = this.getFaChangeBillCatCHGDiffDetailSQL(periodToString, companyInfo, periodInfo, accNumberList, voucherBizStatus, faCatId, "fdecvalue", "tdecvaluechg", 0);
            DbUtil.execute((Context)context, (String)(insertSql.toString() + sql.toString()));
        }
        sql = new StringBuffer();
        if ("true".equals(isUseCardAcct)) {
            sql = this.getFaChangeBillAccountCHGDiffDetailSQL(periodToString, companyInfo, periodInfo, accNumberList, voucherBizStatus, "fdecvalue", "tdecvaluechg", 0, "faccountdecvalueid");
            DbUtil.execute((Context)context, (String)(insertSql.toString() + sql.toString()));
        }
        sql = new StringBuffer();
        sql = this.getFaDecValueDiffDetailSQL(periodToString, companyInfo, periodInfo, accNumberList, isUseCatNumber, isUseCardAcct, voucherBizStatus, faCatId, 0);
        DbUtil.execute((Context)context, (String)(insertSql.toString() + sql.toString()));
    }

    private StringBuffer getFaDepreciationDiffDetailSQL(String periodToString, CompanyOrgUnitInfo companyInfo, PeriodInfo periodInfo, List<String> accNumberList, String isUseCatNumber, String isUseCardAcct, String voucherBizStatus, String faCatId) {
        StringBuffer sql = new StringBuffer();
        sql.append(" select newbosid('00000000') FID, card.billid FBillID, N'6\u56fa\u5b9a\u8d44\u4ea7\u6298\u65e7' FBillType, N'" + periodToString + "' FBillNumber, ");
        sql.append("        card.billDate FBillDate, card.billamount FBillAmount, gl.voucherid FVoucherID, N'" + periodToString + "' FVoucherPeriod, ");
        sql.append("        gl.vouchernumber FVoucherNumber, gl.localamount FVoucherAmount, gl.accountid FAccountID ");
        sql.append("   from (");
        sql.append("         select t.fid billid, t.fbizdate billDate, sum(en.fdepreciation) billamount ");
        sql.append("           from t_fa_fadepreciation t ");
        sql.append("          inner join t_fa_fadepreciationentry en on en.flnkfadepreentry = t.fid ");
        sql.append("          inner join t_fa_facurcard cur on cur.fid = en.ffacurcardid ");
        if ("true".equals(isUseCatNumber)) {
            sql.append("       left outer join t_fa_cat cat on cat.fid = cur.fassetcatid ");
        }
        if ("true".equals(isUseCardAcct)) {
            sql.append("       left outer join t_bd_accountview accv on accv.fid = cur.faccountaccudeprid");
        }
        sql.append("          where t.fcompanyid = '").append(companyInfo.getId().toString()).append("' ");
        sql.append("            and t.fperiod = '").append(periodInfo.getId().toString()).append("' ");
        sql.append("            and t.fcheckedstatus = ").append(2);
        sql.append("            and t.ffivouchered = 1 ");
        if ("true".equals(isUseCatNumber)) {
            sql.append(" and charindex(select Flongnumber from T_FA_Cat where fid= '" + faCatId + "', cat.flongnumber) = 1  ");
        }
        if ("true".equals(isUseCardAcct)) {
            sql.append("    and (accv.Flongnumber = '").append(accNumberList.get(0)).append("' or accv.Flongnumber like '").append(accNumberList.get(0)).append("%') ");
        }
        sql.append("         group by t.fid, t.fbizdate");
        sql.append("        ) card ");
        sql.append("     left outer join (");
        sql.append("         select c.fid cardid, voucher.fid voucherid, voucher.fnumber vouchernumber, ");
        sql.append("                vouen.faccountid accountid,sum(vouen.flocalamount) localamount ");
        sql.append("           from t_fa_fadepreciation c ");
        sql.append("          inner join t_bot_relation bot on bot.fsrcobjectid = c.fid ");
        sql.append("          inner join t_gl_voucher voucher on voucher.fid = bot.fdestobjectid ");
        sql.append("          inner join t_gl_voucherentry vouen on vouen.fbillid = voucher.fid ");
        sql.append("          inner join t_bd_accountview acc on acc.fid = vouen.faccountid ");
        sql.append("          where c.fcompanyid = '").append(companyInfo.getId().toString()).append("' ");
        sql.append("            and c.fperiod = '").append(periodInfo.getId().toString()).append("' ");
        sql.append("            and c.fcheckedstatus = ").append(2);
        sql.append("            and c.ffivouchered = 1 ");
        sql.append("            and voucher.fbizstatus in ").append(voucherBizStatus);
        sql.append("            and vouen.fentrydc = 0 ");
        if (accNumberList.size() == 1) {
            sql.append("    and (acc.Flongnumber = '").append(accNumberList.get(0)).append("' or acc.Flongnumber like '").append(accNumberList.get(0)).append("%') ");
        } else if (accNumberList.size() > 1) {
            int size = accNumberList.size();
            for (int i = 0; i < size; ++i) {
                sql.append(i == 0 ? " and (acc.Flongnumber = '" + accNumberList.get(i) + "' or acc.Flongnumber like '" + accNumberList.get(0) + "%' " : " or acc.Flongnumber = '" + accNumberList.get(i) + "' or acc.Flongnumber like '" + accNumberList.get(0) + "%' ");
                sql.append(i == size - 1 ? " ) " : "");
            }
        }
        sql.append("            group by c.fid, voucher.fid, voucher.fnumber, vouen.faccountid ");
        sql.append("       ) gl on gl.cardid = card.billid ");
        return sql;
    }

    private StringBuffer getFaCurCardDiffDetailSQL(String periodToString, CompanyOrgUnitInfo companyInfo, PeriodInfo periodInfo, List<String> accNumberList, String isUseCatNumber, String isUseCardAcct, boolean isCurrentPeriod, String voucherBizStatus, String faCatId, String amountField, int entryDC, String accountField) {
        StringBuffer sql = new StringBuffer();
        sql.append("Select newbosid('00000000') FID, card.FID FBillID, N'1\u56fa\u5b9a\u8d44\u4ea7\u5361\u7247' FBillType, card.FNumber FBillNumber, ");
        sql.append("card.ffiaccountdate FBillDate, bak." + amountField + " FBillAmount, gl.voucherid FVoucherID, N'" + periodToString + "' FVoucherPeriod,");
        sql.append("gl.vouchernumber FVoucherNumber, gl.localamount FVoucherAmount, gl.accountid FAccountID ");
        if (isCurrentPeriod) {
            sql.append("from t_fa_facurcard card ");
            sql.append("   inner join t_fa_fabakcard bak on (bak.ffacurcardid = card.fid and bak.fbilltype = ").append(1).append(") ");
        } else {
            sql.append("from t_fa_famoncard card ");
            sql.append("   inner join t_fa_fabakcard bak on (bak.ffacurcardid = card.ffacurcardid and bak.fbilltype = ").append(1).append(") ");
        }
        sql.append("left outer join (");
        sql.append(" select c.fid cardid, voucher.fid voucherid, voucher.fnumber vouchernumber, ");
        sql.append("        vouen.faccountid accountid,sum(vouen.flocalamount) localamount ");
        sql.append("   from t_fa_facurcard c ");
        sql.append("  inner join t_gl_voucher voucher on voucher.fid = c.fvoucher ");
        sql.append("  inner join t_gl_voucherentry vouen on vouen.fbillid = voucher.fid ");
        sql.append("  inner join t_bd_accountview acc on acc.fid = vouen.faccountid ");
        sql.append("  where c.fcompanyid = '").append(companyInfo.getId()).append("' ");
        sql.append("    and c.fperiodid = '").append(periodInfo.getId()).append("' ");
        sql.append("    and c.fcheckedstatus = ").append(2);
        sql.append("    and c.fhasnew = 1 ");
        sql.append("    and voucher.fbizstatus in ").append(voucherBizStatus);
        sql.append("    and vouen.fentrydc = ").append(entryDC);
        if (accNumberList.size() == 1) {
            sql.append("    and (acc.Flongnumber = '").append(accNumberList.get(0)).append("' or acc.Flongnumber like '").append(accNumberList.get(0)).append("%') ");
        } else if (accNumberList.size() > 1) {
            int size = accNumberList.size();
            for (int i = 0; i < size; ++i) {
                sql.append(i == 0 ? " and (acc.Flongnumber = '" + accNumberList.get(i) + "' or acc.Flongnumber like '" + accNumberList.get(0) + "%' " : " or acc.Flongnumber = '" + accNumberList.get(i) + "' or acc.Flongnumber like '" + accNumberList.get(0) + "%' ");
                sql.append(i == size - 1 ? " ) " : "");
            }
        }
        sql.append("  group by c.fid, voucher.fid, voucher.fnumber, vouen.faccountid) gl on (gl.cardid = card.fid and gl.accountid = card." + accountField + ") ");
        if ("true".equals(isUseCatNumber)) {
            sql.append(" left outer join t_fa_cat cat on cat.fid = card.fassetcatid ");
        }
        if ("true".equals(isUseCardAcct)) {
            sql.append(" left outer join t_bd_accountview accv on accv.fid = card.").append(accountField);
        }
        sql.append(" where card.fcompanyid = '").append(companyInfo.getId()).append("' ");
        if (isCurrentPeriod) {
            sql.append("   and card.fperiodid = '").append(periodInfo.getId()).append("' ");
        } else {
            sql.append("   and card.ffaperiodid = '").append(periodInfo.getId()).append("' ");
            sql.append("   and card.fperiodid = '").append(periodInfo.getId()).append("' ");
        }
        sql.append("  and card.fcheckedstatus = ").append(2);
        sql.append("  and bak.").append(amountField).append(" > 0 ");
        sql.append("  and card.fhasnew = 1 ");
        if ("true".equals(isUseCatNumber)) {
            sql.append(" and charindex(select Flongnumber from T_FA_Cat where fid= '" + faCatId + "', cat.flongnumber) = 1  ");
        }
        if ("true".equals(isUseCardAcct)) {
            sql.append("    and (accv.Flongnumber = '").append(accNumberList.get(0)).append("' or accv.Flongnumber like '").append(accNumberList.get(0)).append("%') ");
        }
        return sql;
    }

    private StringBuffer getFaChangeBillAmountCHGDiffDetailSQL(String periodToString, CompanyOrgUnitInfo companyInfo, PeriodInfo periodInfo, List<String> accNumberList, String isUseCatNumber, String isUseCardAcct, String voucherBizStatus, String faCatId, String accountType, String amountField, int entryDC, String accountField) {
        String operator = "ASSET".equals(accountType) && entryDC == 1 || "DEPRE".equals(accountType) && entryDC == 0 ? ">" : "<";
        StringBuffer sql = new StringBuffer();
        sql.append("Select newbosid('00000000') FID, card.FID FBillID, N'2\u53d8\u66f4\u5355' FBillType, card.FNumber FBillNumber, ");
        sql.append("card.fchangedate FBillDate, ABS(en." + amountField + ") FBillAmount, gl.voucherid FVoucherID, N'" + periodToString + "' FVoucherPeriod,");
        sql.append("gl.vouchernumber FVoucherNumber, gl.localamount FVoucherAmount, gl.accountid FAccountID ");
        sql.append("  from t_fa_fachangebill card ");
        sql.append(" inner join t_fa_fachangebillentry en on en.fchangebillid = card.fid ");
        sql.append(" inner join t_fa_facurcard cur on cur.fid = en.fcurcardid ");
        sql.append(" left outer join t_fa_faevaluatebillentry evalen on evalen.ffachangebillid = card.fid ");
        sql.append("  left outer join (");
        sql.append("  select c.fid cardid, voucher.fid voucherid, voucher.fnumber vouchernumber,");
        sql.append("         vouen.faccountid accountid,sum(vouen.flocalamount) localamount ");
        sql.append("    from t_fa_fachangebill c ");
        sql.append("   inner join t_fa_fachangebillentry en on en.fchangebillid = c.fid ");
        sql.append("   inner join t_fa_facurcard cur on cur.fid = en.fcurcardid ");
        sql.append("   inner join t_gl_voucher voucher on voucher.fid = c.fvoucherid ");
        sql.append("   inner join t_gl_voucherentry vouen on vouen.fbillid = voucher.fid ");
        sql.append("   inner join t_bd_accountview acc on acc.fid = vouen.faccountid ");
        sql.append("  where c.fcompanyid = '").append(companyInfo.getId()).append("' ");
        sql.append("    and c.fperiodid = '").append(periodInfo.getId()).append("' ");
        sql.append("    and c.fcheckedstatus = ").append(2);
        sql.append("    and en." + amountField + operator + " 0 ");
        sql.append("    and voucher.fbizstatus in ").append(voucherBizStatus);
        sql.append("    and vouen.fentrydc = " + entryDC);
        if (accNumberList.size() == 1) {
            sql.append("    and (acc.Flongnumber = '").append(accNumberList.get(0)).append("' or acc.Flongnumber like '").append(accNumberList.get(0)).append("%') ");
        } else if (accNumberList.size() > 1) {
            int size = accNumberList.size();
            for (int i = 0; i < size; ++i) {
                sql.append(i == 0 ? " and (acc.Flongnumber = '" + accNumberList.get(i) + "' or acc.Flongnumber like '" + accNumberList.get(0) + "%' " : " or acc.Flongnumber = '" + accNumberList.get(i) + "' or acc.Flongnumber like '" + accNumberList.get(0) + "%' ");
                sql.append(i == size - 1 ? " ) " : "");
            }
        }
        sql.append("  group by c.fid, voucher.fid, voucher.fnumber, vouen.faccountid ) gl on gl.cardid = card.fid ");
        if ("true".equals(isUseCatNumber)) {
            sql.append(" left outer join t_fa_cat cat on cat.fid = cur.fassetcatid ");
        }
        if ("true".equals(isUseCardAcct)) {
            sql.append(" left outer join t_bd_accountview accv on accv.fid = cur." + accountField);
        }
        sql.append("  where card.fcompanyid = '").append(companyInfo.getId()).append("' ");
        sql.append("    and card.fperiodid = '").append(periodInfo.getId()).append("' ");
        sql.append("    and card.fcheckedstatus = ").append(2);
        sql.append("    and evalen.fid is null ");
        sql.append("    and en." + amountField + operator + " 0 ");
        if ("true".equals(isUseCatNumber)) {
            sql.append(" and charindex(select Flongnumber from T_FA_Cat where fid= '" + faCatId + "', cat.flongnumber) = 1  ");
        }
        if ("true".equals(isUseCardAcct)) {
            sql.append("    and (accv.Flongnumber = '").append(accNumberList.get(0)).append("' or accv.Flongnumber like '").append(accNumberList.get(0)).append("%') ");
        }
        return sql;
    }

    private StringBuffer getFaChangeBillCatCHGDiffDetailSQL(String periodToString, CompanyOrgUnitInfo companyInfo, PeriodInfo periodInfo, List<String> accNumberList, String voucherBizStatus, String faCatId, String amountField, String chgAmountField, int entryDC) {
        StringBuffer sql = new StringBuffer();
        sql.append("Select newbosid('00000000') FID, card.FID FBillID, N'2\u53d8\u66f4\u5355' FBillType, card.FNumber FBillNumber, ");
        sql.append("card.fchangedate FBillDate, cur." + amountField + " FBillAmount, gl.voucherid FVoucherID, N'" + periodToString + "' FVoucherPeriod,");
        sql.append("gl.vouchernumber FVoucherNumber, gl.localamount FVoucherAmount, gl.accountid FAccountID ");
        sql.append("  from t_fa_fachangebill card ");
        sql.append(" inner join t_fa_fachangebillentry en on en.fchangebillid = card.fid ");
        sql.append(" inner join t_fa_facurcard cur on cur.fid = en.fcurcardid ");
        sql.append(" inner join t_fa_fabizcard biz on biz.fid = en.fbizcardid ");
        sql.append(" inner join t_fa_fabakcard bak on bak.fid = biz.ffabakcardid ");
        sql.append("  left outer join (");
        sql.append("  select c.fid cardid, voucher.fid voucherid, voucher.fnumber vouchernumber,");
        sql.append("         vouen.faccountid accountid,sum(vouen.flocalamount) localamount ");
        sql.append("    from t_fa_fachangebill c ");
        sql.append("   inner join t_fa_fachangebillentry en on en.fchangebillid = c.fid ");
        sql.append("   inner join t_fa_facurcard cur on cur.fid = en.fcurcardid ");
        sql.append("   inner join t_gl_voucher voucher on voucher.fid = c.fvoucherid ");
        sql.append("   inner join t_gl_voucherentry vouen on vouen.fbillid = voucher.fid ");
        sql.append("   inner join t_bd_accountview acc on acc.fid = vouen.faccountid ");
        sql.append("  where c.fcompanyid = '").append(companyInfo.getId()).append("' ");
        sql.append("    and c.fperiodid = '").append(periodInfo.getId()).append("' ");
        sql.append("    and c.fcheckedstatus = ").append(2);
        sql.append("    and en." + chgAmountField + " = 0 ");
        sql.append("    and voucher.fbizstatus in ").append(voucherBizStatus);
        sql.append("    and vouen.fentrydc = " + entryDC);
        if (accNumberList.size() == 1) {
            sql.append("    and (acc.Flongnumber = '").append(accNumberList.get(0)).append("' or acc.Flongnumber like '").append(accNumberList.get(0)).append("%') ");
        } else if (accNumberList.size() > 1) {
            int size = accNumberList.size();
            for (int i = 0; i < size; ++i) {
                sql.append(i == 0 ? " and (acc.Flongnumber = '" + accNumberList.get(i) + "' or acc.Flongnumber like '" + accNumberList.get(0) + "%' " : " or acc.Flongnumber = '" + accNumberList.get(i) + "' or acc.Flongnumber like '" + accNumberList.get(0) + "%' ");
                sql.append(i == size - 1 ? " ) " : "");
            }
        }
        sql.append("  group by c.fid, voucher.fid, voucher.fnumber, vouen.faccountid ) gl on gl.cardid = card.fid ");
        sql.append(" left outer join t_fa_cat cat on cat.fid = cur.fassetcatid ");
        sql.append("  where card.fcompanyid = '").append(companyInfo.getId()).append("' ");
        sql.append("    and card.fperiodid = '").append(periodInfo.getId()).append("' ");
        sql.append("    and card.fcheckedstatus = ").append(2);
        sql.append("    and en." + chgAmountField + " = 0 ");
        sql.append("    and bak.fassetcatid <> biz.fassetcatid ");
        sql.append("    and charindex(select Flongnumber from T_FA_Cat where fid= '" + faCatId + "', cat.flongnumber) = 1  ");
        return sql;
    }

    private StringBuffer getFaChangeBillAccountCHGDiffDetailSQL(String periodToString, CompanyOrgUnitInfo companyInfo, PeriodInfo periodInfo, List<String> accNumberList, String voucherBizStatus, String amountField, String chgAmountField, int entryDC, String accountField) {
        StringBuffer sql = new StringBuffer();
        sql.append("Select newbosid('00000000') FID, card.FID FBillID, N'2\u53d8\u66f4\u5355' FBillType, card.FNumber FBillNumber, ");
        sql.append("card.fchangedate FBillDate, cur." + amountField + " FBillAmount, gl.voucherid FVoucherID, N'" + periodToString + "' FVoucherPeriod,");
        sql.append("gl.vouchernumber FVoucherNumber, gl.localamount FVoucherAmount, gl.accountid FAccountID ");
        sql.append("  from t_fa_fachangebill card ");
        sql.append(" inner join t_fa_fachangebillentry en on en.fchangebillid = card.fid ");
        sql.append(" inner join t_fa_facurcard cur on cur.fid = en.fcurcardid ");
        sql.append(" inner join t_fa_fabizcard biz on biz.fid = en.fbizcardid ");
        sql.append(" inner join t_fa_fabakcard bak on bak.fid = biz.ffabakcardid ");
        sql.append("  left outer join (");
        sql.append("  select c.fid cardid, voucher.fid voucherid, voucher.fnumber vouchernumber,");
        sql.append("         vouen.faccountid accountid,sum(vouen.flocalamount) localamount ");
        sql.append("    from t_fa_fachangebill c ");
        sql.append("   inner join t_fa_fachangebillentry en on en.fchangebillid = c.fid ");
        sql.append("   inner join t_fa_facurcard cur on cur.fid = en.fcurcardid ");
        sql.append("   inner join t_gl_voucher voucher on voucher.fid = c.fvoucherid ");
        sql.append("   inner join t_gl_voucherentry vouen on vouen.fbillid = voucher.fid ");
        sql.append("   inner join t_bd_accountview acc on acc.fid = vouen.faccountid ");
        sql.append("  where c.fcompanyid = '").append(companyInfo.getId()).append("' ");
        sql.append("    and c.fperiodid = '").append(periodInfo.getId()).append("' ");
        sql.append("    and c.fcheckedstatus = ").append(2);
        sql.append("    and en." + chgAmountField + " = 0 ");
        sql.append("    and voucher.fbizstatus in ").append(voucherBizStatus);
        sql.append("    and vouen.fentrydc = " + entryDC);
        if (accNumberList.size() == 1) {
            sql.append("    and (acc.Flongnumber = '").append(accNumberList.get(0)).append("' or acc.Flongnumber like '").append(accNumberList.get(0)).append("%') ");
        } else if (accNumberList.size() > 1) {
            int size = accNumberList.size();
            for (int i = 0; i < size; ++i) {
                sql.append(i == 0 ? " and (acc.Flongnumber = '" + accNumberList.get(i) + "' or acc.Flongnumber like '" + accNumberList.get(0) + "%' " : " or acc.Flongnumber = '" + accNumberList.get(i) + "' or acc.Flongnumber like '" + accNumberList.get(0) + "%' ");
                sql.append(i == size - 1 ? " ) " : "");
            }
        }
        sql.append("  group by c.fid, voucher.fid, voucher.fnumber, vouen.faccountid ) gl on gl.cardid = card.fid ");
        sql.append(" left outer join t_bd_accountview accv on accv.fid = cur." + accountField);
        sql.append("  where card.fcompanyid = '").append(companyInfo.getId()).append("' ");
        sql.append("    and card.fperiodid = '").append(periodInfo.getId()).append("' ");
        sql.append("    and card.fcheckedstatus = ").append(2);
        sql.append("    and en." + chgAmountField + " = 0 ");
        sql.append("    and bak." + accountField + " <> biz." + accountField);
        sql.append("    and (accv.Flongnumber = '").append(accNumberList.get(0)).append("'  or accv.Flongnumber like '").append(accNumberList.get(0)).append("%') ");
        return sql;
    }

    private StringBuffer getFaClearBillDiffDetailSQL(String periodToString, CompanyOrgUnitInfo companyInfo, PeriodInfo periodInfo, List<String> accNumberList, String isUseCatNumber, String isUseCardAcct, String voucherBizStatus, String faCatId, String amountField, int entryDC, String accountField) {
        StringBuffer sql = new StringBuffer();
        sql.append(" select newbosid('00000000') FID, card.billid FBillID, N'3\u6e05\u7406\u5355' FBillType, card.billnumber FBillNumber, ");
        sql.append("        card.billdate FBillDate, card.billamount FBillAmount, gl.voucherid FVoucherID, N'").append(periodToString);
        sql.append("'       FVoucherPeriod, gl.vouchernumber FVoucherNumber, gl.localamount FVoucherAmount, gl.accountid FAccountID ");
        sql.append("   from (");
        sql.append("         select t.fid billid, t.fnumber billnumber, t.fcleardate billdate, sum(en." + amountField + ") billamount ");
        sql.append("           from t_fa_clearbill t ");
        sql.append("          inner join t_fa_clearbillentry en on en.fentryid = t.fid ");
        sql.append("          inner join t_fa_facurcard cur on cur.fid = en.fcurcardid ");
        if ("true".equals(isUseCatNumber)) {
            sql.append("       left outer join t_fa_cat cat on cat.fid = cur.fassetcatid ");
        }
        if ("true".equals(isUseCardAcct)) {
            sql.append("       left outer join t_bd_accountview accv on accv.fid = cur." + accountField);
        }
        sql.append("          where t.fcompanyid = '").append(companyInfo.getId().toString()).append("' ");
        sql.append("            and t.fperiodid = '").append(periodInfo.getId().toString()).append("' ");
        sql.append("            and t.fcheckedstatus = ").append(2);
        sql.append("            and en." + amountField + " > 0 ");
        if ("true".equals(isUseCatNumber)) {
            sql.append(" and charindex(select Flongnumber from T_FA_Cat where fid= '" + faCatId + "', cat.flongnumber) = 1  ");
        }
        if ("true".equals(isUseCardAcct)) {
            sql.append("    and (accv.Flongnumber = '").append(accNumberList.get(0)).append("' or accv.Flongnumber like '").append(accNumberList.get(0)).append("%') ");
        }
        sql.append("          group by t.fid, t.fnumber, t.fcleardate");
        sql.append("         ) card ");
        sql.append("  left outer join (");
        sql.append("      select c.fid cardid, voucher.fid voucherid, voucher.fnumber vouchernumber,  ");
        sql.append("             vouen.faccountid accountid,sum(vouen.flocalamount) localamount ");
        sql.append("        from t_fa_clearbill c ");
        sql.append("       inner join t_fa_clearbillentry cen on cen.fentryid = c.fid ");
        sql.append("       inner join t_gl_voucher voucher on voucher.fid = c.fvoucherid ");
        sql.append("       inner join t_gl_voucherentry vouen on vouen.fbillid = voucher.fid ");
        sql.append("       inner join t_bd_accountview acc on acc.fid = vouen.faccountid ");
        sql.append("       where c.fcompanyid = '").append(companyInfo.getId().toString()).append("' ");
        sql.append("         and c.fperiodid = '").append(periodInfo.getId().toString()).append("' ");
        sql.append("         and c.fcheckedstatus = ").append(2);
        sql.append("         and cen." + amountField + " > 0 ");
        sql.append("         and voucher.fbizstatus in ").append(voucherBizStatus);
        sql.append("         and vouen.fentrydc = " + entryDC);
        if (accNumberList.size() == 1) {
            sql.append("    and (acc.Flongnumber = '").append(accNumberList.get(0)).append("' or acc.Flongnumber like '").append(accNumberList.get(0)).append("%') ");
        } else if (accNumberList.size() > 1) {
            int size = accNumberList.size();
            for (int i = 0; i < size; ++i) {
                sql.append(i == 0 ? " and (acc.Flongnumber = '" + accNumberList.get(i) + "' or acc.Flongnumber like '" + accNumberList.get(0) + "%' " : " or acc.Flongnumber = '" + accNumberList.get(i) + "' or acc.Flongnumber like '" + accNumberList.get(0) + "%' ");
                sql.append(i == size - 1 ? " ) " : "");
            }
        }
        sql.append("    group by c.fid, voucher.fid, voucher.fnumber, vouen.faccountid ) gl on gl.cardid = card.billid ");
        return sql;
    }

    private StringBuffer getFaEvaluateBillDiffDetailSQL(String periodToString, CompanyOrgUnitInfo companyInfo, PeriodInfo periodInfo, List<String> accNumberList, String isUseCatNumber, String isUseCardAcct, String voucherBizStatus, String faCatId, int entryDC) {
        String operator = entryDC == 1 ? ">" : "<";
        StringBuffer sql = new StringBuffer();
        sql.append(" select newbosid('00000000') FID, card.billid FBillID, N'4\u8bc4\u4f30\u5355' FBillType, card.billnumber FBillNumber, ");
        sql.append("        card.billdate FBillDate, card.billamount FBillAmount, gl.voucherid FVoucherID, N'");
        sql.append(periodToString + "' FVoucherPeriod, gl.vouchernumber FVoucherNumber, gl.localamount FVoucherAmount, gl.accountid FAccountID ");
        sql.append("   from (");
        sql.append("         select t.fid billid, t.fnumber billnumber, t.fadjustdate billdate, sum(abs(eva.fevavalue-bak.fassetvalue)) billamount ");
        sql.append("           from t_fa_faevaluatebill t ");
        sql.append("          inner join t_fa_faevaluatebillentry en on en.ffaevaluatebillid = t.fid ");
        sql.append("          inner join t_fa_facurcard cur on cur.fid = en.fcurcardid ");
        sql.append("          inner join T_FA_FaEvavalue eva on eva.fevaentryid = en.fid ");
        sql.append("          inner join t_fa_fachangebill chg on chg.fid = en.ffachangebillid ");
        sql.append("          inner join t_fa_fachangebillentry chge on chge.fchangebillid = chg.fid ");
        sql.append("          inner join t_fa_fabizcard biz on biz.fid = chge.fbizcardid ");
        sql.append("          inner join t_fa_fabakcard bak on bak.fid = biz.ffabakcardid ");
        if ("true".equals(isUseCatNumber)) {
            sql.append("       left outer join t_fa_cat cat on cat.fid = cur.fassetcatid ");
        }
        if ("true".equals(isUseCardAcct)) {
            sql.append("       left outer join t_bd_accountview accv on accv.fid = cur.Faccountassetid ");
        }
        sql.append("          where t.fcompanyid = '").append(companyInfo.getId()).append("' ");
        sql.append("            and t.fperiodid = '").append(periodInfo.getId()).append("' ");
        sql.append("            and t.fcheckedstatus = ").append(2);
        sql.append("            and en.ffachangebillid is not null ");
        sql.append("            and eva.fmaintype = 1 ");
        sql.append("            and eva.fsubtype = '00' ");
        sql.append("            and eva.fevavalue " + operator + " bak.fassetvalue ");
        if ("true".equals(isUseCatNumber)) {
            sql.append(" and charindex(select Flongnumber from T_FA_Cat where fid= '" + faCatId + "', cat.flongnumber) = 1  ");
        }
        if ("true".equals(isUseCardAcct)) {
            sql.append("    and (accv.Flongnumber = '").append(accNumberList.get(0)).append("' or accv.Flongnumber like '").append(accNumberList.get(0)).append("%') ");
        }
        sql.append("          group by t.fid, t.fnumber, t.fadjustdate ");
        sql.append("         ) card ");
        sql.append("   left outer join (");
        sql.append("   select c.fid cardid, voucher.fid voucherid, voucher.fnumber vouchernumber, ");
        sql.append("          vouen.faccountid accountid,sum(vouen.flocalamount) localamount ");
        sql.append("     from t_fa_faevaluatebill c ");
        sql.append("    inner join t_fa_faevaluatebillentry evalen on evalen.ffaevaluatebillid = c.fid ");
        sql.append("    inner join T_FA_FaEvavalue evaval on evaval.fevaentryid = evalen.fid ");
        sql.append("    inner join t_fa_fachangebill chg on chg.fid = evalen.ffachangebillid ");
        sql.append("    inner join t_fa_fachangebillentry chge on chge.fchangebillid = chg.fid ");
        sql.append("    inner join t_fa_fabizcard biz on biz.fid = chge.fbizcardid ");
        sql.append("    inner join t_fa_fabakcard bak on bak.fid = biz.ffabakcardid ");
        sql.append("    inner join t_gl_voucher voucher on voucher.fid = c.fvoucher ");
        sql.append("    inner join t_gl_voucherentry vouen on vouen.fbillid = voucher.fid ");
        sql.append("    inner join t_bd_accountview acc on acc.fid = vouen.faccountid ");
        sql.append("    where c.fcompanyid = '").append(companyInfo.getId()).append("' ");
        sql.append("      and c.fperiodid = '").append(periodInfo.getId()).append("' ");
        sql.append("      and c.fcheckedstatus = ").append(2);
        sql.append("      and evalen.ffachangebillid is not null ");
        sql.append("      and voucher.fbizstatus in ").append(voucherBizStatus);
        sql.append("      and vouen.fentrydc = " + entryDC);
        sql.append("      and evaval.fmaintype = 1 ");
        sql.append("      and evaval.fsubtype = '00' ");
        sql.append("      and evaval.fevavalue " + operator + " bak.fassetvalue ");
        if (accNumberList.size() == 1) {
            sql.append("    and (acc.Flongnumber = '").append(accNumberList.get(0)).append("' or acc.Flongnumber like '").append(accNumberList.get(0)).append("%') ");
        } else if (accNumberList.size() > 1) {
            int size = accNumberList.size();
            for (int i = 0; i < size; ++i) {
                sql.append(i == 0 ? " and (acc.Flongnumber = '" + accNumberList.get(i) + "' or acc.Flongnumber like '" + accNumberList.get(0) + "%' " : " or acc.Flongnumber = '" + accNumberList.get(i) + "' or acc.Flongnumber like '" + accNumberList.get(0) + "%' ");
                sql.append(i == size - 1 ? " ) " : "");
            }
        }
        sql.append("  group by c.fid, voucher.fid, voucher.fnumber, vouen.faccountid ) gl on gl.cardid = card.billid ");
        return sql;
    }

    private StringBuffer getFaEvaValueDiffDetailSQL(String periodToString, CompanyOrgUnitInfo companyInfo, PeriodInfo periodInfo, List<String> accNumberList, String isUseCatNumber, String isUseCardAcct, String voucherBizStatus, String faCatId, int entryDC) {
        String operator = entryDC == 1 ? ">" : "<";
        StringBuffer sql = new StringBuffer();
        sql.append(" select newbosid('00000000') FID, card.billid FBillID, N'4\u8bc4\u4f30\u5355' FBillType, card.billnumber FBillNumber, ");
        sql.append("        card.billdate FBillDate, card.billamount FBillAmount, gl.voucherid FVoucherID, N'");
        sql.append(periodToString + "' FVoucherPeriod, gl.vouchernumber FVoucherNumber, gl.localamount FVoucherAmount, gl.accountid FAccountID ");
        sql.append("   from (");
        sql.append("         select t.fid billid, t.fnumber billnumber, t.fadjustdate billdate, sum(abs(eva.fevavalue-cur.flastevalvalue)) billamount ");
        sql.append("           from t_fa_faevaluatebill t ");
        sql.append("          inner join t_fa_faevaluatebillentry en on en.ffaevaluatebillid = t.fid ");
        sql.append("          inner join t_fa_facurcard cur on cur.fid = en.fcurcardid ");
        sql.append("          inner join T_FA_FaEvavalue eva on eva.fevaentryid = en.fid ");
        if ("true".equals(isUseCatNumber)) {
            sql.append("       left outer join t_fa_cat cat on cat.fid = cur.fassetcatid ");
        }
        if ("true".equals(isUseCardAcct)) {
            sql.append("       left outer join t_bd_accountview accv on accv.fid = cur.Faccountassetid ");
        }
        sql.append("          where t.fcompanyid = '").append(companyInfo.getId()).append("' ");
        sql.append("            and t.fperiodid = '").append(periodInfo.getId()).append("' ");
        sql.append("            and t.fcheckedstatus = ").append(2);
        sql.append("            and eva.fmaintype = 1 ");
        sql.append("            and eva.fsubtype = '00' ");
        sql.append("            and eva.fevavalue " + operator + " cur.flastevalvalue ");
        if ("true".equals(isUseCatNumber)) {
            sql.append(" and charindex(select Flongnumber from T_FA_Cat where fid= '" + faCatId + "', cat.flongnumber) = 1  ");
        }
        if ("true".equals(isUseCardAcct)) {
            sql.append("    and (accv.Flongnumber = '").append(accNumberList.get(0)).append("' or accv.Flongnumber like '").append(accNumberList.get(0)).append("%') ");
        }
        sql.append("          group by t.fid, t.fnumber, t.fadjustdate ");
        sql.append("         ) card ");
        sql.append("   left outer join (");
        sql.append("   select c.fid cardid, voucher.fid voucherid, voucher.fnumber vouchernumber, ");
        sql.append("          vouen.faccountid accountid,sum(vouen.flocalamount) localamount ");
        sql.append("     from t_fa_faevaluatebill c ");
        sql.append("    inner join t_fa_faevaluatebillentry evalen on evalen.ffaevaluatebillid = c.fid ");
        sql.append("    inner join T_FA_FaEvavalue evaval on evaval.fevaentryid = evalen.fid ");
        sql.append("    inner join t_fa_facurcard cur on cur.fid = evalen.fcurcardid ");
        sql.append("    inner join t_gl_voucher voucher on voucher.fid = c.fvoucher ");
        sql.append("    inner join t_gl_voucherentry vouen on vouen.fbillid = voucher.fid ");
        sql.append("    inner join t_bd_accountview acc on acc.fid = vouen.faccountid ");
        sql.append("    where c.fcompanyid = '").append(companyInfo.getId()).append("' ");
        sql.append("      and c.fperiodid = '").append(periodInfo.getId()).append("' ");
        sql.append("      and c.fcheckedstatus = ").append(2);
        sql.append("      and voucher.fbizstatus in ").append(voucherBizStatus);
        sql.append("      and vouen.fentrydc = " + entryDC);
        sql.append("      and evaval.fmaintype = 1 ");
        sql.append("      and evaval.fsubtype = '00' ");
        sql.append("      and evaval.fevavalue " + operator + " cur.flastevalvalue ");
        if (accNumberList.size() == 1) {
            sql.append("    and (acc.Flongnumber = '").append(accNumberList.get(0)).append("' or acc.Flongnumber like '").append(accNumberList.get(0)).append("%') ");
        } else if (accNumberList.size() > 1) {
            int size = accNumberList.size();
            for (int i = 0; i < size; ++i) {
                sql.append(i == 0 ? " and (acc.Flongnumber = '" + accNumberList.get(i) + "' or acc.Flongnumber like '" + accNumberList.get(0) + "%' " : " or acc.Flongnumber = '" + accNumberList.get(i) + "' or acc.Flongnumber like '" + accNumberList.get(0) + "%' ");
                sql.append(i == size - 1 ? " ) " : "");
            }
        }
        sql.append("  group by c.fid, voucher.fid, voucher.fnumber, vouen.faccountid ) gl on gl.cardid = card.billid ");
        return sql;
    }

    private StringBuffer getFaEvaluateBillAccuDeprDiffDetailSQL(String periodToString, CompanyOrgUnitInfo companyInfo, PeriodInfo periodInfo, List<String> accNumberList, String isUseCatNumber, String isUseCardAcct, String voucherBizStatus, String faCatId) {
        StringBuffer sql = new StringBuffer();
        sql.append(" select newbosid('00000000') FID, card.billid FBillID, N'4\u8bc4\u4f30\u5355' FBillType, card.billnumber FBillNumber, ");
        sql.append("        card.billdate FBillDate, card.billamount FBillAmount, gl.voucherid FVoucherID, N'").append(periodToString);
        sql.append("'       FVoucherPeriod, gl.vouchernumber FVoucherNumber, gl.localamount FVoucherAmount, gl.accountid FAccountID ");
        sql.append("   from (");
        sql.append("         select t.fid billid, t.fnumber billnumber, t.fadjustdate billdate, sum(abs(changeen.taccudeprchg)) billamount ");
        sql.append("           from t_fa_faevaluatebill t ");
        sql.append("          inner join t_fa_faevaluatebillentry en on en.ffaevaluatebillid = t.fid ");
        sql.append("          inner join t_fa_fachangebill changebill on changebill.fid = en.ffachangebillid ");
        sql.append("          inner join t_fa_fachangebillentry changeen on changeen.fchangebillid = changebill.fid ");
        sql.append("          inner join t_fa_fabizcard bizcard on bizcard.fid = changeen.fbizcardid ");
        sql.append("          inner join t_fa_fabakcard bakcard on bakcard.fid = bizcard.ffabakcardid ");
        if ("true".equals(isUseCatNumber)) {
            sql.append("       left outer join t_fa_cat cat on cat.fid = bizcard.fassetcatid ");
        }
        if ("true".equals(isUseCardAcct)) {
            sql.append("       left outer join t_bd_accountview accv on accv.fid = bizcard.faccountaccudeprid ");
        }
        sql.append("          where t.fcompanyid = '").append(companyInfo.getId().toString()).append("' ");
        sql.append("            and t.fperiodid = '").append(periodInfo.getId().toString()).append("' ");
        sql.append("            and t.fcheckedstatus = ").append(2);
        sql.append("            and bakcard.faccudepr = abs(changeen.taccudeprchg) ");
        sql.append("            and bakcard.faccudepr > 0 ");
        if ("true".equals(isUseCatNumber)) {
            sql.append(" and charindex(select Flongnumber from T_FA_Cat where fid= '" + faCatId + "', cat.flongnumber) = 1  ");
        }
        if ("true".equals(isUseCardAcct)) {
            sql.append("    and (accv.Flongnumber = '").append(accNumberList.get(0)).append("' or accv.Flongnumber like '").append(accNumberList.get(0)).append("%') ");
        }
        sql.append("          group by t.fid, t.fnumber, t.fadjustdate ");
        sql.append("         ) card ");
        sql.append("   left outer join (");
        sql.append("         select c.fid cardid, voucher.fid voucherid, voucher.fnumber vouchernumber, ");
        sql.append("                vouen.faccountid accountid,sum(vouen.flocalamount) localamount ");
        sql.append("           from t_fa_faevaluatebill c ");
        sql.append("          inner join t_fa_faevaluatebillentry evalen on evalen.ffaevaluatebillid = c.fid ");
        sql.append("          inner join t_fa_fachangebill changebill on changebill.fid = evalen.ffachangebillid ");
        sql.append("          inner join t_fa_fachangebillentry changeen on changeen.fchangebillid = changebill.fid ");
        sql.append("          inner join t_fa_fabizcard bizcard on bizcard.fid = changeen.fbizcardid ");
        sql.append("          inner join t_fa_fabakcard bakcard on bakcard.fid = bizcard.ffabakcardid ");
        sql.append("          inner join t_gl_voucher voucher on voucher.fid = c.fvoucher ");
        sql.append("          inner join t_gl_voucherentry vouen on vouen.fbillid = voucher.fid ");
        sql.append("          inner join t_bd_accountview acc on acc.fid = vouen.faccountid ");
        sql.append("          where c.fcompanyid = '").append(companyInfo.getId().toString()).append("' ");
        sql.append("            and c.fperiodid = '").append(periodInfo.getId().toString()).append("' ");
        sql.append("            and c.fcheckedstatus = ").append(2);
        sql.append("            and bakcard.faccudepr = abs(changeen.taccudeprchg) ");
        sql.append("            and bakcard.faccudepr > 0 ");
        sql.append("            and voucher.fbizstatus in ").append(voucherBizStatus);
        sql.append("            and vouen.fentrydc = 1 ");
        if (accNumberList.size() == 1) {
            sql.append("    and (acc.Flongnumber = '").append(accNumberList.get(0)).append("' or acc.Flongnumber like '").append(accNumberList.get(0)).append("%') ");
        } else if (accNumberList.size() > 1) {
            int size = accNumberList.size();
            for (int i = 0; i < size; ++i) {
                sql.append(i == 0 ? " and (acc.Flongnumber = '" + accNumberList.get(i) + "' or acc.Flongnumber like '" + accNumberList.get(0) + "%' " : " or acc.Flongnumber = '" + accNumberList.get(i) + "' or acc.Flongnumber like '" + accNumberList.get(0) + "%' ");
                sql.append(i == size - 1 ? " ) " : "");
            }
        }
        sql.append("    group by c.fid, voucher.fid, voucher.fnumber, vouen.faccountid ) gl on gl.cardid = card.billid ");
        return sql;
    }

    private StringBuffer getFaDecValueDiffDetailSQL(String periodToString, CompanyOrgUnitInfo companyInfo, PeriodInfo periodInfo, List<String> accNumberList, String isUseCatNumber, String isUseCardAcct, String voucherBizStatus, String faCatId, int entryDC) {
        String operator = entryDC == 1 ? "<" : ">";
        StringBuffer sql = new StringBuffer();
        sql.append(" select newbosid('00000000') FID, card.billid FBillID, N'5\u56fa\u5b9a\u8d44\u4ea7\u51cf\u503c' FBillType, N'" + periodToString + "' FBillNumber, ");
        sql.append("        card.billDate FBillDate, card.billamount FBillAmount, gl.voucherid FVoucherID, N'").append(periodToString);
        sql.append("'       FVoucherPeriod, gl.vouchernumber FVoucherNumber, gl.localamount FVoucherAmount, gl.accountid FAccountID ");
        sql.append("   from (");
        sql.append("         select t.fid billid, t.fbizdate billDate, sum(en.fdecvalue) billamount ");
        sql.append("           from t_fa_fadecvalue t ");
        sql.append("          inner join t_fa_fadecvalueentry en on en.fheadid = t.fid ");
        sql.append("          inner join t_fa_facurcard cur on cur.fid = en.fcurcardid ");
        if ("true".equals(isUseCatNumber)) {
            sql.append("       left outer join t_fa_cat cat on cat.fid = cur.fassetcatid ");
        }
        if ("true".equals(isUseCardAcct)) {
            sql.append("       left outer join t_bd_accountview accv on accv.fid = cur.faccountdecvalueid ");
        }
        sql.append("          where t.fcompanyid = '").append(companyInfo.getId().toString()).append("' ");
        sql.append("            and t.fperiodid = '").append(periodInfo.getId().toString()).append("' ");
        sql.append("            and t.fcheckedstatus = ").append(2);
        sql.append("            and t.ffivouchered = 1 ");
        sql.append("            and en.fdecvalue " + operator + " 0 ");
        if ("true".equals(isUseCatNumber)) {
            sql.append(" and charindex(select Flongnumber from T_FA_Cat where fid= '" + faCatId + "', cat.flongnumber) = 1  ");
        }
        if ("true".equals(isUseCardAcct)) {
            sql.append("    and (accv.Flongnumber = '").append(accNumberList.get(0)).append("' or accv.Flongnumber like '").append(accNumberList.get(0)).append("%') ");
        }
        sql.append("          group by t.fid, t.fbizdate ");
        sql.append("         ) card ");
        sql.append("   left outer join (");
        sql.append("         select c.fid cardid, voucher.fid voucherid, voucher.fnumber vouchernumber, ");
        sql.append("                vouen.faccountid accountid,sum(vouen.flocalamount) localamount ");
        sql.append("           from t_fa_fadecvalue c ");
        sql.append("          inner join t_fa_fadecvalueentry cen on cen.fheadid = c.fid ");
        sql.append("          inner join t_bot_relation bot on bot.fsrcobjectid = c.fid ");
        sql.append("          inner join t_gl_voucher voucher on voucher.fid = bot.fdestobjectid ");
        sql.append("          inner join t_gl_voucherentry vouen on vouen.fbillid = voucher.fid ");
        sql.append("          inner join t_bd_accountview acc on acc.fid = vouen.faccountid ");
        sql.append("          where c.fcompanyid = '").append(companyInfo.getId().toString()).append("' ");
        sql.append("            and c.fperiodid = '").append(periodInfo.getId().toString()).append("' ");
        sql.append("            and c.fcheckedstatus = ").append(2);
        sql.append("            and c.ffivouchered = 1 ");
        sql.append("            and cen.fdecvalue " + operator + " 0 ");
        sql.append("            and voucher.fbizstatus in ").append(voucherBizStatus);
        sql.append("            and vouen.fentrydc = " + entryDC);
        if (accNumberList.size() == 1) {
            sql.append("    and (acc.Flongnumber = '").append(accNumberList.get(0)).append("' or acc.Flongnumber like '").append(accNumberList.get(0)).append("%') ");
        } else if (accNumberList.size() > 1) {
            int size = accNumberList.size();
            for (int i = 0; i < size; ++i) {
                sql.append(i == 0 ? " and (acc.Flongnumber = '" + accNumberList.get(i) + "' or acc.Flongnumber like '" + accNumberList.get(0) + "%' " : " or acc.Flongnumber = '" + accNumberList.get(i) + "' or acc.Flongnumber like '" + accNumberList.get(0) + "%' ");
                sql.append(i == size - 1 ? " ) " : "");
            }
        }
        sql.append("    group by c.fid, voucher.fid, voucher.fnumber, vouen.faccountid ) gl on gl.cardid = card.billid ");
        return sql;
    }

    private void dealWithDiffAmount(Context context, String tempTableName) throws BOSException {
        String sql = "select FID, FBillAmount, FVoucherID, FVoucherAmount, FAccountID from " + tempTableName + " where FVoucherID is not null order by FVoucherNumber, FAccountID";
        IRowSet rowset = DbUtil.executeQuery((Context)context, (String)sql);
        ArrayList<String> idList = new ArrayList<String>();
        String preVoucherId = null;
        String preAccountId = null;
        BigDecimal preVoucherAmount = this.ZERO;
        BigDecimal billAmountSum = this.ZERO;
        try {
            while (rowset.next()) {
                String id = rowset.getString("FID");
                BigDecimal billAmount = rowset.getBigDecimal("FBillAmount");
                String voucherId = rowset.getString("FVoucherID");
                String accountId = rowset.getString("FAccountID");
                BigDecimal voucherAmount = rowset.getBigDecimal("FVoucherAmount");
                if (idList.size() == 0 && StringUtils.isEmpty(preVoucherId)) {
                    idList.add(id);
                    preVoucherId = voucherId;
                    preAccountId = accountId;
                    preVoucherAmount = voucherAmount;
                    billAmountSum = billAmount;
                } else if (!StringUtils.isEmpty((String)voucherId) && voucherId.equals(preVoucherId) && accountId.equals(preAccountId)) {
                    idList.add(id);
                    preVoucherAmount = voucherAmount;
                    billAmountSum = billAmountSum.add(billAmount);
                } else {
                    this.updateDiffAmount(context, tempTableName, billAmountSum, preVoucherAmount, idList);
                    idList.clear();
                    preVoucherId = null;
                    preVoucherAmount = this.ZERO;
                    billAmountSum = this.ZERO;
                    idList.add(id);
                    preVoucherId = voucherId;
                    preVoucherAmount = voucherAmount;
                    billAmountSum = billAmount;
                }
                if (!rowset.isLast()) continue;
                this.updateDiffAmount(context, tempTableName, billAmountSum, preVoucherAmount, idList);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
    }

    private void updateDiffAmount(Context context, String tempTableName, BigDecimal billAmountSum, BigDecimal preVoucherAmount, List<String> idList) throws BOSException {
        int diffType;
        BigDecimal diffAmount = billAmountSum.subtract(preVoucherAmount);
        int n = diffType = diffAmount.compareTo(this.ZERO) != 0 ? 2 : 1;
        if (idList.size() == 0) {
            return;
        }
        String updateSql = "update " + tempTableName + " set FDiffAmount = " + diffAmount + ", FDiffType = " + diffType + " where FID in (";
        for (int i = 0; i < idList.size(); ++i) {
            updateSql = updateSql + "'" + idList.get(i) + "'";
            if (i == idList.size() - 1) continue;
            updateSql = updateSql + ",";
        }
        updateSql = updateSql + ") ";
        DbUtil.execute((Context)context, (String)updateSql);
    }

    private String getPeriodString(PeriodInfo periodInfo) throws EASBizException, BOSException {
        String resFullName = "com.kingdee.eas.basedata.assistant.PeriodResource";
        String s = EASCommonResource.getString((String)resFullName, (String)"periodformat", (Locale)this.getContext().getLocale());
        MessageFormat mf = new MessageFormat(s);
        String result = mf.format(new String[]{new Integer(periodInfo.getPeriodYear()).toString(), new Integer(periodInfo.getPeriodNumber()).toString()});
        if (periodInfo.isIsAdjustPeriod()) {
            result = result + "(" + EASCommonResource.getString((String)resFullName, (String)"PeriodAdjuxt", (Locale)this.getContext().getLocale()) + ")";
        }
        return result;
    }

    private PeriodInfo getPeriodInfo(CompanyOrgUnitInfo companyInfo, int periodYear, int periodNumber) throws EASBizException, BOSException {
        PeriodTypeInfo periodType = companyInfo.getAccountPeriodType();
        return PeriodFactory.getLocalInstance((Context)this.getContext()).getPeriodInfo(periodYear, periodNumber, periodType);
    }

    @Override
    public Map<String, Object> getData(Map<String, Object> condition) throws BOSException, EASBizException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("page", 0);
        map.put("total", 0);
        map.put("records", 0);
        map.put("rows", new ArrayList());
        try {
            int records = this.getRecords(condition);
            if (records <= 0) {
                return map;
            }
            String strPage = (String)condition.get("page");
            String strRows = (String)condition.get("rows");
            int page = Integer.parseInt(strPage);
            int rows = Integer.parseInt(strRows);
            int total = records / rows;
            if (total * rows < records) {
                ++total;
            }
            int from = (page - 1) * rows;
            IRowSet rowSet = this.executeQuery(condition, from, rows);
            ArrayList<Map<String, Object>> datas = new ArrayList<Map<String, Object>>(rowSet.size());
            while (rowSet.next()) {
                Map<String, Object> row = this.wrapRow(condition, rowSet);
                if (row == null) continue;
                datas.add(row);
            }
            map.put("page", page);
            map.put("total", total);
            map.put("records", records);
            map.put("rows", datas);
            return map;
        }
        catch (SQLException e) {
            throw new BOSException();
        }
    }

    protected int getRecords(Map<String, Object> condition) throws EASBizException, BOSException, SQLException {
        String strRecords = (String)condition.get("records");
        if (strRecords != null && strRecords.length() > 0) {
            return Integer.parseInt(strRecords);
        }
        String queryId = (String)condition.get("queryId");
        if (queryId == null || queryId.length() == 0) {
            return 0;
        }
        String diffType = (String)condition.get("diffType");
        StringBuffer sql = new StringBuffer();
        sql.append("select count(*) from " + queryId + " \n");
        if (!"0".equals(diffType)) {
            sql.append("where FDiffType = " + diffType + " \n");
        } else {
            sql.append("where FDiffType is null or FIsSum = 0 \n");
        }
        IRowSet rs = DbUtil.executeQuery((Context)this.getContext(), (String)sql.toString());
        if (rs.next()) {
            return rs.getInt(1);
        }
        return 0;
    }

    protected IRowSet executeQuery(Map<String, Object> condition, int from, int rows) throws EASBizException, BOSException {
        String queryId = (String)condition.get("queryId");
        String diffType = (String)condition.get("diffType");
        StringBuffer sql = new StringBuffer();
        sql.append("select FID,FBillID,billType FBillType,FBillNumber,FBillDate,FBillAmount,FVoucherID, \n");
        sql.append("FVoucherPeriod,FVoucherNumber,FVoucherAmount,FDiffAmount,FDiffType,FIsSum from ");
        sql.append("(select FID,FBillID,substring(FBillType, 2, 10) billType,FBillNumber,FBillDate,FBillAmount,FVoucherID, \n");
        sql.append("FVoucherPeriod,FVoucherNumber,FVoucherAmount,FDiffAmount,FDiffType,FIsSum from " + queryId + " \n");
        if (!"0".equals(diffType)) {
            sql.append("where FDiffType = " + diffType + " \n");
        } else {
            sql.append("where FDiffType is null or FIsSum = 0 \n");
        }
        sql.append("order by FIsSum, FVoucherNumber, FAccountID, FBillType, FBillNumber) as temp ");
        return DbUtil.executeQuery((Context)this.getContext(), (String)sql.toString(), (int)from, (int)rows);
    }

    protected Map<String, Object> wrapRow(Map<String, Object> condition, IRowSet rowSet) throws SQLException {
        HashMap<String, Object> row = new HashMap<String, Object>();
        row.put("FID", rowSet.getString("FID"));
        row.put("FBillID", rowSet.getString("FBillID"));
        row.put("FBillType", rowSet.getString("FBillType"));
        row.put("FBillNumber", rowSet.getString("FBillNumber"));
        Date date = rowSet.getDate("FBillDate");
        if (date != null) {
            row.put("FBillDate", this.format.format(date));
        } else {
            row.put("FBillDate", null);
        }
        row.put("FBillAmount", rowSet.getBigDecimal("FBillAmount"));
        String FVoucherID = rowSet.getString("FVoucherID");
        if (FVoucherID == null || FVoucherID.length() == 0) {
            FVoucherID = BOSUuid.create((String)"12345678").toString();
        }
        row.put("FVoucherID", FVoucherID);
        row.put("FVoucherPeriod", rowSet.getString("FVoucherPeriod"));
        row.put("FVoucherNumber", rowSet.getString("FVoucherNumber"));
        row.put("FVoucherAmount", rowSet.getBigDecimal("FVoucherAmount"));
        row.put("FDiffAmount", rowSet.getBigDecimal("FDiffAmount"));
        row.put("FDiffType", rowSet.getString("FDiffType"));
        row.put("FIsSum", rowSet.getInt("FIsSum"));
        return row;
    }

    @Override
    public void release(Map<String, Object> condition) throws BOSException, EASBizException {
        if (condition == null) {
            return;
        }
        String queryId = (String)condition.get("queryId");
        if (queryId == null || queryId.length() == 0) {
            return;
        }
        try {
            TempTablePool.getInstance((Context)this.getContext()).releaseTable(queryId);
        }
        catch (Exception e) {
            logger.error((Object)"Release tempTable error!", (Throwable)e);
        }
    }
}

