/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.services.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.annotation.Component;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexLockType;
import com.kingdee.eas.base.netctrl.MutexParameter;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.manage.FaPeriodCloseBatchFacadeFactory;
import com.kingdee.eas.fi.fa.manage.FaPeriodCloseFacadeFactory;
import com.kingdee.eas.fi.fa.manage.IFaPeriodCloseBatchFacade;
import com.kingdee.eas.fi.fa.manage.IFaPeriodCloseFacade;
import com.kingdee.eas.fi.fa.manage.app.FaLocalUtils;
import com.kingdee.eas.fi.fa.manage.services.FaFinalCheckOutService;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.Uuid;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(value={"com.kingdee.eas.fi.fa.manage.services.FaFinalCheckOutService"})
public class FaFinalCheckOutServiceImpl
implements FaFinalCheckOutService {
    private Context ctx = null;
    private static String FA_MUTEX_LOCK = "FI_FA_Mutex_Lock";

    public FaFinalCheckOutServiceImpl(Context ctx) {
        this.ctx = ctx;
    }

    @Override
    public Map<String, Object> getShowData() throws BOSException, EASBizException, Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        List dataList = new ArrayList();
        dataList = this.getFacade().getInitData();
        ArrayList loadData = new ArrayList();
        if (dataList != null && dataList.size() > 0) {
            for (int i = 0; i < dataList.size(); ++i) {
                Map recordMap = (Map)dataList.get(i);
                HashMap row = new HashMap();
                row.put("companyId", recordMap.get("id"));
                row.put("orgName", recordMap.get("name"));
                row.put("curPeriod", recordMap.get("curPeriod"));
                loadData.add(row);
            }
            result.put("onloadData", loadData);
        }
        return result;
    }

    private IFaPeriodCloseBatchFacade getFacade() throws Exception {
        return FaPeriodCloseBatchFacadeFactory.getLocalInstance((Context)this.ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> checkout(String companyIDs) throws BOSException, EASBizException, Exception {
        String[] comIdArrays;
        ICompanyOrgUnit comOrg = null;
        IFaPeriodCloseFacade periodClose = null;
        ArrayList<String> comIdList = new ArrayList<String>();
        for (String comId : comIdArrays = companyIDs.split(",")) {
            comIdList.add(comId);
        }
        comOrg = CompanyOrgUnitFactory.getLocalInstance((Context)this.ctx);
        periodClose = FaPeriodCloseFacadeFactory.getLocalInstance((Context)this.ctx);
        HashMap<String, Object> result = new HashMap<String, Object>();
        CompanyOrgUnitInfo currCompany = null;
        Uuid mutexUuid = null;
        String strInfo = "";
        Map periodIds = new HashMap();
        HashMap<String, String> companyWorkResultMap = new HashMap<String, String>();
        ArrayList<String> companyIds = new ArrayList<String>();
        for (int i = 0; i < comIdList.size(); ++i) {
            String comId = (String)comIdList.get(i);
            currCompany = comOrg.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(comId));
            mutexUuid = Uuid.create();
            String mutexActionName = "checkout";
            MutexParameter mutexParam = FaFinalCheckOutServiceImpl.setMutexParameter(mutexUuid, mutexActionName, currCompany, this.ctx);
            try {
                if (FaFinalCheckOutServiceImpl.requestMutex(mutexParam, this.ctx)) {
                    ObjectUuidPK userPk = new ObjectUuidPK(BOSUuid.read((String)ContextUtil.getCurrentUserInfo((Context)this.ctx).getId().toString()));
                    ObjectUuidPK orgPk = new ObjectUuidPK(BOSUuid.read((String)comId));
                    if (!PermissionFactory.getLocalInstance((Context)this.ctx).hasFunctionPermission((IObjectPK)userPk, (IObjectPK)orgPk, "fa_period_close")) {
                        strInfo = MessageFormat.format(FaLocalUtils.getResource((Context)this.ctx, (String)"com.kingdee.eas.fi.fa.manage.FaPeriodClose", (String)"nofaAcc"), currCompany.getName());
                        continue;
                    }
                    strInfo = this.checkMonthEnd(currCompany);
                    if (!StringUtils.isEmpty((String)strInfo) || !StringUtils.isEmpty((String)(strInfo = this.checkCurrPeriod(currCompany)))) continue;
                    PeriodInfo period = periodClose.carrayForward(currCompany);
                    strInfo = strInfo + FaLocalUtils.getResource((Context)this.ctx, (String)"com.kingdee.eas.fi.fa.manage.FaPeriodClose", (String)"forwardSuccess") + FaLocalUtils.getResource((Context)this.ctx, (String)"com.kingdee.eas.fi.fa.manage.FaPeriodClose", (String)"to") + period.getPeriodYear() + FaLocalUtils.getResource((Context)this.ctx, (String)"com.kingdee.eas.fi.fa.manage.FaPeriodClose", (String)"yearNo") + period.getPeriodNumber() + FaLocalUtils.getResource((Context)this.ctx, (String)"com.kingdee.eas.fi.fa.manage.FaPeriodClose", (String)"period") + ", ";
                    strInfo = strInfo + this.buildSumText(currCompany, period, 1);
                    continue;
                }
                strInfo = FaLocalUtils.getResource((Context)this.ctx, (String)"com.kingdee.eas.fi.fa.manage.FaDepreciationResource", (String)"Fa_Mutex_Is_InProcess");
                continue;
            }
            catch (Exception ex) {
                strInfo = ex.getMessage();
                continue;
            }
            finally {
                try {
                    companyIds.add(comId);
                    companyWorkResultMap.put(comId, strInfo);
                    FaFinalCheckOutServiceImpl.releaseMutex(mutexUuid, this.ctx);
                }
                catch (Exception ex) {
                    System.out.println(ex);
                }
            }
        }
        periodIds = this.getFacade().getperiodList(companyIds);
        List dataList = new ArrayList();
        dataList = this.getFacade().getInitData();
        ArrayList loadData = new ArrayList();
        if (dataList != null && dataList.size() > 0) {
            for (int i = 0; i < dataList.size(); ++i) {
                Map recordMap = (Map)dataList.get(i);
                HashMap row = new HashMap();
                row.put("companyId", recordMap.get("id"));
                row.put("orgName", recordMap.get("name"));
                if (periodIds.containsKey(recordMap.get("id"))) {
                    row.put("curPeriod", periodIds.get(recordMap.get("id")));
                } else {
                    row.put("curPeriod", recordMap.get("curPeriod"));
                }
                if (companyWorkResultMap.containsKey(recordMap.get("id"))) {
                    row.put("handleResult", companyWorkResultMap.get(recordMap.get("id")));
                } else {
                    row.put("handleResult", "");
                }
                loadData.add(row);
            }
            result.put("onloadData", loadData);
        }
        return result;
    }

    public static boolean requestMutex(MutexParameter param, Context ctx) throws BOSException, EASBizException {
        IMutexServiceControl mutexService = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        return mutexService.requestMutex(param);
    }

    private String checkMonthEnd(CompanyOrgUnitInfo currCompany) throws Exception {
        String checkResult = "";
        if (currCompany != null) {
            if (currCompany.getInvalidDate() != null && DateTimeUtils.dayBefore((Date)currCompany.getInvalidDate(), (Date)new Date())) {
                checkResult = FaLocalUtils.getResource((Context)this.ctx, (String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"Company_Disabled");
                return checkResult;
            }
            if (!currCompany.isIsBizUnit()) {
                checkResult = FaLocalUtils.getResource((Context)this.ctx, (String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"vitualComNotAllowUseThisFun");
                return checkResult;
            }
        } else {
            checkResult = FaLocalUtils.getResource((Context)this.ctx, (String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"Company_Null");
            return checkResult;
        }
        PeriodInfo aPeriodInfo = null;
        try {
            aPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)this.ctx, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)(currCompany == null ? currCompany : currCompany));
        }
        catch (Exception e) {
            checkResult = e.toString();
            return checkResult;
        }
        if (aPeriodInfo == null) {
            checkResult = FaLocalUtils.getResource((Context)this.ctx, (String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"notConfigStartPeriod");
            return checkResult;
        }
        if (currCompany.getAccountTable() == null) {
            checkResult = FaLocalUtils.getResource((Context)this.ctx, (String)"com.kingdee.eas.basedata.master.account.client.AccountResource", (String)"CurrentCompanyHasNoStartAccountTable");
            return checkResult;
        }
        boolean isInitEnd = SystemStatusCtrolUtils.isStart((Context)this.ctx, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)currCompany);
        if (!isInitEnd) {
            checkResult = FaLocalUtils.getResource((Context)this.ctx, (String)"com.kingdee.eas.fi.fa.manage.FaCardResource", (String)"FaCurCardEditUI_FANotEndInit");
            return checkResult;
        }
        return checkResult;
    }

    private String checkCurrPeriod(CompanyOrgUnitInfo currCompany) throws BOSException, EASBizException {
        String checkResult = "";
        PeriodInfo currentPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)this.ctx, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)currCompany);
        if (currentPeriod == null) {
            checkResult = FaLocalUtils.getResource((Context)this.ctx, (String)"com.kingdee.eas.fi.fa.manage.FaDepreciationResource", (String)"FaDep_CloseAccount_Is_InProcess");
            return checkResult;
        }
        return checkResult;
    }

    protected String buildSumText(CompanyOrgUnitInfo currCompany, PeriodInfo period, int sumType) throws Exception {
        int scale = FaFinalCheckOutServiceImpl.getCurrencyScale(currCompany.getBaseCurrency().getId(), this.ctx);
        StringBuffer sb = new StringBuffer();
        HashMap sumValue = FaPeriodCloseFacadeFactory.getLocalInstance((Context)this.ctx).getFASum(currCompany.getId().toString(), period.getId().toString(), sumType);
        DecimalFormat format = new DecimalFormat(FaFinalCheckOutServiceImpl.getFormatPattern(scale));
        sb.append(period.getPeriodYear() + FaLocalUtils.getResource((Context)this.ctx, (String)"com.kingdee.eas.fi.fa.manage.FaPeriodClose", (String)"yearNo") + period.getPeriodNumber() + FaLocalUtils.getResource((Context)this.ctx, (String)"com.kingdee.eas.fi.fa.manage.FaPeriodClose", (String)"period") + (sumType == 1 ? FaLocalUtils.getResource((Context)this.ctx, (String)"com.kingdee.eas.fi.fa.manage.FaPeriodClose", (String)"periodBegin") : FaLocalUtils.getResource((Context)this.ctx, (String)"com.kingdee.eas.fi.fa.manage.FaPeriodClose", (String)"periodEnd")) + "\n");
        sb.append(FaLocalUtils.getResource((Context)this.ctx, (String)"com.kingdee.eas.fi.fa.manage.FaPeriodClose", (String)"assetValueSum") + ":" + format.format(((BigDecimal)sumValue.get("real")).setScale(scale, 4)) + FaLocalUtils.getResource((Context)this.ctx, (String)"com.kingdee.eas.fi.fa.manage.FaPeriodClose", (String)"yuan") + ", ");
        sb.append(FaLocalUtils.getResource((Context)this.ctx, (String)"com.kingdee.eas.fi.fa.manage.FaPeriodClose", (String)"deprValueSum") + ":" + format.format(((BigDecimal)sumValue.get("depr")).setScale(scale, 4)) + FaLocalUtils.getResource((Context)this.ctx, (String)"com.kingdee.eas.fi.fa.manage.FaPeriodClose", (String)"yuan"));
        return sb.toString();
    }

    public static String getFormatPattern(int scale) {
        String pattern = null;
        switch (scale) {
            case 0: {
                pattern = "#,##0";
                break;
            }
            case 1: {
                pattern = "#,##0.0";
                break;
            }
            case 2: {
                pattern = "#,##0.00";
                break;
            }
            case 3: {
                pattern = "#,##0.000";
                break;
            }
            case 4: {
                pattern = "#,##0.0000";
                break;
            }
            default: {
                StringBuffer buf = new StringBuffer("#,##0.00000");
                for (int i = 5; i < scale; ++i) {
                    buf.append("0");
                }
                pattern = buf.toString();
            }
        }
        return pattern;
    }

    public static MutexParameter setMutexParameter(Uuid uuid, String actionName, CompanyOrgUnitInfo currentCompanyInfo, Context ctx) {
        MutexParameter param = new MutexParameter();
        param.setRequestId(uuid);
        param.setMutexName(FA_MUTEX_LOCK);
        param.setActionName(actionName);
        param.setUserID(ContextUtil.getCurrentUserInfo((Context)ctx).getId());
        param.setOrgUnitID(currentCompanyInfo.getId());
        param.setMutexLockType(MutexLockType.EXCLUSIVE_LOCK);
        param.setDcName(ContextUtil.getDbType((Context)ctx));
        return param;
    }

    public static void releaseMutex(Uuid id, Context ctx) throws BOSException, EASBizException {
        IMutexServiceControl mutexService = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        mutexService.releaseMutex(id);
    }

    public static int getCurrencyScale(BOSUuid currencyID, Context ctx) throws EASBizException, BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("precision"));
        ObjectUuidPK pk = new ObjectUuidPK(currencyID);
        CurrencyInfo currencyInfo = ctx == null ? CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)pk, sic) : CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)pk, sic);
        return currencyInfo == null ? 2 : currencyInfo.getPrecision();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Map<String, Object> unCheckout(String companyID) throws BOSException, EASBizException, Exception {
        List dataList2222;
        HashMap<String, Object> result = new HashMap<String, Object>();
        String msg = "";
        Uuid mutexUuid = Uuid.create();
        try {
            try {
                String mutexActionName = "checkout";
                CompanyOrgUnitInfo currCompany = null;
                ICompanyOrgUnit comOrg = null;
                comOrg = CompanyOrgUnitFactory.getLocalInstance((Context)this.ctx);
                currCompany = comOrg.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyID));
                MutexParameter mutexParam = FaFinalCheckOutServiceImpl.setMutexParameter(mutexUuid, mutexActionName, currCompany, this.ctx);
                if (FaFinalCheckOutServiceImpl.requestMutex(mutexParam, this.ctx)) {
                    IFaPeriodCloseFacade periodClose = FaPeriodCloseFacadeFactory.getLocalInstance((Context)this.ctx);
                    PeriodInfo period = periodClose.carrayBack(companyID);
                    msg = msg + FaLocalUtils.getResource((Context)this.ctx, (String)"com.kingdee.eas.fi.fa.manage.FaPeriodClose", (String)"backSuccess") + "\n";
                    msg = msg + FaLocalUtils.getResource((Context)this.ctx, (String)"com.kingdee.eas.fi.fa.manage.FaPeriodClose", (String)"currentPeriod") + MessageFormat.format(FaLocalUtils.getResource((Context)this.ctx, (String)"com.kingdee.eas.fi.fa.manage.FaPeriodClose", (String)"displayPeriod"), Integer.toString(period.getPeriodYear()), Integer.toString(period.getPeriodNumber()));
                    result.put("msg", msg);
                } else {
                    msg = FaLocalUtils.getResource((Context)this.ctx, (String)"com.kingdee.eas.fi.fa.manage.FaDepreciationResource", (String)"Fa_Mutex_Is_InProcess");
                    result.put("msg", msg);
                }
            }
            catch (Exception exception) {
                msg = exception.getMessage();
                throw exception;
            }
            Object var12_13 = null;
            dataList2222 = new ArrayList();
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            List dataList2222 = new ArrayList();
            dataList2222 = this.getFacade().getInitData();
            ArrayList loadData = new ArrayList();
            if (dataList2222 != null && dataList2222.size() > 0) {
                for (int i = 0; i < dataList2222.size(); ++i) {
                    Map recordMap = (Map)dataList2222.get(i);
                    HashMap row = new HashMap();
                    row.put("companyId", recordMap.get("id"));
                    row.put("orgName", recordMap.get("name"));
                    row.put("curPeriod", recordMap.get("curPeriod"));
                    if (companyID.equals(recordMap.get("id"))) {
                        row.put("handleResult", msg);
                    } else {
                        row.put("handleResult", "");
                    }
                    loadData.add(row);
                }
                result.put("onloadData", loadData);
            }
            FaFinalCheckOutServiceImpl.releaseMutex(mutexUuid, this.ctx);
            return result;
        }
        dataList2222 = this.getFacade().getInitData();
        ArrayList loadData = new ArrayList();
        if (dataList2222 != null && dataList2222.size() > 0) {
            for (int i = 0; i < dataList2222.size(); ++i) {
                Map recordMap = (Map)dataList2222.get(i);
                HashMap row = new HashMap();
                row.put("companyId", recordMap.get("id"));
                row.put("orgName", recordMap.get("name"));
                row.put("curPeriod", recordMap.get("curPeriod"));
                if (companyID.equals(recordMap.get("id"))) {
                    row.put("handleResult", msg);
                } else {
                    row.put("handleResult", "");
                }
                loadData.add(row);
            }
            result.put("onloadData", loadData);
        }
        FaFinalCheckOutServiceImpl.releaseMutex(mutexUuid, this.ctx);
        return result;
    }
}

