/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.services.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.cdo.ICommonDataObject;
import com.kingdee.bos.cdo.utils.CDOUtils;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.INewOrgF7Facade;
import com.kingdee.eas.basedata.org.NewOrgF7FacadeFactory;
import com.kingdee.eas.basedata.org.OrgStructureFactory;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.manage.services.FaCommonObject;
import com.kingdee.util.StringUtils;

public class MainOrgFilterImpl {
    private Context context = null;

    public MainOrgFilterImpl(Context context) {
        this.context = context;
    }

    public ICommonDataObject getMainOrgFilter(String permissionItem) throws EASBizException, BOSException {
        FaCommonObject info = new FaCommonObject();
        FilterInfo filter = this.getFilterInfo(permissionItem);
        info.put("mainorgfilter", filter.toSql());
        return CDOUtils.convertObjectInfoToCDO((Context)this.context, (IObjectValue)info);
    }

    public FilterInfo getFilterInfo(String permissionItem) throws EASBizException, BOSException {
        StringBuffer oql = new StringBuffer();
        String rootUnitId = "00000000-0000-0000-0000-000000000000CCE7AED4";
        String treeId = "00000000-0000-0000-0000-0000000000024F2827FD";
        oql.append("select unit.longnumber where unit.id = '").append(rootUnitId).append("' and tree.id = '").append(treeId).append("'");
        OrgStructureInfo structInfo = OrgStructureFactory.getLocalInstance((Context)this.context).getOrgStructureInfo(oql.toString());
        StringBuffer longNumberQuery = this.getRootLongNumbers(structInfo);
        String sql = this.getEntityViewInSQL(permissionItem);
        FilterInfo filter = new FilterInfo();
        try {
            if (null == longNumberQuery || 0 == longNumberQuery.length()) {
                filter.mergeFilter(new FilterInfo("id in (" + sql + ")"), "AND");
            } else {
                StringBuffer result = new StringBuffer();
                result.append("id in (").append(sql.substring(0, sql.indexOf("WHERE"))).append(" WHERE (").append(longNumberQuery).append(") AND ").append(sql.substring(sql.indexOf("WHERE") + "WHERE".length())).append(")");
                filter.mergeFilter(new FilterInfo(result.toString()), "AND");
            }
        }
        catch (ParserException e) {
            throw new BOSException((Throwable)e);
        }
        return filter;
    }

    private StringBuffer getRootLongNumbers(OrgStructureInfo structInfo) {
        String[] rootLongNumbers = new String[]{structInfo.getUnit().getLongNumber()};
        StringBuffer longNumberQuery = new StringBuffer();
        if (rootLongNumbers != null && rootLongNumbers.length > 0) {
            for (int i = 0; i < rootLongNumbers.length; ++i) {
                longNumberQuery.append("(\"UNIT\".FLongNumber = '").append(rootLongNumbers[i]).append("' OR \"UNIT\".FLongNumber Like '").append(rootLongNumbers[i]).append("!%')");
                if (i == rootLongNumbers.length - 1) continue;
                longNumberQuery.append(" OR ");
            }
        }
        return longNumberQuery;
    }

    private String getEntityViewInSQL(String permissionItem) throws BOSException, EASBizException {
        FilterInfo outerFilter;
        FilterInfo authOrgFilter;
        MetaDataPK mainQueryPK = MetaDataPK.create((String)"com.kingdee.eas.basedata.org.app", (String)"NewOrgF7Query");
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemInfo sealUpItem = this.getSealUpOrgFilter();
        if (sealUpItem != null) {
            filter.getFilterItems().add(this.getSealUpOrgFilter());
        }
        if ((authOrgFilter = this.getAuthorizedOrgFilter(permissionItem)) != null) {
            filter.mergeFilter(authOrgFilter, "and");
        }
        if ((outerFilter = this.getOuterFilterInfo()) != null) {
            filter.mergeFilter(outerFilter, "and");
        }
        view.setFilter(filter);
        IQueryExecutor iexec = this.getQueryExecutor((IMetaDataPK)mainQueryPK, view);
        String sql = iexec.getSQL();
        String result = "SELECT \"UNIT\".FID " + sql.substring(sql.indexOf("FROM"), sql.indexOf("ORDER BY"));
        return result;
    }

    private IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)this.context, (IMetaDataPK)queryPK);
        exec.setObjectView(viewInfo);
        return exec;
    }

    private FilterItemInfo getSealUpOrgFilter() throws BOSException, EASBizException {
        INewOrgF7Facade ifacade = NewOrgF7FacadeFactory.getLocalInstance((Context)this.context);
        OrgViewType orgViewType = OrgViewType.COMPANY;
        if (orgViewType == OrgViewType.CTRLUNIT) {
            return new FilterItemInfo(this.prefix() + "isOUSealUp", (Object)0, CompareType.EQUALS);
        }
        if (orgViewType != OrgViewType.UNIONDEBT) {
            String tableName = ifacade.getTableNameByOrgTypeView(orgViewType);
            if (StringUtils.isEmpty((String)tableName)) {
                return null;
            }
            String sql = "select funitid from " + tableName + " where FIsSealUp = 0";
            return new FilterItemInfo(this.prefix() + "id", (Object)sql, CompareType.INNER);
        }
        return null;
    }

    private FilterInfo getOuterFilterInfo() throws BOSException {
        FilterInfo filter = null;
        try {
            filter = new FilterInfo(" unit.partFI.isBizUnit = 1 ");
        }
        catch (ParserException e) {
            throw new BOSException((Throwable)e);
        }
        return filter;
    }

    private FilterInfo getAuthorizedOrgFilter(String permissionItem) throws EASBizException, BOSException {
        OrgViewType viewType = OrgViewType.COMPANY;
        OrgTreeInfo treeInfo = new OrgTreeInfo();
        treeInfo.setId(BOSUuid.read((String)"00000000-0000-0000-0000-0000000000024F2827FD"));
        treeInfo.setType(viewType);
        String paramSQL = NewOrgF7FacadeFactory.getLocalInstance((Context)this.context).getPermSQLByPermItem(permissionItem, this.context.getCaller(), viewType);
        FilterInfo filter = null;
        try {
            filter = new FilterInfo("unit.id in (" + paramSQL + ")");
        }
        catch (ParserException e) {
            throw new BOSException((Throwable)e);
        }
        return filter;
    }

    private String prefix() {
        return "unit.";
    }
}

