/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.client.startup.update;

import com.kingdee.eas.client.startup.log.ClientStartLogger;
import com.kingdee.eas.client.startup.update.SingleUpdater;
import com.kingdee.eas.client.startup.update.check.CacheStateFactory;
import com.kingdee.eas.client.startup.update.check.EASClientFile;
import com.kingdee.eas.client.startup.update.check.ICacheState;
import com.kingdee.eas.client.startup.update.handler.cdn.CdnUpdateHandler;
import com.kingdee.eas.client.startup.update.handler.odds.OddsUpdateHandler;
import com.kingdee.eas.client.startup.update.handler.server.EasServerUpdateHandler;
import com.kingdee.eas.client.startup.update.model.UpdateModel;
import com.kingdee.eas.client.startup.update.model.UpdateModelFactory;
import org.apache.log4j.Logger;

public final class EasClientSilenceUpdater {
    private static final Logger logger = ClientStartLogger.getLogger();
    private final ICacheState cacheState = CacheStateFactory.createOnDemandDLCacheState();
    private UpdateModel model = UpdateModelFactory.getOnDemandUpdateModel(this.cacheState);
    private SingleUpdater odds = new SingleUpdater(this.model, new OddsUpdateHandler(this.model));
    private SingleUpdater cdn = new SingleUpdater(this.model, new CdnUpdateHandler(this.model));
    private SingleUpdater easServer = new SingleUpdater(this.model, new EasServerUpdateHandler(this.model));

    public static EasClientSilenceUpdater getInstance() {
        return new EasClientSilenceUpdater();
    }

    private EasClientSilenceUpdater() {
    }

    public boolean updateResource(String relativePath, boolean force) {
        return this.updateResource(relativePath);
    }

    public boolean updateResource(String relativePath) {
        EASClientFile entryInfo = this.isNeedUpdate(relativePath);
        if (entryInfo == null) {
            logger.info((Object)("\u5f88\u65b0,\u4e0d\u9700\u8981\u5728\u540e\u53f0\u66f4\u65b0:" + relativePath));
            logger.info((Object)(" this jar is newest,there's no need to update.[" + relativePath + "]"));
            return false;
        }
        logger.info((Object)("\u8fc7\u671f\u4e86,\u5c06\u5728\u540e\u53f0\u66f4\u65b0:" + relativePath));
        logger.info((Object)(" this jar is overdue,I'll update it silently.[" + relativePath + "]"));
        long timeStart = System.currentTimeMillis();
        this.odds.update(entryInfo);
        this.cdn.update(entryInfo);
        this.easServer.update(entryInfo);
        long timeEnd = System.currentTimeMillis();
        logger.info((Object)("\u83b7\u53d6\u5305\uff1a" + entryInfo.getPath() + " \u8017\u65f6\uff1a" + (timeEnd - timeStart) + " ms"));
        return true;
    }

    public EASClientFile isNeedUpdate(String relativePath) {
        for (EASClientFile file : this.model.getNeedUpdate()) {
            if (relativePath.indexOf(file.getPath()) < 0) continue;
            return file;
        }
        return null;
    }
}

