/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bsf;

import com.kingdee.bos.asm.ClassReader;
import com.kingdee.bos.asm.ClassVisitor;
import com.kingdee.bos.asm.ClassWriter;
import com.kingdee.bos.asm.Label;
import com.kingdee.bos.asm.MethodVisitor;
import com.kingdee.bos.asm.Type;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class ASMClasses {
    private static Map<String, String[]> paramName = new ConcurrentHashMap<String, String[]>();

    private ASMClasses() {
    }

    private static boolean sameType(Type[] types, Class<?>[] clazzes) {
        if (types.length != clazzes.length) {
            return false;
        }
        for (int i = 0; i < types.length; ++i) {
            if (Type.getType(clazzes[i]).equals((Object)types[i])) continue;
            return false;
        }
        return true;
    }

    public static String[] getMethodParamNames(final Method m) {
        String methodKey = ASMClasses.getMethodKey(m);
        if (paramName.get(methodKey) != null) {
            return paramName.get(methodKey);
        }
        final String[] paramNames = new String[m.getParameterTypes().length];
        String n = m.getDeclaringClass().getName();
        ClassWriter cw = new ClassWriter(1);
        ClassReader cr = null;
        try {
            cr = new ClassReader(n);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        cr.accept(new ClassVisitor(262144, (ClassVisitor)cw){

            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                Type[] args = Type.getArgumentTypes((String)desc);
                if (!name.equals(m.getName()) || !ASMClasses.sameType(args, m.getParameterTypes())) {
                    return super.visitMethod(access, name, desc, signature, exceptions);
                }
                MethodVisitor v = this.cv.visitMethod(access, name, desc, signature, exceptions);
                return new MethodVisitor(262144, v){

                    public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
                        int i = index - 1;
                        if (Modifier.isStatic(m.getModifiers())) {
                            i = index;
                        }
                        if (i >= 0 && i < paramNames.length) {
                            paramNames[i] = name;
                        }
                        super.visitLocalVariable(name, desc, signature, start, end, index);
                    }
                };
            }
        }, 0);
        paramName.put(methodKey, paramNames);
        return paramNames;
    }

    private static String getMethodKey(Method m) {
        StringBuffer sb = new StringBuffer();
        for (Class<?> parmType : m.getParameterTypes()) {
            sb.append("_" + parmType.getSimpleName());
        }
        String k = "$" + m.getDeclaringClass().getName() + m.getName() + sb.toString();
        k = k.replace('.', '_');
        return k;
    }
}

