/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bsf;

import com.kingdee.bos.bsf.Base;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;

public final class BeanContext
extends Base {
    private final Map<String, Service> name2Service = new HashMap<String, Service>();

    BeanContext(ReadWriteLock rwl) {
        super(rwl);
    }

    public void registerImplementation(String service, String interfac, String implClass) {
        if (service == null || interfac == null || implClass == null) {
            return;
        }
        this.name2Service.put(service, new Service(interfac, implClass));
    }

    public String getInterface(String service) {
        Service s = this.name2Service.get(service);
        if (s != null) {
            return s.interfac;
        }
        return null;
    }

    public String getImplementation(String service) {
        Service s = this.name2Service.get(service);
        if (s != null) {
            return s.implementation;
        }
        return null;
    }

    @Override
    public void reset() {
        this.name2Service.clear();
    }

    private static class Service {
        final String interfac;
        final String implementation;

        Service(String interfac, String implementation) {
            this.interfac = interfac;
            this.implementation = implementation;
        }
    }
}

