/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bsf;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.Base;
import com.kingdee.bos.bsf.BeanContext;
import com.kingdee.bos.bsf.BeanCreateException;
import com.kingdee.bos.bsf.GCMonitor;
import com.kingdee.bos.bsf.WorkDirectory;
import java.lang.reflect.Constructor;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;

class BeanFactory
extends Base {
    final BeanContext context;
    final WorkDirectory workDirectory;
    private volatile ClassLoader loader = null;

    BeanFactory(BeanContext context, WorkDirectory workDirectory) {
        super(workDirectory.rwl);
        this.context = context;
        this.workDirectory = workDirectory;
    }

    Class<?> getClass(String className) throws BOSException {
        if (className == null) {
            return null;
        }
        ClassLoader loader = this.getClassLoader();
        try {
            return loader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new BeanCreateException("class not found. name:" + className + " env:" + this.workDirectory, e);
        }
        catch (Exception e) {
            throw new BeanCreateException("create instance error. name:" + className + " env:" + this.workDirectory, e);
        }
    }

    Class<?> getInterface(String service) throws BOSException {
        String inter;
        try {
            this.rwl.readLock().lock();
            inter = this.context.getInterface(service);
        }
        finally {
            this.rwl.readLock().unlock();
        }
        return this.getClass(inter);
    }

    private Object createObject(Context ctx, String className, Object info) throws BOSException {
        if (className != null) {
            Class<?> c = this.getClass(className);
            if (c == null) {
                return null;
            }
            try {
                Constructor<?> cons = c.getConstructor(Context.class);
                return cons.newInstance(ctx);
            }
            catch (NoSuchMethodException e) {
                throw new BeanCreateException("class have not constructor like xxx(Context ctx). name:" + c.getName() + " env:" + this.workDirectory, e);
            }
            catch (Exception e) {
                throw new BeanCreateException("create instance error. name:" + c.getName() + " env:" + this.workDirectory, e);
            }
        }
        throw new BeanCreateException("can't find implementation of " + info + " env:" + this.workDirectory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object get(Context ctx, String service) throws BOSException {
        String implName;
        try {
            this.rwl.readLock().lock();
            implName = this.context.getImplementation(service);
        }
        finally {
            this.rwl.readLock().unlock();
        }
        return this.createObject(ctx, implName, service);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClassLoader getClassLoader() throws BOSException {
        ClassLoader loader;
        block10: {
            loader = this.loader;
            if (loader == null) {
                try {
                    this.rwl.readLock().lock();
                    loader = this.loader;
                    if (loader != null) break block10;
                    try {
                        this.rwl.readLock().unlock();
                        this.rwl.writeLock().lock();
                        loader = this.loader;
                        if (loader != null) {
                            ClassLoader classLoader = loader;
                            return classLoader;
                        }
                        this.loader = loader = new URLClassLoader(this.workDirectory.getURLs(), ClassLoader.getSystemClassLoader());
                    }
                    finally {
                        this.rwl.readLock().lock();
                        this.rwl.writeLock().unlock();
                    }
                }
                finally {
                    this.rwl.readLock().unlock();
                }
            }
        }
        return loader;
    }

    @Override
    public void reset() {
        try {
            this.rwl.writeLock().lock();
            this.context.reset();
            this.workDirectory.reset();
            this.loader = null;
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    List<GCMonitor<?>> expire() {
        ArrayList monitors = new ArrayList();
        try {
            this.rwl.writeLock().lock();
            if (this.loader != null) {
                GCMonitor<ClassLoader> m = new GCMonitor<ClassLoader>("BeanFactory classloader", this.loader);
                monitors.add(m);
            }
            ArrayList arrayList = monitors;
            return arrayList;
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }
}

