/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bsf;

import java.util.concurrent.ConcurrentHashMap;

public final class Composite {
    private static final ConcurrentHashMap<Composite, Composite> composites = new ConcurrentHashMap();
    public static Composite OLD_BSF = Composite.getInstance("oldbsf", "0.0.0.1", 1);
    private final String name;
    private final String version;
    private String alias;
    private String description;
    private volatile int state;

    public static Composite getInstance(String name, String version) {
        return Composite.getInstance(name, version, -1);
    }

    public static Composite getInstance(String name, String version, int state) {
        if (name == null || version == null) {
            throw new NullPointerException("composite's name and version can't be null.");
        }
        Composite composite = new Composite(name, version, state);
        Composite c = composites.get(composite);
        if (c == null) {
            c = composites.putIfAbsent(composite, composite);
            if (c == null) {
                c = composite;
            } else if (-1 != state) {
                if (-1 == c.state) {
                    c.setState(state);
                } else {
                    throw new IllegalStateException("invalid call on composite.");
                }
            }
        }
        return c;
    }

    private Composite(String name, String version, int state) {
        this.name = name;
        this.version = version;
        this.state = state;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public int getState() {
        return this.state;
    }

    void setState(int state) {
        this.state = state;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isInner() {
        return "oldbsf".equals(this.name);
    }

    public boolean available() {
        return this.state == 1;
    }

    public boolean undefined() {
        return this.state == -1;
    }

    public int hashCode() {
        return this.name.hashCode() + this.version.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof Composite)) {
            return false;
        }
        Composite that = (Composite)obj;
        return this.name.equals(that.name) && this.version.equals(that.version);
    }

    public String toString() {
        return this.name + "/" + this.version;
    }

    public static interface State {
        public static final int UNDEFINED = -1;
        public static final int CLOSED = 0;
        public static final int RUNNING = 1;
    }
}

