/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bsf;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.bsf.Composite;
import com.kingdee.bos.bsf.Domain;
import com.kingdee.bos.bsf.DomainFactory;
import com.kingdee.bos.bsf.IBase;
import com.kingdee.bos.bsf.ServiceRepositoryFactory;

public class CompositeManager {
    private static final CompositeManager instance = new CompositeManager();

    public static CompositeManager getInstance() {
        return instance;
    }

    public synchronized void disable(Composite composite) throws BOSException {
        if (composite == null) {
            return;
        }
        composite.setState(0);
        this.reset(composite);
    }

    private void reset(Composite composite) throws BOSException {
        IBase b = Domain.getInstance(composite);
        if (b != null) {
            b.reset();
        }
        if ((b = Domain.utility.getUtility(ServiceRepositoryFactory.class).getInstance(composite)) != null) {
            b.reset();
        }
    }

    public synchronized void enable(Composite composite) throws BOSException {
        if (composite == null) {
            return;
        }
        composite.setState(1);
    }

    public synchronized void install() throws BOSException {
        DomainFactory.factrory.incrementalIterate();
    }

    public synchronized void uninstall(Composite composite) throws BOSException {
        if (composite == null) {
            return;
        }
        composite.setState(-1);
        this.reset(composite);
        DomainFactory.factrory.remove(composite);
    }
}

