/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bsf;

import com.kingdee.bos.bsf.Composite;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

class CompositeMatcher {
    private final Map<String, List<Version>> composites = new HashMap<String, List<Version>>();

    CompositeMatcher() {
    }

    synchronized void addComposite(Composite composite) {
        int index;
        List<Version> versions = this.composites.get(composite.getName());
        if (versions == null) {
            versions = new LinkedList<Version>();
            this.composites.put(composite.getName(), versions);
        }
        Version version = new Version(composite);
        int size = versions.size();
        for (index = 0; index < size; ++index) {
            int r = version.compareTo(versions.get(index));
            if (r == 0) {
                return;
            }
            if (r > 0) break;
        }
        versions.add(index, version);
    }

    synchronized void removeComposite(Composite composite) {
        List<Version> versions = this.composites.get(composite.getName());
        if (versions != null) {
            Version version = new Version(composite);
            versions.remove(version);
        }
    }

    synchronized void clear() {
        this.composites.clear();
    }

    Composite getComposite(String composite, String versionRegex) {
        List<Version> version;
        if (composite != null && (version = this.composites.get(composite)) != null) {
            for (Version v : version) {
                if (!v.isAccept(versionRegex)) continue;
                return v.composite;
            }
        }
        return null;
    }

    static final class Version
    implements Comparable<Version> {
        final int major;
        final int minor;
        final int revision;
        final int build;
        final Composite composite;
        final String str;

        Version(Composite composite) {
            this.composite = composite;
            String[] numbers = composite.getVersion().replaceAll("([0]+)([1-9])", "$2").split("\\.");
            int mj = 0;
            int mn = 0;
            int rv = 0;
            int bd = 0;
            if (numbers.length > 0) {
                mj = this.convert2Int(numbers[0]);
            }
            if (numbers.length > 1) {
                mn = this.convert2Int(numbers[1]);
            }
            if (numbers.length > 2) {
                rv = this.convert2Int(numbers[2]);
            }
            if (numbers.length > 3) {
                bd = this.convert2Int(numbers[3]);
            }
            this.major = mj;
            this.minor = mn;
            this.revision = rv;
            this.build = bd;
            StringBuffer buffer = new StringBuffer(10);
            buffer.append(this.major);
            buffer.append(".");
            buffer.append(this.minor);
            buffer.append(".");
            buffer.append(this.revision);
            buffer.append(".");
            buffer.append(this.build);
            this.str = buffer.toString();
        }

        boolean isAccept(String regex) {
            if (regex == null || regex.length() == 0) {
                return true;
            }
            regex = regex.replaceAll("([0]+)([1-9])", "$2");
            regex = regex.replaceAll("\\.", "\\\\.");
            regex = regex.replaceAll("[Xx]", "[0-9]x");
            regex = regex.replaceAll("[Xx]", ".*");
            return this.str.matches(regex);
        }

        private int convert2Int(String s) {
            if (s == null || s.length() == 0) {
                return 0;
            }
            try {
                return Integer.valueOf(s);
            }
            catch (Exception e) {
                return 0;
            }
        }

        public String toString() {
            return this.str;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.build;
            result = 31 * result + this.major;
            result = 31 * result + this.minor;
            result = 31 * result + this.revision;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Version other = (Version)obj;
            if (this.build != other.build) {
                return false;
            }
            if (this.major != other.major) {
                return false;
            }
            if (this.minor != other.minor) {
                return false;
            }
            return this.revision == other.revision;
        }

        @Override
        public int compareTo(Version o) {
            if (o == null) {
                return 1;
            }
            int r = this.compareInt(this.major, o.major);
            if (r == 0 && (r = this.compareInt(this.minor, o.minor)) == 0 && (r = this.compareInt(this.revision, o.revision)) == 0) {
                r = this.compareInt(this.build, o.build);
            }
            return r;
        }

        int compareInt(int a, int b) {
            if (a == b) {
                return 0;
            }
            if (a > b) {
                return 1;
            }
            return -1;
        }
    }
}

