/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bsf;

import com.kingdee.bos.bsf.ServiceDiscovery;
import com.kingdee.bos.bsf.UtilityExtensionPoint;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class DefaultUtilityExtensionPoint
implements UtilityExtensionPoint {
    private Map<Class<?>, Object> utilities = new HashMap();

    @Override
    public void addUtility(Object utility) {
        if (utility == null) {
            throw new IllegalArgumentException("Cannot register null as a Service");
        }
        Set<Class<?>> interfaces = DefaultUtilityExtensionPoint.getAllInterfaces(utility.getClass());
        for (Class<?> i : interfaces) {
            this.utilities.put(i, utility);
        }
    }

    private Constructor<?> getConstructor(Constructor<?>[] constructors, Class<?>[] paramTypes) {
        for (Constructor<?> c : constructors) {
            Class<?>[] types = c.getParameterTypes();
            if (c.getParameterTypes().length != paramTypes.length) continue;
            boolean found = true;
            for (int i = 0; i < types.length; ++i) {
                if (types[i] == paramTypes[i]) continue;
                found = false;
                break;
            }
            if (!found) continue;
            return c;
        }
        return null;
    }

    @Override
    public <T> T getUtility(Class<T> utilityType) {
        if (utilityType == null) {
            throw new IllegalArgumentException("Cannot lookup Service of type null");
        }
        Object utility = this.utilities.get(utilityType);
        if (utility == null) {
            try {
                Class<?> utilityClass = ServiceDiscovery.getInstance().loadFirstServiceClass(utilityType);
                if (utilityClass != null) {
                    Constructor<?>[] constructors = utilityClass.getConstructors();
                    Constructor<?> constructor = this.getConstructor(constructors, new Class[0]);
                    if (constructor == null) {
                        throw new IllegalArgumentException("No valid constructor is found for " + utilityClass);
                    }
                    utility = constructor.newInstance(new Object[0]);
                    this.addUtility(utility);
                }
            }
            catch (InvocationTargetException e) {
                throw new IllegalArgumentException(e);
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException(e);
            }
            catch (InstantiationException e) {
                throw new IllegalArgumentException(e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return utilityType.cast(utility);
    }

    @Override
    public void removeUtility(Object utility) {
        if (utility == null) {
            throw new IllegalArgumentException("Cannot remove null as a Service");
        }
        Set<Class<?>> interfaces = DefaultUtilityExtensionPoint.getAllInterfaces(utility.getClass());
        for (Class<?> i : interfaces) {
            this.utilities.remove(i);
        }
    }

    private static Set<Class<?>> getAllInterfaces(Class<?> clazz) {
        HashSet implemented = new HashSet();
        DefaultUtilityExtensionPoint.getAllInterfaces(clazz, implemented);
        return implemented;
    }

    private static void getAllInterfaces(Class<?> clazz, Set<Class<?>> implemented) {
        Class<?>[] interfaces;
        for (Class<?> interfaze : interfaces = clazz.getInterfaces()) {
            if (!Modifier.isPublic(interfaze.getModifiers())) continue;
            implemented.add(interfaze);
        }
        Class<?> superClass = clazz.getSuperclass();
        if (superClass != null && !superClass.equals(Object.class)) {
            DefaultUtilityExtensionPoint.getAllInterfaces(superClass, implemented);
        }
    }
}

