/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bsf;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.BSFLogger;
import com.kingdee.bos.bsf.BeanContext;
import com.kingdee.bos.bsf.BeanFactory;
import com.kingdee.bos.bsf.Composite;
import com.kingdee.bos.bsf.Converter;
import com.kingdee.bos.bsf.DefaultUtilityExtensionPoint;
import com.kingdee.bos.bsf.DomainFactory;
import com.kingdee.bos.bsf.GCMonitor;
import com.kingdee.bos.bsf.IBase;
import com.kingdee.bos.bsf.IServiceRepository;
import com.kingdee.bos.bsf.Monitor;
import com.kingdee.bos.bsf.OperationInfo;
import com.kingdee.bos.bsf.ResolverFactory;
import com.kingdee.bos.bsf.ServiceException;
import com.kingdee.bos.bsf.ServiceRepositoryFactory;
import com.kingdee.bos.bsf.Snapshot;
import com.kingdee.bos.bsf.UtilityExtensionPoint;
import com.kingdee.bos.bsf.WorkDirectory;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.json.Kson;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public final class Domain
implements IBase {
    public static final UtilityExtensionPoint utility = new DefaultUtilityExtensionPoint();
    private final Composite composite;
    final Monitor monitor;
    private volatile BeanFactory beanFactory;
    private volatile Snapshot snapshot;

    public static Domain getInstance(String composite, String version) {
        return DomainFactory.factrory.getInstance(composite, version);
    }

    public static Composite getComposite(String composite, String version) {
        return DomainFactory.factrory.getComposite(composite, version);
    }

    public static Domain getInstance(Composite composite) {
        return DomainFactory.factrory.getInstance(composite);
    }

    Domain(Composite composite) {
        this.composite = composite;
        this.monitor = new Monitor();
        this.snapshot = new Snapshot(this, this.monitor.newLock(), this.monitor.getSeq());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BeanFactory getBeanFactory(ReadWriteLock lock) throws BOSException {
        BeanFactory beanFactory = this.beanFactory;
        if (beanFactory == null) {
            long seq;
            block9: {
                seq = 0L;
                ReentrantReadWriteLock rwl = this.monitor.getLock();
                try {
                    rwl.readLock().lock();
                    beanFactory = this.beanFactory;
                    if (beanFactory != null) break block9;
                    try {
                        rwl.readLock().unlock();
                        rwl.writeLock().lock();
                        beanFactory = this.beanFactory;
                        if (beanFactory == null) {
                            seq = this.monitor.getSeq();
                            BeanContext beanContext = new BeanContext(lock);
                            WorkDirectory workDirectory = new WorkDirectory(lock);
                            IServiceRepository repository = utility.getUtility(ServiceRepositoryFactory.class).getInstance(this.composite);
                            utility.getUtility(ResolverFactory.class).getInstance(repository, BeanContext.class).resolve(beanContext);
                            utility.getUtility(ResolverFactory.class).getInstance(repository, WorkDirectory.class).resolve(workDirectory);
                            this.beanFactory = beanFactory = new BeanFactory(beanContext, workDirectory);
                        }
                    }
                    finally {
                        rwl.readLock().lock();
                        rwl.writeLock().unlock();
                    }
                }
                finally {
                    rwl.readLock().unlock();
                }
            }
            if (seq != 0L) {
                BSFLogger.get().info("composite[" + this.composite + ":" + seq + "] start.");
            }
        }
        return beanFactory;
    }

    public <T> T getService(Context ctx, String service, Class<T> serviceInterface) throws BOSException {
        Object s = this.getService(ctx, service);
        if (serviceInterface.isInstance(s)) {
            return (T)s;
        }
        return null;
    }

    public Object getService(Context ctx, String service) throws BOSException {
        return this.innerGetService(ctx, service, this.snapshot);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object innerGetService(Context ctx, String service, Snapshot snapshot) throws BOSException {
        if (!this.composite.available()) {
            throw new ServiceException("service not available, please enable composite. id:" + this.composite + " state:" + this.composite.getState());
        }
        snapshot.begin();
        try {
            Object object = snapshot.getBeanFactory().get(ctx, service);
            return object;
        }
        finally {
            snapshot.end();
        }
    }

    public Object purelyInvokeService(Context ctx, String service, String operation, Object[] arguments) throws BOSException {
        return this.innerInvokeService(ctx, service, operation, arguments, false, this.snapshot);
    }

    public Object invokeService(Context ctx, String service, String operation, Object[] arguments) throws BOSException {
        return this.innerInvokeService(ctx, service, operation, arguments, true, this.snapshot);
    }

    private Object innerInvokeService(Context ctx, String service, String operation, Object[] arguments, boolean transactional, Snapshot snapshot) throws BOSException {
        snapshot.begin();
        try {
            OperationInfo oprt;
            Object target;
            block8: {
                target = this.innerGetService(ctx, service, snapshot);
                if (target == null) {
                    throw new ServiceException("service invoke error and can't create service's instance. service:" + service);
                }
                oprt = snapshot.getOperation(service, operation);
                try {
                    if (!transactional) break block8;
                    Object object = EJBFactory.getEJBTransactionProxy((Object)target).invoke(oprt.getMethod(), arguments, oprt.getTransactionLevel());
                    return object;
                }
                catch (Throwable e) {
                    throw new ServiceException("service invoke error. service:" + service + " operation:" + operation, e);
                }
            }
            Object object = oprt.getMethod().invoke(target, arguments);
            return object;
        }
        finally {
            snapshot.end();
        }
    }

    public String purelyInvokeService(Context ctx, String service, String operation, String json) throws BOSException {
        return this.innerInvokeService(ctx, service, operation, json, false);
    }

    public String invokeService(Context ctx, String service, String operation, String json) throws BOSException {
        return this.innerInvokeService(ctx, service, operation, json, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String innerInvokeService(Context ctx, String service, String operation, String json, boolean transactional) throws BOSException {
        Snapshot snapshot = this.snapshot;
        snapshot.begin();
        try {
            OperationInfo oprt = snapshot.getOperation(service, operation);
            Converter converter = oprt.getConverter();
            Object[] args = converter.convertParam(ctx, json);
            Object r = this.innerInvokeService(ctx, service, operation, args, transactional, snapshot);
            String string = converter.convertResult(ctx, r);
            return string;
        }
        finally {
            snapshot.end();
        }
    }

    public Object purelyInvokeService(Context ctx, String service, String operation, Map<String, Object> args) throws BOSException {
        return this.innerInvokeService(ctx, service, operation, args, false);
    }

    public Object invokeService(Context ctx, String service, String operation, Map<String, Object> args) throws BOSException {
        return this.innerInvokeService(ctx, service, operation, args, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object innerInvokeService(Context ctx, String service, String operation, Map<String, Object> args, boolean transactional) throws BOSException {
        Snapshot snapshot = this.snapshot;
        snapshot.begin();
        try {
            OperationInfo oprt = snapshot.getOperation(service, operation);
            Object[] as = oprt.getConverter().convertParam(ctx, args);
            Object object = this.innerInvokeService(ctx, service, operation, as, transactional, snapshot);
            return object;
        }
        finally {
            snapshot.end();
        }
    }

    public Class<?> getClass(String className) throws BOSException {
        return this.snapshot.getBeanFactory().getClass(className);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        Snapshot snapshot;
        long seq;
        ReentrantReadWriteLock rwl = this.monitor.getLock();
        try {
            rwl.writeLock().lock();
            seq = this.monitor.getSeq();
            Kson.resetGson();
            this.beanFactory = null;
            snapshot = this.snapshot;
            this.snapshot = new Snapshot(this, this.monitor.newLock(), this.monitor.reset());
        }
        finally {
            rwl.writeLock().unlock();
        }
        String desc = "composite[" + this.composite + ":" + seq + "] ";
        List<GCMonitor<?>> gcs = snapshot.expire();
        snapshot.reset();
        snapshot = null;
        if (gcs != null) {
            GCMonitor.addMonitor(desc, gcs);
        }
        BSFLogger.get().info(desc + "reset.");
    }
}

