/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bsf;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.bsf.Composite;
import com.kingdee.bos.bsf.CompositeMatcher;
import com.kingdee.bos.bsf.Container;
import com.kingdee.bos.bsf.Domain;
import com.kingdee.bos.bsf.ServiceRepositoryFactory;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

class DomainFactory
implements Container {
    private static final Logger logger = Logger.getLogger(DomainFactory.class);
    static final DomainFactory factrory = new DomainFactory();
    private final Map<Composite, Domain> instances = new HashMap<Composite, Domain>();
    private final CompositeMatcher matcher = new CompositeMatcher();

    private DomainFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Composite> iterate() throws BOSException {
        List<Composite> composites = Domain.utility.getUtility(ServiceRepositoryFactory.class).iterate();
        if (composites != null) {
            Map<Composite, Domain> map = this.instances;
            synchronized (map) {
                this.instances.clear();
                this.matcher.clear();
                for (Composite c : composites) {
                    this.instances.put(c, new Domain(c));
                    this.matcher.addComposite(c);
                }
            }
        }
        return composites;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Composite> incrementalIterate() throws BOSException {
        List<Composite> composites = Domain.utility.getUtility(ServiceRepositoryFactory.class).incrementalIterate();
        if (composites != null) {
            Map<Composite, Domain> map = this.instances;
            synchronized (map) {
                for (Composite c : composites) {
                    this.instances.put(c, new Domain(c));
                    this.matcher.addComposite(c);
                }
            }
        }
        return composites;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(Composite composite) {
        Map<Composite, Domain> map = this.instances;
        synchronized (map) {
            this.instances.remove(composite);
            this.matcher.removeComposite(composite);
        }
        Domain.utility.getUtility(ServiceRepositoryFactory.class).remove(composite);
    }

    Composite getComposite(String composite, String version) {
        return this.matcher.getComposite(composite, version);
    }

    Domain getInstance(String composite, String version) {
        return this.getInstance(this.getComposite(composite, version));
    }

    Domain getInstance(Composite composite) {
        if (composite == null) {
            return null;
        }
        return this.instances.get(composite);
    }

    static {
        try {
            factrory.iterate();
        }
        catch (BOSException e) {
            logger.error((Object)"BSF init error.", (Throwable)e);
        }
    }
}

