/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bsf;

import com.kingdee.bos.bsf.BSFLogger;
import com.kingdee.bos.monitor.Monitor;
import java.lang.ref.PhantomReference;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

class GCMonitor<T> {
    private static final List<GCMonitor<?>> tmpMonitors = new ArrayList();
    private static final List<GCMonitor<?>> totalMonitors = new LinkedList();
    private static Monitor _monitor = new Monitor(new Monitor.Setting(){

        public long getIntervalTime() {
            return 1000L;
        }

        public String getName() {
            return "BSF GC monitor";
        }
    });
    private final ReferenceQueue<T> queue = new ReferenceQueue();
    private final Reference<T> reference;
    private final String name;
    private String composite;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <T> void addMonitor(String composite, GCMonitor<T> monitor) {
        if (monitor != null) {
            monitor.setComposite(composite);
            List<GCMonitor<?>> list = tmpMonitors;
            synchronized (list) {
                tmpMonitors.add(monitor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void addMonitor(String composite, Collection<GCMonitor<?>> monitors) {
        if (monitors != null) {
            List<GCMonitor<?>> list = tmpMonitors;
            synchronized (list) {
                for (GCMonitor<?> m : monitors) {
                    m.setComposite(composite);
                    tmpMonitors.add(m);
                }
            }
        }
    }

    GCMonitor(String name, T ref) {
        this.reference = new PhantomReference<T>(ref, this.queue);
        this.name = name;
    }

    ReferenceQueue<T> getReferenceQueue() {
        return this.queue;
    }

    Reference<T> getReference() {
        return this.reference;
    }

    void setComposite(String composite) {
        this.composite = composite;
    }

    boolean isGC() {
        Reference<T> ref = null;
        try {
            ref = this.queue.remove(10L);
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (ref != null) {
            ref.clear();
            return true;
        }
        return false;
    }

    static {
        _monitor.addMonitor(new Runnable(){
            private int bads = 0;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                GCMonitor[] tmp;
                GCMonitor[] gCMonitorArray = tmpMonitors;
                synchronized (gCMonitorArray) {
                    tmp = tmpMonitors.toArray(new GCMonitor[0]);
                    tmpMonitors.clear();
                }
                for (GCMonitor m : tmp) {
                    totalMonitors.add(m);
                }
                int size = totalMonitors.size();
                int success = 0;
                Iterator ite = totalMonitors.iterator();
                while (ite.hasNext()) {
                    GCMonitor m;
                    m = (GCMonitor)ite.next();
                    if (!m.isGC()) continue;
                    ++success;
                    ite.remove();
                    BSFLogger.get().info(m.composite + m.name + " gc success.");
                }
                if (size > 5) {
                    if ((double)(success / size) < 0.2) {
                        ++this.bads;
                        System.gc();
                        System.runFinalization();
                    }
                    if (this.bads > 10) {
                        this.bads = 0;
                        StringBuffer composites = new StringBuffer();
                        ite = totalMonitors.iterator();
                        while (ite.hasNext()) {
                            composites.append(((GCMonitor)ite.next()).composite);
                        }
                        BSFLogger.get().error("There may be memory leak. can't gc these composites:" + composites);
                    }
                }
            }
        });
    }
}

