/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bsf;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.ServiceException;
import com.kingdee.bos.bsf.facade.FacadeFileScan;
import com.kingdee.bos.bsf.manage.FacadeMethodBean;
import com.kingdee.bos.bsf.type.ClassGenerator;
import com.kingdee.bos.bsf.type.FieldInfo;
import com.kingdee.bos.bsf.type.Reflect;
import com.kingdee.bos.json.JSONUtils;
import com.kingdee.bos.json.Kson;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class OpenAPI {
    private static Track track = new Track();

    public static FacadeMethodBean findAPI(String service, String methd) throws BOSException {
        String facadeName = service.replace(".", "/").replace("/facade", ".facade");
        FacadeMethodBean fmb = FacadeFileScan.getInstance().getFacadeMethodBean(facadeName, methd);
        return fmb;
    }

    public static Method getFacadeInstanceMethod(Class<?> factoryClass) {
        Method[] factoryMethods;
        for (Method fMethod : factoryMethods = factoryClass.getMethods()) {
            Class<?>[] classParamTypes;
            if (!fMethod.getName().equals("getLocalInstance") || (classParamTypes = fMethod.getParameterTypes()).length != 1) continue;
            for (Class<?> cpt : classParamTypes) {
                if (!cpt.equals(Context.class)) continue;
                return fMethod;
            }
        }
        return null;
    }

    public static String invoke(Context ctx, Object instaceObject, String operation, String argJson, FacadeMethodBean fmb) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, BOSException, ClassNotFoundException, MalformedURLException {
        Method[] instaceMethods;
        Class<?> instaceClass = instaceObject.getClass();
        for (Method fMethod : instaceMethods = instaceClass.getMethods()) {
            if (!fMethod.getName().equals(operation) || fMethod.getParameterTypes().length != fmb.getParameters().size()) continue;
            boolean isMatch = true;
            for (int i = 0; i < fmb.getParameters().size(); ++i) {
                if (fMethod.getParameterTypes()[i].toString().contains(fmb.getParameters().get(i).get_datatype())) continue;
                isMatch = false;
            }
            if (!isMatch) continue;
            Object[] args = OpenAPI.convertParam(ctx, fMethod, argJson, fmb);
            return OpenAPI.convertResult(ctx, fMethod.invoke(instaceObject, args));
        }
        return null;
    }

    private static String convertResult(Context ctx, Object result) throws BOSException {
        if (result == null) {
            return null;
        }
        String retStr = JSONUtils.convertObjectToJson((Context)ctx, (Object)result, (Gson)Kson.getGson());
        if (result instanceof String) {
            retStr = "\"" + retStr.toString() + "\" ";
        }
        return retStr;
    }

    private static Object[] convertParam(Context ctx, Method method, String json, FacadeMethodBean fmb) throws BOSException, ClassNotFoundException, MalformedURLException {
        Gson gson = Kson.getGson();
        Class<?>[] paramTypes = method.getParameterTypes();
        Object[] args = new Object[paramTypes.length];
        if (paramTypes.length > 0) {
            FieldInfo[] fields = new FieldInfo[paramTypes.length];
            for (int i = 0; i < paramTypes.length; ++i) {
                String paramName = fmb.getParameters().get(i).get_name();
                fields[i] = new FieldInfo(paramName, paramTypes[i]);
            }
            Object values = JSONUtils.convertJsonToObject((Context)ctx, (String)json, (Type)TypeToken.get(OpenAPI.getClass(fields, method)).getType(), (Gson)gson);
            for (int i = 0; i < paramTypes.length; ++i) {
                args[i] = Reflect.getter(values, fields[i].getName());
            }
        }
        return args;
    }

    private static Class<?> getClass(FieldInfo[] fields, Method method) throws BOSException, ClassNotFoundException, MalformedURLException {
        StringBuffer sb = new StringBuffer();
        for (Class<?> parmType : method.getParameterTypes()) {
            sb.append("_" + parmType.getSimpleName());
        }
        String k = "$" + method.getDeclaringClass().getName() + method.getName() + sb.toString();
        if (track.contains(k)) {
            return Track.getTempClassLoader().loadClass(k);
        }
        try {
            new ClassGenerator(new URL("file:" + Track.tempdirhome)).generateJavaBean(k, fields);
        }
        catch (Exception e) {
            throw new ServiceException("generate operation param object error. key:" + k, e);
        }
        track.add(k);
        return Track.getTempClassLoader().loadClass(k);
    }

    private static class Track {
        private final Set<String> keys = new HashSet<String>();
        private static ClassLoader loader;
        static final String tempdirhome;

        private Track() {
        }

        boolean contains(String key) {
            return this.keys.contains(key);
        }

        synchronized void add(String key) {
            this.keys.add(key);
        }

        public static ClassLoader getTempClassLoader() throws MalformedURLException {
            return loader;
        }

        static {
            tempdirhome = System.getProperty("java.io.tmpdir") + "/openapi/classes/";
            if (loader == null) {
                ArrayList<URL> urls = new ArrayList<URL>();
                try {
                    urls.add(new URL("file:" + tempdirhome));
                    loader = new URLClassLoader(urls.toArray(new URL[0]), ClassLoader.getSystemClassLoader());
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

