/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bsf;

import com.kingdee.bos.bsf.ClassLoaderServiceDiscoverer;
import com.kingdee.bos.bsf.ServiceDeclaration;
import com.kingdee.bos.bsf.ServiceDiscoverer;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public final class ServiceDiscovery {
    private static final Logger logger = Logger.getLogger((String)ServiceDiscovery.class.getName());
    private static final ServiceDiscovery INSTANCE = new ServiceDiscovery();
    private ServiceDiscoverer discoverer;
    private Set<ClassLoader> registeredClassLoaders = new HashSet<ClassLoader>();

    public static ServiceDiscovery getInstance() {
        return INSTANCE;
    }

    public ServiceDiscoverer getServiceDiscoverer() {
        if (this.discoverer == null) {
            this.discoverer = new ClassLoaderServiceDiscoverer();
        }
        return this.discoverer;
    }

    public void setServiceDiscoverer(ServiceDiscoverer sd) {
        if (this.discoverer != null) {
            throw new IllegalStateException("The ServiceDiscoverer cannot be reset");
        }
        this.discoverer = sd;
    }

    @Deprecated
    synchronized void registerClassLoader(ClassLoader classLoader) {
        this.registeredClassLoaders.add(classLoader);
    }

    @Deprecated
    synchronized void unregisterClassLoader(ClassLoader classLoader) {
        this.registeredClassLoaders.remove(classLoader);
    }

    public Set<ServiceDeclaration> getServiceDeclarations(String name) throws IOException {
        Set<ServiceDeclaration> services = this.getServiceDiscoverer().discover(name, false);
        return services;
    }

    public Set<ServiceDeclaration> getServiceDeclarations(Class<?> serviceInterface) throws IOException {
        return this.getServiceDeclarations(serviceInterface.getName());
    }

    public Class<?> loadFirstServiceClass(final Class<?> serviceInterface) throws IOException, ClassNotFoundException {
        Set<ServiceDeclaration> services;
        String className = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(serviceInterface.getName());
            }
        });
        if (className != null) {
            try {
                return Class.forName(className, false, serviceInterface.getClassLoader());
            }
            catch (ClassNotFoundException e) {
                try {
                    return Class.forName(className, false, Thread.currentThread().getContextClassLoader());
                }
                catch (ClassNotFoundException ex) {
                    logger.warn((Object)ex.getMessage(), (Throwable)ex);
                }
            }
        }
        if ((services = this.getServiceDiscoverer().discover(serviceInterface.getName(), true)).isEmpty()) {
            return null;
        }
        return services.iterator().next().loadClass();
    }

    public Object newFactoryClassInstance(Class<?> serviceInterface) throws SecurityException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Method newInstanceMethod = serviceInterface.getMethod("newInstance", new Class[0]);
        Object factory = newInstanceMethod.invoke(null, new Object[0]);
        return factory;
    }
}

