/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bsf;

import com.google.gson.Gson;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.bsf.Base;
import com.kingdee.bos.bsf.BeanFactory;
import com.kingdee.bos.bsf.Domain;
import com.kingdee.bos.bsf.GCMonitor;
import com.kingdee.bos.bsf.OperationInfo;
import com.kingdee.bos.bsf.ServiceException;
import com.kingdee.bos.bsf.ServiceInfo;
import com.kingdee.bos.bsf.ServiceResolver;
import com.kingdee.bos.json.Kson;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public final class Snapshot
extends Base {
    private final long seq;
    private final Domain domain;
    private final Gson gson;
    private volatile BeanFactory beanFactory = null;
    private int count = 0;
    private Map<String, Object> map = new HashMap<String, Object>(2);
    private final Map<String, ServiceInfo> services = new HashMap<String, ServiceInfo>();

    Snapshot(Domain domain, ReadWriteLock rwl, long seq) {
        super(rwl);
        this.domain = domain;
        this.seq = seq;
        this.gson = Kson.getGson();
    }

    public Class<?> loadClass(String className) throws BOSException {
        return this.getBeanFactory().getClass(className);
    }

    final BeanFactory getBeanFactory() throws BOSException {
        BeanFactory bf;
        block7: {
            bf = this.beanFactory;
            if (bf == null) {
                this.rwl.readLock().lock();
                try {
                    bf = this.beanFactory;
                    if (bf != null) break block7;
                    this.rwl.readLock().unlock();
                    this.rwl.writeLock().lock();
                    try {
                        this.beanFactory = bf = this.domain.getBeanFactory(this.rwl);
                    }
                    finally {
                        this.rwl.readLock().lock();
                        this.rwl.writeLock().unlock();
                    }
                }
                finally {
                    this.rwl.readLock().unlock();
                }
            }
        }
        return bf;
    }

    public URL getRuntime() throws BOSException {
        return this.getBeanFactory().workDirectory.getRuntime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OperationInfo getOperation(String service, String operation) throws BOSException {
        OperationInfo method;
        ServiceInfo oprtCtx;
        block8: {
            oprtCtx = this.services.get(service);
            if (oprtCtx == null) {
                ReentrantReadWriteLock rwl = this.domain.monitor.getLock();
                try {
                    rwl.readLock().lock();
                    oprtCtx = this.services.get(service);
                    if (oprtCtx != null) break block8;
                    try {
                        rwl.readLock().unlock();
                        rwl.writeLock().lock();
                        oprtCtx = new ServiceInfo(this, service);
                        Domain.utility.getUtility(ServiceResolver.class).resolve(this.getBeanFactory().getInterface(service), oprtCtx);
                        this.services.put(service, oprtCtx);
                    }
                    finally {
                        rwl.readLock().lock();
                        rwl.writeLock().unlock();
                    }
                }
                finally {
                    rwl.readLock().unlock();
                }
            }
        }
        if ((method = oprtCtx.getOperation(operation)) == null) {
            throw new ServiceException("service invoke error and can't find service's operation. service:" + service + " operation:" + operation);
        }
        return method;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T put(String key, T value) {
        try {
            this.rwl.writeLock().lock();
            Object object = this.map.put(key, value);
            return (T)object;
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T putIfAbsent(String key, T value) {
        try {
            this.rwl.writeLock().lock();
            Object obj = this.map.get(key);
            if (obj == null) {
                this.map.put(key, value);
                T t = value;
                return t;
            }
            Object object = obj;
            return (T)object;
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    public <T> T get(String key) {
        try {
            this.rwl.readLock().lock();
            Object object = this.map.get(key);
            return (T)object;
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    public long getSeq() {
        return this.seq;
    }

    public Gson getGson() {
        return this.gson;
    }

    @Override
    public void reset() {
        try {
            this.rwl.writeLock().lock();
            this.services.clear();
            BeanFactory bf = this.beanFactory;
            this.beanFactory = null;
            if (bf != null) {
                bf.reset();
            }
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    public ReadWriteLock getLock() {
        return this.rwl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<GCMonitor<?>> expire() {
        ArrayList monitors = new ArrayList();
        while (true) {
            try {
                this.rwl.writeLock().lock();
                if (this.count == 0) {
                    BeanFactory bf = this.beanFactory;
                    if (bf != null) {
                        monitors.addAll(bf.expire());
                    }
                    ArrayList arrayList = monitors;
                    return arrayList;
                }
            }
            finally {
                this.rwl.writeLock().unlock();
            }
            Snapshot snapshot = this;
            synchronized (snapshot) {
                try {
                    this.wait(10L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    void begin() throws BOSException {
        try {
            this.rwl.writeLock().lock();
            ++this.count;
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    void end() {
        this.rwl.writeLock().lock();
        --this.count;
        this.rwl.writeLock().unlock();
    }
}

