/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bsf;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.parsing.Properties;
import com.kingdee.bos.bsf.type.ClassGenerator;
import com.kingdee.bos.bsf.type.FieldInfo;
import com.kingdee.bos.bsf.type.Reflect;
import com.kingdee.bos.json.JSONUtils;
import com.kingdee.bos.json.Kson;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class WFAPI {
    static Map<String, String> localInstaceMethodNameMaping = new ConcurrentHashMap<String, String>();
    private static Track track;

    public static Method getFacadeInstanceMethod(Class<?> factoryClass) {
        Method[] factoryMethods = factoryClass.getMethods();
        String localInstaceMethodName = "getLocalInstance";
        if (localInstaceMethodNameMaping.get(factoryClass.getName()) != null) {
            localInstaceMethodName = localInstaceMethodNameMaping.get(factoryClass.getName());
        }
        for (Method fMethod : factoryMethods) {
            Class<?>[] classParamTypes;
            if (!fMethod.getName().equals(localInstaceMethodName) || (classParamTypes = fMethod.getParameterTypes()).length != 1) continue;
            for (Class<?> cpt : classParamTypes) {
                if (!cpt.equals(Context.class)) continue;
                return fMethod;
            }
        }
        return null;
    }

    public static String invoke(Context ctx, Object instaceObject, String operation, String argJson) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, BOSException, ClassNotFoundException, MalformedURLException {
        Method[] instaceMethods;
        Class<?> instaceClass = instaceObject.getClass();
        for (Method fMethod : instaceMethods = instaceClass.getMethods()) {
            if (!fMethod.getName().equals(operation)) continue;
            Object[] args = null;
            try {
                args = WFAPI.convertParam(ctx, fMethod, argJson);
            }
            catch (Exception e) {
                continue;
            }
            return WFAPI.convertResult(ctx, fMethod.invoke(instaceObject, args));
        }
        throw new BOSException("not find matched method with args:" + operation + "," + argJson);
    }

    private static String convertResult(Context ctx, Object result) throws BOSException {
        if (result == null) {
            return null;
        }
        String retStr = JSONUtils.convertObjectToJson((Context)ctx, (Object)result, (Gson)Kson.getGson());
        return retStr;
    }

    private static Object[] convertParam(Context ctx, Method method, String json) throws BOSException, ClassNotFoundException, MalformedURLException {
        Gson gson = Kson.getGson();
        Class<?>[] paramTypes = method.getParameterTypes();
        Object[] args = new Object[paramTypes.length];
        if (paramTypes.length > 0) {
            FieldInfo[] fields = new FieldInfo[paramTypes.length];
            for (int i = 0; i < paramTypes.length; ++i) {
                fields[i] = new FieldInfo("param" + i, paramTypes[i]);
            }
            Object values = JSONUtils.convertJsonToObject((Context)ctx, (String)json, (Type)TypeToken.get(WFAPI.getClass(fields, method)).getType(), (Gson)gson);
            for (int i = 0; i < paramTypes.length; ++i) {
                args[i] = Reflect.getter(values, fields[i].getName());
            }
        }
        return args;
    }

    private static Class<?> getClass(FieldInfo[] fields, Method method) throws BOSException, ClassNotFoundException, MalformedURLException {
        StringBuffer sb = new StringBuffer();
        for (Class<?> parmType : method.getParameterTypes()) {
            sb.append("_" + parmType.getSimpleName());
        }
        String k = "$" + method.getDeclaringClass().getName() + method.getName() + sb.toString();
        if (track.contains(k = k.replace('.', '_').replace('[', '_').replace(']', '_'))) {
            return Track.getTempClassLoader().loadClass(k);
        }
        try {
            new ClassGenerator(new URL("file:" + Track.tempdirhome)).generateJavaBean(k, fields);
        }
        catch (Exception e) {
            throw new BOSException("generate operation param object error. key:" + k, (Throwable)e);
        }
        track.add(k);
        return Track.getTempClassLoader().loadClass(k);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        String configPath = System.getProperty("EAS_HOME") + "/server/properties/localInstanceMethodMapping.properties";
        File f = new File(configPath);
        if (f.exists()) {
            Properties props = new Properties();
            InputStream in = null;
            try {
                in = new BufferedInputStream(new FileInputStream(configPath));
                props.load(in);
                Set<String> enu = props.stringPropertyNames();
                for (String s : enu) {
                    localInstaceMethodNameMaping.put(s, props.getProperty(s));
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException iOException) {
            }
            finally {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
        track = new Track();
    }

    private static class Track {
        private final Set<String> keys = new HashSet<String>();
        private static ClassLoader loader;
        static final String tempdirhome;

        private Track() {
        }

        boolean contains(String key) {
            return this.keys.contains(key);
        }

        synchronized void add(String key) {
            this.keys.add(key);
        }

        public static ClassLoader getTempClassLoader() throws MalformedURLException {
            return loader;
        }

        static {
            tempdirhome = System.getProperty("java.io.tmpdir") + "/wfapi/classes/";
            if (loader == null) {
                ArrayList<URL> urls = new ArrayList<URL>();
                try {
                    urls.add(new URL("file:" + tempdirhome));
                    loader = new URLClassLoader(urls.toArray(new URL[0]), ClassLoader.getSystemClassLoader());
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

