/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bsf.deploy;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.bsf.Composite;
import com.kingdee.bos.bsf.Domain;
import com.kingdee.bos.bsf.deploy.BSFDeployException;
import com.kingdee.bos.bsf.deploy.FileUtils;
import com.kingdee.bos.bsf.deploy.ModuleDescHandler;
import com.kingdee.bos.bsf.service.Configuration;
import com.kingdee.bos.bsf.service.IServiceRepositoryLoader;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class BSFDeployer {
    private static final Logger logger = Logger.getLogger(BSFDeployer.class);
    private static final BSFDeployer instance = new BSFDeployer();
    private volatile boolean repository_tmp_dir_used = false;

    public static BSFDeployer getInstance() {
        return instance;
    }

    private BSFDeployer() {
    }

    public void enable(Composite composite) throws BOSException {
        Configuration conf = Domain.utility.getUtility(IServiceRepositoryLoader.class).getConfiguration(composite);
        if (conf != null) {
            ModuleDescHandler handler = new ModuleDescHandler(composite);
            handler.handle(Configuration.getModuleDescFile(Configuration.getMetaDir(Configuration.toFile(conf.home))));
        }
    }

    public void disable(Composite composite) throws BOSException {
        Configuration conf = Domain.utility.getUtility(IServiceRepositoryLoader.class).getConfiguration(composite);
        if (conf != null) {
            ModuleDescHandler handler = new ModuleDescHandler(composite);
            handler.handle(Configuration.getModuleDescFile(Configuration.getMetaDir(Configuration.toFile(conf.home))));
        }
    }

    public void install(File zipFile) throws BOSException {
        this.putModules(zipFile);
    }

    public void uninstall(Composite composite) throws BOSException {
        Configuration conf = Domain.utility.getUtility(IServiceRepositoryLoader.class).getConfiguration(composite);
        if (conf != null) {
            FileUtils.delete(Configuration.toFile(conf.home));
        }
    }

    public File createEmptyModule(File destDir, Composite target) throws BOSException {
        File from = new File(Configuration.getRepositoryDir(), "sample-0.0.0.1");
        return this.createModule(destDir, from, target);
    }

    public File createModule(File destDir, File from, Composite target) throws BOSException {
        if (destDir == null || target == null || from == null) {
            return null;
        }
        ModuleDescHandler handler = new ModuleDescHandler(target);
        File to = new File(destDir, target.getName() + "-" + target.getVersion());
        FileUtils.copy(from, to, handler);
        return to;
    }

    public File createModule(File destDir, Composite target, Composite source) throws BOSException {
        File from = this.copyModule2Repository(source);
        return this.createModule(destDir, from, target);
    }

    File copyModule2Repository(Composite source) throws BOSException {
        if (source == null) {
            return null;
        }
        File to = new File(Configuration.getRepositoryDir(), source.toString());
        Domain.getInstance(source);
        Configuration conf = Domain.utility.getUtility(IServiceRepositoryLoader.class).getConfiguration(source);
        if (conf != null) {
            FileUtils.copy(Configuration.toFile(conf.home), to, null);
        }
        return to;
    }

    public List<File> pullModules(File destDir, Composite ... sources) throws BOSException {
        if (sources == null) {
            return null;
        }
        ArrayList<File> files = new ArrayList<File>(sources.length);
        for (Composite c : sources) {
            File f = this.createModule(destDir, c, c);
            if (f == null) continue;
            files.add(f);
        }
        return files;
    }

    private Composite[] convertCompositeDesc2Module(String[] moduleDescs) {
        if (moduleDescs == null) {
            return null;
        }
        ArrayList<Composite> comps = new ArrayList<Composite>(moduleDescs.length);
        for (int i = 0; i < moduleDescs.length; ++i) {
            Composite c;
            String[] descs = moduleDescs[i].split("/");
            if (descs.length < 2 || comps.contains(c = Domain.getComposite(descs[0], descs[1]))) continue;
            comps.add(c);
        }
        return comps.toArray(new Composite[0]);
    }

    public List<File> pullModules(File destDir, String ... moduleDescs) throws BOSException {
        return this.pullModules(destDir, this.convertCompositeDesc2Module(moduleDescs));
    }

    public void pullModules2Zip(File zipFile, String ... moduleDescs) throws BOSException {
        this.pullModules2Zip(zipFile, this.convertCompositeDesc2Module(moduleDescs));
    }

    public void pullModules2Zip(File zipFile, Composite ... sources) throws BOSException {
        File parent = zipFile.getParentFile();
        List<File> files = this.pullModules(parent, sources);
        if (files != null) {
            FileUtils.zip(zipFile, files.toArray(new File[0]));
            for (File f : files) {
                FileUtils.delete(f);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File[] unzip2TmpFile(File zipFile) throws BOSException {
        if (this.repository_tmp_dir_used) {
            throw new BSFDeployException("repository/tmp directory is using. try again later.");
        }
        this.repository_tmp_dir_used = true;
        try {
            File tmp = new File(Configuration.getRepositoryDir(), "tmp");
            if (tmp.exists()) {
                FileUtils.delete(tmp);
            }
            FileUtils.unzip(zipFile, tmp);
            File[] fileArray = tmp.listFiles();
            return fileArray;
        }
        finally {
            this.repository_tmp_dir_used = false;
        }
    }

    private void putModules(File zipFile) throws BOSException {
        if (zipFile == null || !zipFile.exists()) {
            throw new BSFDeployException("File not found. name:" + zipFile == null ? "" : zipFile.getAbsolutePath());
        }
        File[] files = this.unzip2TmpFile(zipFile);
        if (files != null) {
            File to;
            for (File f : files) {
                to = new File(Configuration.getModuleDir(), f.getName());
                if (!Domain.utility.getUtility(IServiceRepositoryLoader.class).isBind2Composite(Configuration.toURL(to))) continue;
                throw new BSFDeployException("please uninstall '" + to.getPath() + "' first!");
            }
            for (File f : files) {
                to = new File(Configuration.getModuleDir(), f.getName());
                FileUtils.copy(f, to, null);
            }
        }
    }

    public Composite[] getComposites(File zipFile) throws BOSException {
        File[] files = this.unzip2TmpFile(zipFile);
        if (files != null) {
            ArrayList<Composite> coms = new ArrayList<Composite>(files.length);
            for (File f : files) {
                File meta = Configuration.getMetaDir(f);
                File desc = Configuration.getModuleDescFile(meta);
                if (!meta.exists() || !desc.exists()) continue;
                coms.add(Configuration.getComposite(desc, true));
            }
            return coms.toArray(new Composite[0]);
        }
        return new Composite[0];
    }

    static class Lock {
        private final File lockFile;

        Lock(String name) {
            this.lockFile = new File(new File(Configuration.getConfigDir(), "locks"), name);
        }

        void lock() throws BOSException {
            if (this.lockFile.exists()) {
                throw new BSFDeployException("Lock not available. name:" + this.lockFile.getName());
            }
        }

        void unLock() throws BOSException {
        }
    }
}

