/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bsf.deploy;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.bsf.Composite;
import com.kingdee.bos.bsf.deploy.BSFDeployException;
import com.kingdee.bos.bsf.deploy.BSFDeployer;
import com.kingdee.bos.bsf.deploy.ClusterManager;
import com.kingdee.bos.bsf.deploy.FileUtils;
import com.kingdee.bos.bsf.deploy.IBSFDeployer;
import com.kingdee.bos.bsf.service.Configuration;
import com.kingdee.bos.orm.template.ORMObject;
import java.io.File;

public class BSFDeployerAdapter
extends ORMObject
implements IBSFDeployer {
    public BSFDeployerAdapter() {
        this.registerInterface(IBSFDeployer.class, this);
    }

    @Override
    public void install(String[] packs) throws BOSException {
        for (String p : packs) {
            File f = new File(Configuration.getRepositoryDir(), p);
            try {
                BSFDeployer.getInstance().install(f);
            }
            catch (Exception e) {
                String host = ClusterManager.getLocalHost();
                throw new BSFDeployException("put modules error. name:" + f.getAbsolutePath() + (host == null ? "" : " on:" + host));
            }
        }
    }

    @Override
    public String[] check(String[] packs, String[] md5, String remote) throws BOSException {
        if (packs == null) {
            return null;
        }
        if (md5 != null && packs.length != md5.length) {
            throw new BSFDeployException("packs' length not match md5'length. packs:" + packs.length + " md5:" + md5.length);
        }
        String local = ClusterManager.getLocalHost();
        File[] files = new File[packs.length];
        String[] nmd5 = new String[packs.length];
        for (int i = 0; i < packs.length; ++i) {
            files[i] = new File(Configuration.getRepositoryDir(), packs[i]);
            if (files[i].exists()) {
                nmd5[i] = FileUtils.md5(files[i]);
                if (md5 == null || nmd5[i].equals(md5[i])) continue;
                throw new BSFDeployException("file md5 not consistent beetween " + remote + " and " + local + " name:" + files[i].getAbsolutePath());
            }
            throw new BSFDeployException("pack file not exists. name:" + files[i].getAbsolutePath() + (local == null ? "" : " on " + local));
        }
        return nmd5;
    }

    @Override
    public void uninstall(String module, String version) throws BOSException {
        BSFDeployer.getInstance().uninstall(Composite.getInstance(module, version));
    }

    @Override
    public void enable(String module, String version) throws BOSException {
        BSFDeployer.getInstance().enable(Composite.getInstance(module, version));
    }

    @Override
    public void disable(String module, String version) throws BOSException {
        BSFDeployer.getInstance().disable(Composite.getInstance(module, version));
    }

    @Override
    public String pullModule(String module, String version) throws BOSException {
        if (module == null || version == null) {
            return null;
        }
        String fileName = module + "-" + version + ".zip";
        BSFDeployer.getInstance().pullModules2Zip(new File(Configuration.getRepositoryDir(), fileName), Composite.getInstance(module, version));
        return fileName;
    }
}

