/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bsf.deploy;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.bsf.Composite;
import com.kingdee.bos.bsf.CompositeManager;
import com.kingdee.bos.bsf.deploy.IClusterManager;
import com.kingdee.bos.orm.IORMModel;
import com.kingdee.bos.orm.ORMCoreException;
import com.kingdee.bos.orm.template.ORMObject;
import com.kingdee.bos.rpc.io.loadbalance.IRPCServer;
import com.kingdee.bos.rpc.io.loadbalance.RPCServerView;
import com.kingdee.bos.rpc.io.server.IServer;
import com.kingdee.bos.rpc.io.server.ServerManager;
import com.kingdee.bos.rpcwrapper.RPCEngineFactory;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashSet;

public final class ClusterManager
extends ORMObject
implements IClusterManager {
    public static final IClusterManager INSTANCE = new Factory();

    public static String[] getUrls(boolean excludeLocal, boolean onlyLive) {
        RPCServerView sv = RPCServerView.getLast();
        if (sv != null) {
            IRPCServer[] ss = sv.getServers();
            ArrayList<String> urls = new ArrayList<String>(ss.length);
            for (int i = 0; i < ss.length; ++i) {
                String url;
                IRPCServer s = ss[i];
                if (onlyLive && s.connectionFailed() || StringUtils.isEmpty((String)(url = s.getUrl())) || excludeLocal && ClusterManager.isLocal(url)) continue;
                urls.add(url);
            }
            return urls.toArray(new String[0]);
        }
        return new String[0];
    }

    public static String[] getLocalUrls(boolean onlyLive) {
        String[] all = ClusterManager.getUrls(false, onlyLive);
        ArrayList<String> locals = new ArrayList<String>(all.length);
        for (String s : all) {
            if (!ClusterManager.isLocal(s)) continue;
            locals.add(s);
        }
        return locals.toArray(new String[0]);
    }

    private static boolean isLocal(String url) {
        IServer[] servers = ServerManager.listServers();
        for (int i = 0; i < servers.length; ++i) {
            if (!servers[i].match(url)) continue;
            return true;
        }
        return false;
    }

    public static String[] getHosts() throws BOSException {
        String[] urls = ClusterManager.getUrls(false, false);
        if (urls.length == 0) {
            return urls;
        }
        HashSet<String> hosts = new HashSet<String>(urls.length);
        for (String url : urls) {
            hosts.add(ClusterManager.getHost(url));
        }
        return hosts.toArray(new String[0]);
    }

    public static String getHost(String url) {
        int i = url.indexOf("//");
        if (i >= 0) {
            url = url.substring(i + 2);
        }
        if ((i = url.indexOf(":")) > 0) {
            url = url.substring(0, i);
        }
        return url;
    }

    public static String getLocalHost() {
        String[] urls = ClusterManager.getLocalUrls(true);
        if (urls.length == 0) {
            return null;
        }
        return ClusterManager.getHost(urls[0]);
    }

    public ClusterManager() {
        this.registerInterface(IClusterManager.class, this);
    }

    @Override
    public void enable(String module, String version) throws BOSException {
        CompositeManager.getInstance().enable(Composite.getInstance(module, version));
    }

    @Override
    public void disable(String module, String version) throws BOSException {
        CompositeManager.getInstance().disable(Composite.getInstance(module, version));
    }

    @Override
    public void install() throws BOSException {
        CompositeManager.getInstance().install();
    }

    @Override
    public void uninstall(String module, String version) throws BOSException {
        CompositeManager.getInstance().uninstall(Composite.getInstance(module, version));
    }

    private static class Factory
    implements IClusterManager {
        private Factory() {
        }

        private IClusterManager[] getInstances() {
            String[] urls = ClusterManager.getUrls(true, true);
            ArrayList<IClusterManager> insts = new ArrayList<IClusterManager>(urls.length + 1);
            insts.add(new ClusterManager());
            for (String url : urls) {
                IClusterManager pcs = (IClusterManager)RPCEngineFactory.getEngine((String)url).createObject("com.kingdee.bos.bsf.deploy.ClusterManager", IClusterManager.class);
                insts.add(pcs);
            }
            return insts.toArray(new IClusterManager[0]);
        }

        @Override
        public void enable(String module, String version) throws BOSException {
            for (IClusterManager m : this.getInstances()) {
                m.enable(module, version);
            }
        }

        @Override
        public void disable(String module, String version) throws BOSException {
            for (IClusterManager m : this.getInstances()) {
                m.disable(module, version);
            }
        }

        @Override
        public void install() throws BOSException {
            for (IClusterManager m : this.getInstances()) {
                m.install();
            }
        }

        @Override
        public void uninstall(String module, String version) throws BOSException {
            for (IClusterManager m : this.getInstances()) {
                m.uninstall(module, version);
            }
        }

        public IORMModel queryInterface(Class type) throws ORMCoreException {
            return null;
        }
    }
}

