/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bsf.deploy;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.bsf.deploy.BSFDeployException;
import com.kingdee.bos.bsf.deploy.FileHandler;
import com.kingdee.bos.util.md5;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public final class FileUtils {
    public static final int BUFFER_SIZE = 4096;

    private FileUtils() {
    }

    public static int copy(File in, File out, FileHandler handler) throws BOSException {
        if (in == null || out == null) {
            return 0;
        }
        if (!in.exists()) {
            return 0;
        }
        FileUtils.delete(out);
        if (in.isFile()) {
            if (!out.exists()) {
                File parent = out.getParentFile();
                if (!parent.exists()) {
                    parent.mkdirs();
                }
                try {
                    out.createNewFile();
                }
                catch (IOException e) {
                    throw new BSFDeployException("bsf deploy create file error. file:" + out.getPath(), e);
                }
            }
            int size = 0;
            try {
                size = FileUtils.copy(new BufferedInputStream(new FileInputStream(in)), new BufferedOutputStream(new FileOutputStream(out)));
            }
            catch (Exception e) {
                throw new BSFDeployException("bsf deploy copy file error. tofile:" + out.getPath() + " from file:" + in.getPath(), e);
            }
            if (handler != null) {
                // empty if block
            }
            return size;
        }
        if (in.isDirectory()) {
            File[] subs = in.listFiles();
            if (subs == null || subs.length == 0) {
                if (!out.exists()) {
                    out.mkdirs();
                }
            } else {
                int size = 0;
                for (File s : subs) {
                    size += FileUtils.copy(s, new File(out, s.getName()), handler);
                }
                return size;
            }
            return 0;
        }
        return 0;
    }

    public static void delete(File file) {
        if (file.exists()) {
            File[] subs;
            if (file.isDirectory() && (subs = file.listFiles()) != null) {
                for (File s : subs) {
                    FileUtils.delete(s);
                }
            }
            file.delete();
        }
    }

    public static void clear(File dir) {
        File[] subs;
        if (dir.exists() && dir.isDirectory() && (subs = dir.listFiles()) != null) {
            for (File s : subs) {
                FileUtils.delete(s);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int copy(InputStream in, OutputStream out) throws IOException {
        if (in == null || out == null) {
            return 0;
        }
        try {
            int byteCount = 0;
            byte[] buffer = new byte[4096];
            int bytesRead = -1;
            while ((bytesRead = in.read(buffer)) != -1) {
                out.write(buffer, 0, bytesRead);
                byteCount += bytesRead;
            }
            out.flush();
            int n = byteCount;
            return n;
        }
        finally {
            try {
                in.close();
            }
            finally {
                out.close();
            }
        }
    }

    public static void zip(File target, File[] files) throws BOSException {
        File parent;
        FileUtils.delete(target);
        if (!target.exists() && !(parent = target.getParentFile()).exists()) {
            parent.mkdirs();
        }
        ZipOutputStream out = null;
        try {
            out = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(target)));
            for (File f : files) {
                FileUtils.zip(f, f, out);
            }
        }
        catch (Exception e) {
            throw new BSFDeployException("bsf deploy zip file error. file:" + target.getPath(), e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static void zip(File f, File root, ZipOutputStream out) throws BOSException {
        byte[] data = new byte[4096];
        BufferedInputStream in = null;
        String pathName = f.getName();
        if (root != null) {
            pathName = f.getPath().substring(root.getParent().length() + 1);
        }
        if (f.isFile()) {
            try {
                int count;
                in = new BufferedInputStream(new FileInputStream(f));
                ZipEntry entry = new ZipEntry(pathName);
                out.putNextEntry(entry);
                while ((count = in.read(data, 0, 4096)) != -1) {
                    out.write(data, 0, count);
                }
            }
            catch (Exception e) {
                throw new BSFDeployException("bsf deploy zip file error. file:" + f.getPath(), e);
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (f.isDirectory()) {
            File[] subs = f.listFiles();
            if (subs == null || subs.length == 0) {
                ZipEntry entry = new ZipEntry(pathName + "/");
                try {
                    out.putNextEntry(entry);
                }
                catch (IOException e) {
                    throw new BSFDeployException("bsf deploy zip file error. file:" + f.getPath(), e);
                }
            } else {
                for (File s : subs) {
                    FileUtils.zip(s, root, out);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzip(File zip, File dir) throws BOSException {
        if (dir.isFile()) {
            dir.delete();
        }
        if (!dir.exists()) {
            dir.mkdirs();
        }
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(zip);
            Enumeration<? extends ZipEntry> emu = zipFile.entries();
            byte[] data = new byte[4096];
            while (emu.hasMoreElements()) {
                ZipEntry entry = emu.nextElement();
                if (entry.isDirectory()) {
                    new File(dir, entry.getName()).mkdirs();
                    continue;
                }
                File file = new File(dir, entry.getName());
                File parent = file.getParentFile();
                if (parent != null && !parent.exists()) {
                    parent.mkdirs();
                }
                FilterOutputStream bos = null;
                BufferedInputStream bis = null;
                try {
                    int count;
                    bos = new BufferedOutputStream(new FileOutputStream(file), 4096);
                    bis = new BufferedInputStream(zipFile.getInputStream(entry));
                    while ((count = bis.read(data, 0, 4096)) != -1) {
                        ((BufferedOutputStream)bos).write(data, 0, count);
                    }
                    ((BufferedOutputStream)bos).flush();
                }
                catch (Exception e) {
                    throw new BSFDeployException("bsf deploy unzip entry error. file:" + file.getPath(), e);
                }
                finally {
                    try {
                        bos.close();
                    }
                    finally {
                        bis.close();
                    }
                }
            }
        }
        catch (Exception e) {
            throw new BSFDeployException("bsf deploy unzip file error. file:" + zip.getPath(), e);
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static String md5(File file) throws BOSException {
        if (file == null || !file.exists()) {
            return null;
        }
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            md5 m5 = new md5((InputStream)fis);
            m5.getDigest();
            String string = m5.getStringDigest();
            return string;
        }
        catch (Exception e) {
            throw new BSFDeployException("md5 compute error. file:" + file.getPath(), e);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void write(File file, byte[] bytes) throws BOSException {
        if (file == null || bytes == null) {
            return;
        }
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(file);
            out.write(bytes);
        }
        catch (Exception e) {
            throw new BSFDeployException("md5 compute error. file:" + file.getPath(), e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static byte[] read(File file) throws BOSException {
        if (file == null || !file.exists() || file.isDirectory()) {
            return new byte[0];
        }
        byte[] data = new byte[4096];
        FilterOutputStream bos = null;
        BufferedInputStream bis = null;
        try {
            int count;
            ByteArrayOutputStream output = new ByteArrayOutputStream(Long.valueOf(file.length()).intValue());
            bos = new BufferedOutputStream(output, 4096);
            bis = new BufferedInputStream(new FileInputStream(file));
            while ((count = bis.read(data, 0, 4096)) != -1) {
                ((BufferedOutputStream)bos).write(data, 0, count);
            }
            ((BufferedOutputStream)bos).flush();
            byte[] byArray = output.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            throw new BSFDeployException("bsf deploy unzip entry error. file:" + file.getPath(), e);
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException iOException) {}
            }
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

