/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bsf.deploy;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.bsf.Composite;
import com.kingdee.bos.bsf.deploy.BSFDeployException;
import com.kingdee.bos.bsf.deploy.FileHandler;
import com.kingdee.bos.bsf.parsing.Properties;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;

public class ModuleDescHandler
implements FileHandler {
    private final Composite composite;

    public ModuleDescHandler(Composite composite) {
        this.composite = composite;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(File f) throws BOSException {
        if ("module.desc".equals(f.getName())) {
            Properties properties = new Properties();
            Reader input = null;
            try {
                input = new InputStreamReader((InputStream)new FileInputStream(f), "UTF-8");
                properties.load(input);
            }
            catch (Exception e) {
            }
            finally {
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            properties.put("module", this.composite.getName());
            properties.put("version", this.composite.getVersion());
            properties.put("alias", this.composite.getAlias());
            properties.put("description", this.composite.getDescription());
            properties.put("state", Integer.toString(this.composite.getState()));
            Writer output = null;
            try {
                output = new OutputStreamWriter((OutputStream)new FileOutputStream(f), "UTF-8");
                properties.store(output, "state: 0 - disable, 1 - enable");
            }
            catch (Exception e) {
                throw new BSFDeployException("module.desc create error. file:" + f.getPath(), e);
            }
            finally {
                if (output != null) {
                    try {
                        output.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }
}

