/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bsf.deploy.net;

import com.kingdee.bos.bsf.deploy.net.Callback;
import com.kingdee.bos.bsf.deploy.net.EndPoint;
import com.kingdee.bos.bsf.deploy.net.Parser;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.log4j.Logger;

public class Connection {
    private static final Logger logger = Logger.getLogger(Connection.class);
    private boolean isFilling = false;
    private final EndPoint endPoint;
    private final ReadCallback readCallback;
    private final Parser parser;

    Connection(EndPoint endPoint) {
        this.endPoint = endPoint;
        this.readCallback = new ReadCallback();
        this.parser = new Parser(this);
    }

    void onOpen() {
    }

    void onFillable() {
        ByteBuffer buffer = ByteBuffer.allocate(4096);
        boolean readMore = false;
        this.isFilling = true;
        boolean bl = readMore = this.read(buffer) != -1;
        if (readMore) {
            this.fillInterested();
        } else {
            this.isFilling = false;
        }
    }

    void write(ByteBuffer buffer) {
        this.endPoint.write(null, buffer);
    }

    private int read(ByteBuffer buffer) {
        try {
            while (true) {
                int filled = this.endPoint.fill(buffer);
                System.out.println("received:" + filled);
                if (filled == 0) {
                    return 0;
                }
                if (filled < 0) {
                    return -1;
                }
                this.parser.parse(buffer);
            }
        }
        catch (IOException e) {
            logger.error((Object)"buffer parse error.", (Throwable)e);
            return -1;
        }
    }

    void fillInterested() {
        this.endPoint.fillInterested(this.readCallback);
    }

    void onClose() {
    }

    class ReadCallback
    implements Callback {
        ReadCallback() {
        }

        @Override
        public void succeeded() {
            Connection.this.onFillable();
        }

        @Override
        public void failed(Throwable x) {
        }
    }
}

