/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bsf.deploy.net;

import com.kingdee.bos.bsf.deploy.net.BufferUtil;
import com.kingdee.bos.bsf.deploy.net.Callback;
import com.kingdee.bos.bsf.deploy.net.FillInterest;
import com.kingdee.bos.bsf.deploy.net.WriteFlusher;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;

class EndPoint {
    private static final Logger logger = Logger.getLogger(EndPoint.class);
    private final Runnable updateTask = new Runnable(){

        @Override
        public void run() {
            try {
                if (EndPoint.this.channel.isOpen()) {
                    int oldInterestOps = EndPoint.this.key.interestOps();
                    int newInterestOps = EndPoint.this.interestOps.get();
                    if (newInterestOps != oldInterestOps) {
                        EndPoint.this.setKeyInterests(oldInterestOps, newInterestOps);
                    }
                }
            }
            catch (CancelledKeyException x) {
                logger.error((Object)"cancel key", (Throwable)x);
                EndPoint.this.close();
            }
            catch (Exception x) {
                logger.error((Object)"interest update error.", (Throwable)x);
                EndPoint.this.close();
            }
        }
    };
    private final SocketChannel channel;
    private final SelectionKey key;
    private final AtomicBoolean open = new AtomicBoolean();
    private volatile boolean ishut;
    private volatile boolean oshut;
    private final AtomicInteger interestOps = new AtomicInteger();
    private final FillInterest fillInterest = new FillInterest(){

        @Override
        protected boolean needsFill() throws IOException {
            return EndPoint.this.needsFill();
        }
    };
    private final WriteFlusher writeFlusher = new WriteFlusher(this){

        @Override
        protected void onIncompleteFlushed() {
            EndPoint.this.onIncompleteFlush();
        }
    };

    EndPoint(SelectionKey key, SocketChannel channel) {
        this.key = key;
        this.channel = channel;
    }

    protected boolean needsFill() {
        this.updateLocalInterests(1, true);
        return false;
    }

    protected void onIncompleteFlush() {
        this.updateLocalInterests(4, true);
    }

    void onSelected() {
        int oldInterestOps = this.key.interestOps();
        int readyOps = this.key.readyOps();
        int newInterestOps = oldInterestOps & ~readyOps;
        this.setKeyInterests(oldInterestOps, newInterestOps);
        this.updateLocalInterests(readyOps, false);
        if (this.key.isReadable()) {
            this.fillInterest.fillable();
        }
        if (this.key.isWritable()) {
            this.writeFlusher.completeWrite();
        }
    }

    private void updateLocalInterests(int operation, boolean add) {
        block3: {
            int newInterestOps;
            int oldInterestOps;
            do {
                oldInterestOps = this.interestOps.get();
                newInterestOps = add ? oldInterestOps | operation : oldInterestOps & ~operation;
                if (this.isInputShutdown()) {
                    newInterestOps &= 0xFFFFFFFE;
                }
                if (this.isOutputShutdown()) {
                    newInterestOps &= 0xFFFFFFFB;
                }
                if (newInterestOps == oldInterestOps) break block3;
            } while (!this.interestOps.compareAndSet(oldInterestOps, newInterestOps));
            this.updateTask.run();
        }
    }

    private void setKeyInterests(int oldInterestOps, int newInterestOps) {
        this.key.interestOps(newInterestOps);
    }

    public boolean isOpen() {
        return this.open.get();
    }

    public void onOpen() {
        this.open.compareAndSet(false, true);
    }

    public void close() {
        if (this.open.compareAndSet(true, false)) {
            try {
                this.channel.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.ishut = true;
                this.oshut = true;
            }
        }
    }

    protected void shutdownInput() {
        this.ishut = true;
        if (this.oshut) {
            this.close();
        }
    }

    public void shutdownOutput() {
        this.oshut = true;
        if (this.channel.isOpen()) {
            try {
                if (!this.channel.socket().isOutputShutdown()) {
                    this.channel.socket().shutdownOutput();
                }
            }
            catch (IOException e) {
                logger.error((Object)"shutdown error.", (Throwable)e);
            }
            finally {
                if (this.ishut) {
                    this.close();
                }
            }
        }
    }

    public boolean isOutputShutdown() {
        return this.oshut || !this.channel.isOpen() || this.channel.socket().isOutputShutdown();
    }

    public boolean isInputShutdown() {
        return this.ishut || !this.channel.isOpen() || this.channel.socket().isInputShutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int fill(ByteBuffer buffer) throws IOException {
        if (this.ishut) {
            return -1;
        }
        int pos = BufferUtil.flipToFill(buffer);
        try {
            int filled = this.channel.read(buffer);
            if (filled <= 0 && filled == -1) {
                this.shutdownInput();
            }
            int n = filled;
            return n;
        }
        catch (IOException e) {
            this.shutdownInput();
            int n = -1;
            return n;
        }
        finally {
            BufferUtil.flipToFlush(buffer, pos);
        }
    }

    public void fillInterested(Callback callback) throws IllegalStateException {
        this.fillInterest.register(callback);
    }

    public boolean flush(ByteBuffer ... buffers) throws IOException {
        int flushed = 0;
        if (buffers.length == 1) {
            flushed = this.channel.write(buffers[0]);
        } else if (buffers.length > 1 && this.channel instanceof GatheringByteChannel) {
            flushed = (int)this.channel.write(buffers, 0, buffers.length);
        } else {
            for (ByteBuffer b : buffers) {
                if (!b.hasRemaining()) continue;
                int l = this.channel.write(b);
                if (l > 0) {
                    flushed += l;
                }
                if (b.hasRemaining()) break;
            }
        }
        boolean all_flushed = true;
        if (flushed > 0) {
            for (ByteBuffer b : buffers) {
                if (BufferUtil.isEmpty(b)) {
                    BufferUtil.clear(b);
                    continue;
                }
                all_flushed = false;
            }
        }
        return all_flushed;
    }

    void write(Callback callback, ByteBuffer ... buffers) {
        this.writeFlusher.write(callback, buffers);
    }
}

