/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bsf.deploy.net;

import com.kingdee.bos.bsf.deploy.net.Callback;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class FillInterest {
    private final AtomicBoolean _interested = new AtomicBoolean(false);
    private volatile Callback _callback;

    protected FillInterest() {
    }

    public void register(Callback callback) throws IllegalStateException {
        if (!this._interested.compareAndSet(false, true)) {
            throw new IllegalStateException("read pending.");
        }
        this._callback = callback;
        try {
            if (this.needsFill()) {
                this.fillable();
            }
        }
        catch (IOException e) {
            this.onFail(e);
        }
    }

    public void fillable() {
        if (this._interested.compareAndSet(true, false)) {
            Callback callback = this._callback;
            this._callback = null;
            callback.succeeded();
        }
    }

    public boolean isInterested() {
        return this._interested.get();
    }

    public void onFail(Throwable cause) {
        if (this._interested.compareAndSet(true, false)) {
            Callback callback = this._callback;
            this._callback = null;
            callback.failed(cause);
        }
    }

    public void onClose() {
        if (this._interested.compareAndSet(true, false)) {
            Callback callback = this._callback;
            this._callback = null;
            callback.failed(new ClosedChannelException());
        }
    }

    public String toString() {
        return String.format("FillInterest@%x{%b,%s}", this.hashCode(), this._interested.get(), this._callback);
    }

    protected abstract boolean needsFill() throws IOException;
}

