/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bsf.deploy.net;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.bsf.deploy.net.KeeperClient;
import com.kingdee.bos.bsf.deploy.net.KeeperServer;
import java.io.File;
import java.io.IOException;

public final class Keeper {
    private static final Keeper instance = new Keeper();

    private Keeper() {
    }

    public static Keeper getInstance() {
        return instance;
    }

    public void copyFile(File f, String[] hosts) throws BOSException {
        if (hosts != null) {
            for (String h : hosts) {
                try {
                    String result = KeeperClient.copyFile(h, f);
                    if ("ok".equals(result)) continue;
                    throw new BOSException("file copy error. file:" + f.getAbsolutePath() + " host:" + h + " cause:" + result);
                }
                catch (IOException e) {
                    throw new BOSException("file copy error. file:" + f.getAbsolutePath() + " host:" + h, (Throwable)e);
                }
            }
        }
    }

    static {
        KeeperServer.start();
    }
}

