/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bsf.deploy.net;

import com.kingdee.bos.bsf.deploy.net.BufferUtil;
import com.kingdee.bos.bsf.deploy.net.Frame;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.charset.CharacterCodingException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.log4j.Logger;

class KeeperClient {
    private static final Logger logger = Logger.getLogger(KeeperClient.class);
    private final LinkedBlockingQueue<Handler> handlers = new LinkedBlockingQueue();
    private Handler reading = null;
    private final ByteBuffer buffer = ByteBuffer.allocate(1024);
    private final Selector selector = Selector.open();
    private final SocketChannel channel = SocketChannel.open();
    private volatile boolean error = false;
    private static final HashMap<String, KeeperClient> clients = new HashMap(4);

    KeeperClient(String ip, int port) throws IOException {
        this.channel.configureBlocking(false);
        this.channel.connect(new InetSocketAddress(ip, port));
        this.channel.register(this.selector, 8);
    }

    void close() throws IOException {
        this.selector.close();
        this.channel.close();
    }

    void add(Handler handler) {
        try {
            this.handlers.put(handler);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void listen() throws IOException {
        block2: while (true) {
            this.selector.select();
            Iterator<SelectionKey> ite = this.selector.selectedKeys().iterator();
            while (true) {
                if (!ite.hasNext()) continue block2;
                SelectionKey key = ite.next();
                ite.remove();
                if (!key.isValid()) continue;
                try {
                    this.process(key);
                    continue;
                }
                catch (Exception e) {
                    logger.error((Object)"keeper client process error", (Throwable)e);
                    continue;
                }
                break;
            }
            break;
        }
    }

    public void process(SelectionKey key) throws IOException {
        Handler h;
        if (key.isConnectable()) {
            SocketChannel channel = (SocketChannel)key.channel();
            if (channel.isConnectionPending()) {
                channel.finishConnect();
            }
            channel.configureBlocking(false);
            SelectionKey k = channel.register(this.selector, 4);
            k.attach(new LinkedBlockingQueue());
            logger.debug((Object)"connected.");
        }
        if (key.isWritable() && (h = this.handlers.poll()) != null) {
            h.onWrite(key);
            LinkedBlockingQueue handlers = (LinkedBlockingQueue)key.attachment();
            handlers.offer(h);
            key.interestOps(key.interestOps() | 1);
        }
        if (key.isReadable()) {
            LinkedBlockingQueue handlers = (LinkedBlockingQueue)key.attachment();
            if (this.reading == null) {
                this.reading = (Handler)handlers.poll();
            }
            if (this.reading != null) {
                if (this.reading.onRead(key)) {
                    this.reading = null;
                    key.interestOps(key.interestOps() | 4);
                } else {
                    key.interestOps(key.interestOps() | 1);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static KeeperClient getInstance(String ip) throws IOException {
        KeeperClient c = clients.get(ip);
        if (c == null) {
            HashMap<String, KeeperClient> hashMap = clients;
            synchronized (hashMap) {
                c = clients.get(ip);
                if (c == null || c.error) {
                    final KeeperClient f = c = new KeeperClient(ip, 11119);
                    Thread t = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                f.listen();
                            }
                            catch (IOException e) {
                                logger.error((Object)"BSF keeper client error.", (Throwable)e);
                                f.error = true;
                                try {
                                    f.close();
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                            }
                        }
                    }, "BSF Keeper for " + ip);
                    t.setDaemon(true);
                    t.start();
                    if (!c.error) {
                        clients.put(ip, c);
                    }
                }
            }
        }
        return c;
    }

    public static String transText(String ip, String text) throws IOException {
        if (ip == null || text == null || text.length() == 0) {
            return null;
        }
        KeeperClient c = KeeperClient.getInstance(ip);
        TextTrans h = new TextTrans(c.buffer, text);
        c.add(h);
        return h.getResult();
    }

    public static String copyFile(String ip, File file) throws IOException {
        if (file == null || ip == null || !file.exists()) {
            return null;
        }
        KeeperClient c = KeeperClient.getInstance(ip);
        FileCopy h = new FileCopy(c.buffer, file);
        c.add(h);
        return h.getResult();
    }

    static class TextTrans
    extends Handler {
        private final String text;

        TextTrans(ByteBuffer buffer, String text) {
            super(buffer);
            this.text = text;
        }

        @Override
        public void onWrite(SelectionKey key) throws IOException {
            logger.debug((Object)"write text");
            SocketChannel channel = (SocketChannel)key.channel();
            ByteBuffer bytes = Frame.encoder.encode(CharBuffer.wrap(this.text));
            int len = bytes.limit();
            ByteBuffer buffer = ByteBuffer.allocate(3 + len);
            buffer.put((byte)0);
            buffer.putShort((short)len);
            buffer.put(bytes);
            buffer.flip();
            channel.write(buffer);
        }
    }

    static class FileCopy
    extends Handler {
        private final File file;

        FileCopy(ByteBuffer buffer, File file) {
            super(buffer);
            this.file = file;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onWrite(SelectionKey key) throws IOException {
            SocketChannel channel = (SocketChannel)key.channel();
            ByteBuffer bytes = Frame.encoder.encode(CharBuffer.wrap(this.file.getName()));
            int len = bytes.limit();
            ByteBuffer buffer = ByteBuffer.allocate(3 + len);
            buffer.put((byte)1);
            buffer.putShort((short)len);
            buffer.put(bytes);
            buffer.flip();
            int i = BufferUtil.write(channel, buffer);
            logger.debug((Object)(" trans:" + i));
            FileInputStream input = null;
            AbstractInterruptibleChannel fileChannel = null;
            try {
                input = new FileInputStream(this.file);
                fileChannel = input.getChannel();
                ByteBuffer fbuf = ByteBuffer.allocate(4096);
                ByteBuffer head = ByteBuffer.allocate(3);
                boolean first = true;
                while ((len = ((FileChannel)fileChannel).read(fbuf)) != -1) {
                    if (len <= 0) continue;
                    if (!first) {
                        head.put((byte)0);
                    } else {
                        first = false;
                    }
                    head.putShort((short)len);
                    fbuf.flip();
                    head.flip();
                    i = BufferUtil.write(channel, head);
                    head.clear();
                    fbuf.clear();
                    logger.debug((Object)(" trans:" + (i += BufferUtil.write(channel, fbuf))));
                }
                head.clear();
                head.put((byte)1);
                head.flip();
                i = BufferUtil.write(channel, head);
                logger.debug((Object)(" end:" + i));
            }
            finally {
                if (fileChannel != null) {
                    fileChannel.close();
                }
                if (input != null) {
                    input.close();
                }
            }
        }
    }

    static abstract class Handler {
        private volatile int state = 0;
        private ReadState readState = ReadState.Start;
        private short length;
        private final Thread caller = Thread.currentThread();
        private final ByteBuffer buffer;
        private byte[] result;

        Handler(ByteBuffer buffer) {
            this.buffer = buffer;
        }

        abstract void onWrite(SelectionKey var1) throws IOException;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean onRead(SelectionKey key) throws IOException {
            SocketChannel channel = (SocketChannel)key.channel();
            int pos = 0;
            do {
                BufferUtil.flipToFill(this.buffer);
                int read = channel.read(this.buffer);
                if (read == 0) {
                    return false;
                }
                if (read == -1) {
                    channel.close();
                    Handler handler = this;
                    synchronized (handler) {
                        this.state = 1;
                        this.notify();
                    }
                    return true;
                }
                BufferUtil.flipToFlush(this.buffer, pos);
            } while (!this.parse());
            Handler handler = this;
            synchronized (handler) {
                this.state = 1;
                this.notify();
            }
            return true;
        }

        boolean parse() {
            while (this.buffer.hasRemaining()) {
                switch (this.readState) {
                    case Start: {
                        if (this.buffer.remaining() >= 2) {
                            this.length = this.buffer.getShort();
                            this.readState = ReadState.Read;
                            break;
                        }
                        return false;
                    }
                    case Read: {
                        if (this.buffer.remaining() >= this.length) {
                            this.result = new byte[this.length];
                            this.buffer.get(this.result);
                            return true;
                        }
                        return false;
                    }
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        String getResult() {
            if (this.caller != Thread.currentThread()) {
                throw new IllegalAccessError("call error.");
            }
            while (this.state == 0) {
                Handler handler = this;
                synchronized (handler) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            try {
                return Frame.decoder.decode(ByteBuffer.wrap(this.result)).toString();
            }
            catch (CharacterCodingException e) {
                return "encode error.";
            }
        }

        static enum ReadState {
            Start,
            Read;

        }
    }
}

