/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bsf.deploy.net;

import com.kingdee.bos.bsf.deploy.net.Connection;
import com.kingdee.bos.bsf.deploy.net.EndPoint;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import org.apache.log4j.Logger;

class KeeperServer {
    private static final Logger logger = Logger.getLogger(KeeperServer.class);
    static final int port = 11119;
    private final Selector selector;

    KeeperServer(int port) throws IOException {
        ServerSocketChannel serverChannel = ServerSocketChannel.open();
        serverChannel.configureBlocking(false);
        try {
            serverChannel.socket().bind(new InetSocketAddress(port));
        }
        catch (IOException e) {
            serverChannel.close();
            throw e;
        }
        this.selector = Selector.open();
        serverChannel.register(this.selector, 16);
    }

    public void listen() throws IOException {
        block0: while (true) {
            this.selector.select();
            Iterator<SelectionKey> ite = this.selector.selectedKeys().iterator();
            while (true) {
                if (!ite.hasNext()) continue block0;
                SelectionKey key = ite.next();
                ite.remove();
                if (!key.isValid()) continue;
                this.process(key);
            }
            break;
        }
    }

    private void process(SelectionKey key) throws IOException {
        EndPoint endPoint = (EndPoint)key.attachment();
        if (endPoint != null) {
            endPoint.onSelected();
        } else if (key.isAcceptable()) {
            ServerSocketChannel server = (ServerSocketChannel)key.channel();
            SocketChannel channel = server.accept();
            channel.configureBlocking(false);
            key = channel.register(this.selector, 0);
            endPoint = new EndPoint(key, channel);
            Connection connection = new Connection(endPoint);
            connection.fillInterested();
            key.attach(endPoint);
        }
    }

    public static void start() {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    new KeeperServer(11119).listen();
                }
                catch (Exception e) {
                    logger.error((Object)"BSF Keeper Server error.", (Throwable)e);
                }
            }
        }, "BSF Keeper Server");
        t.setDaemon(true);
        t.start();
    }
}

