/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bsf.deploy.net;

import com.kingdee.bos.bsf.deploy.net.BufferUtil;
import com.kingdee.bos.bsf.deploy.net.Connection;
import com.kingdee.bos.bsf.deploy.net.Frame;
import java.io.FileOutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import org.apache.log4j.Logger;

class Parser {
    private static final Logger logger = Logger.getLogger(Parser.class);
    private State state = State.Start;
    private short length;
    private Frame frame;
    private FileChannel fileChannel;
    private final Connection connection;

    Parser(Connection connection) {
        this.connection = connection;
    }

    void parse(ByteBuffer buffer) {
        if (buffer.remaining() <= 0) {
            return;
        }
        try {
            while (this.parseFrame(buffer)) {
                this.notifyFrame(this.frame);
                this.frame = null;
                this.state = State.Start;
            }
        }
        catch (Exception e) {
            this.notifyException(e);
        }
    }

    private boolean parseFrame(ByteBuffer buffer) throws Exception {
        if (buffer.remaining() <= 0) {
            return false;
        }
        while (buffer.hasRemaining()) {
            switch (this.state) {
                case Start: {
                    byte b = buffer.get();
                    if (b == 0) {
                        this.frame = new Frame(Frame.Type.Text);
                        this.state = State.Text;
                        break;
                    }
                    if (b != 1) break;
                    this.frame = new Frame(Frame.Type.File);
                    this.state = State.File;
                    break;
                }
                case Text: {
                    if (buffer.remaining() >= 2) {
                        this.length = buffer.getShort();
                        this.state = State.TextRead;
                        break;
                    }
                    return false;
                }
                case TextRead: {
                    if (buffer.remaining() >= this.length) {
                        byte[] dst = new byte[this.length];
                        buffer.get(dst);
                        this.frame.setData(dst);
                        return true;
                    }
                    return false;
                }
                case File: {
                    if (buffer.remaining() >= 2) {
                        this.length = buffer.getShort();
                        this.state = State.FileNameRead;
                        break;
                    }
                    return false;
                }
                case FileNameRead: {
                    if (buffer.remaining() >= this.length) {
                        byte[] dst = new byte[this.length];
                        buffer.get(dst);
                        this.frame.setData(dst);
                        this.state = State.FileContent;
                        break;
                    }
                    return false;
                }
                case FileContent: {
                    if (buffer.remaining() >= 2) {
                        this.length = buffer.getShort();
                        this.state = State.FileContentRead;
                        break;
                    }
                    return false;
                }
                case FileContentRead: {
                    if (this.fileChannel == null) {
                        this.fileChannel = new FileOutputStream(this.frame.getFile()).getChannel();
                    }
                    logger.debug((Object)("length:" + this.length));
                    if (buffer.remaining() >= this.length) {
                        int limit = buffer.limit();
                        buffer.limit(buffer.position() + this.length);
                        int i = BufferUtil.write(this.fileChannel, buffer);
                        logger.debug((Object)("write len:" + i));
                        buffer.limit(limit);
                        this.state = State.FileCondition;
                        break;
                    }
                    int l = BufferUtil.write(this.fileChannel, buffer);
                    this.length = (short)(this.length - l);
                    logger.debug((Object)("write len:" + l + " also need:" + this.length));
                    break;
                }
                case FileCondition: {
                    byte b = buffer.get();
                    if (b == 0) {
                        this.state = State.FileContent;
                        break;
                    }
                    this.fileChannel.close();
                    this.fileChannel = null;
                    return true;
                }
            }
        }
        return false;
    }

    void notifyFrame(Frame f) {
        try {
            ByteBuffer bytes = Frame.encoder.encode(CharBuffer.wrap("ok"));
            int len = bytes.limit();
            ByteBuffer buffer = ByteBuffer.allocate(len + 2);
            buffer.putShort((short)len);
            buffer.put(bytes);
            buffer.flip();
            this.connection.write(buffer);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void notifyException(Exception e) {
        try {
            ByteBuffer bytes = Frame.encoder.encode(CharBuffer.wrap("error " + e.getMessage()));
            int len = bytes.limit();
            ByteBuffer buffer = ByteBuffer.allocate(len + 2);
            buffer.putShort((short)len);
            buffer.put(bytes);
            buffer.flip();
            this.connection.write(buffer);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static enum State {
        Start,
        Text,
        TextRead,
        File,
        FileNameRead,
        FileContent,
        FileContentRead,
        FileCondition;

    }
}

