/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bsf.facade;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.bsf.facade.XmlFacadeParser;
import com.kingdee.bos.bsf.manage.FacadeHeadBean;
import com.kingdee.bos.bsf.manage.FacadeMethodBean;
import com.kingdee.bos.bsf.parsing.PathParser;
import com.kingdee.bos.bsf.parsing.ServiceParseException;
import com.kingdee.bos.bsf.service.Configuration;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class FacadeFileScan {
    private static List<URL> urls;
    public static final String OPENAPITAG = "OpenAPI";
    public static final String CMENUOPENAPITAG = "MenuOpenAPI";
    public static final String REGEX_PACAGE_FACADE = "com.kingdee.*.openapi.*";
    private Map<String, FacadeHeadBean> facadesBeanMap;
    private Map<String, List<FacadeHeadBean>> facadesPKGMap;
    private Map<String, List<FacadeHeadBean>> facadesModlenameMap;
    private static FacadeFileScan instance;
    boolean swithch = false;

    private FacadeFileScan(URL home) throws BOSException {
        if (urls != null) {
            return;
        }
        urls = new ArrayList<URL>();
        try {
            urls.addAll(new PathParser().expandPaths(home.getPath() + "bos/*.jar"));
            urls.addAll(new PathParser().expandPaths(home.getPath() + "eas/*.jar"));
            urls.addAll(new PathParser().expandPaths(home.getPath() + "sp/*.jar"));
        }
        catch (Exception e) {
            throw new ServiceParseException("service parse error. can't find jars. url:" + home, e);
        }
    }

    public Map<String, FacadeHeadBean> loadfacadesSet(String regex) throws BOSException {
        return this.loadfacadesSet(regex, urls);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, FacadeHeadBean> loadfacadesSet(String regex, List<URL> urls) throws BOSException {
        Class<FacadeFileScan> clazz = FacadeFileScan.class;
        synchronized (FacadeFileScan.class) {
            if (this.facadesBeanMap != null) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return this.facadesBeanMap;
            }
            this.facadesBeanMap = new HashMap<String, FacadeHeadBean>();
            for (URL url : urls) {
                File file = Configuration.toFile(url);
                if (!file.exists()) continue;
                if (file.isFile()) {
                    JarFile jarFile = null;
                    try {
                        jarFile = new JarFile(file);
                        Enumeration<JarEntry> entries = jarFile.entries();
                        while (entries.hasMoreElements()) {
                            JarEntry entry = entries.nextElement();
                            if (!this.traverse(regex, entry)) continue;
                            this.facadesBeanMap.put(entry.getName(), new XmlFacadeParser().parse(jarFile.getInputStream(entry)));
                        }
                        continue;
                    }
                    catch (IOException e) {
                        throw new ServiceParseException("service parse error. file:" + file.getPath(), e);
                    }
                    finally {
                        if (jarFile == null) continue;
                        try {
                            jarFile.close();
                            continue;
                        }
                        catch (IOException iOException) {}
                    }
                }
                this.traverse(regex, null, file);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return this.facadesBeanMap;
        }
    }

    public Set<String> getFacadePackage() throws BOSException {
        if (this.facadesBeanMap == null) {
            this.loadfacadesSet(REGEX_PACAGE_FACADE);
        }
        if (this.facadesPKGMap == null || this.facadesModlenameMap == null) {
            this.facadesPKGMap = new HashMap<String, List<FacadeHeadBean>>();
            this.facadesModlenameMap = new HashMap<String, List<FacadeHeadBean>>();
            for (String facadeName : this.facadesBeanMap.keySet()) {
                FacadeHeadBean fhbean = this.facadesBeanMap.get(facadeName);
                String key = fhbean.get_package();
                List<FacadeHeadBean> ls = this.facadesPKGMap.get(key);
                if (ls == null) {
                    ls = new ArrayList<FacadeHeadBean>();
                    this.facadesPKGMap.put(key, ls);
                }
                ls.add(fhbean);
                String modleName = fhbean.get_menuModle();
                List<FacadeHeadBean> lsmodlename = this.facadesModlenameMap.get(modleName);
                if (lsmodlename == null) {
                    lsmodlename = new ArrayList<FacadeHeadBean>();
                    this.facadesModlenameMap.put(modleName, lsmodlename);
                }
                lsmodlename.add(fhbean);
            }
        }
        return this.facadesPKGMap.keySet();
    }

    public List<FacadeHeadBean> getFacadeListByPackage(String pkg) throws BOSException {
        if (null == this.facadesPKGMap) {
            this.getFacadePackage();
        }
        return this.facadesPKGMap.get(pkg);
    }

    public List<FacadeHeadBean> getFacadeListByModule(String moduleName) throws BOSException {
        if (null == this.facadesModlenameMap) {
            this.getFacadePackage();
        }
        return this.facadesModlenameMap.get(moduleName);
    }

    public FacadeHeadBean getFacadeBean(String facadefullname) throws BOSException {
        if (!facadefullname.endsWith(".facade")) {
            facadefullname = facadefullname + ".facade";
        }
        if (this.facadesBeanMap == null) {
            this.loadfacadesSet(REGEX_PACAGE_FACADE);
        }
        return this.facadesBeanMap.get(facadefullname);
    }

    public FacadeMethodBean getFacadeMethodBean(String facadefullname, String methodName) throws BOSException {
        FacadeHeadBean facade = this.getFacadeBean(facadefullname);
        List<FacadeMethodBean> methods = facade.getMethods();
        for (FacadeMethodBean method : methods) {
            if (!method.get_name().equals(methodName)) continue;
            return method;
        }
        return null;
    }

    public void reloadfacade() throws BOSException {
        this.facadesBeanMap = null;
        this.facadesPKGMap = null;
        this.facadesModlenameMap = null;
        Map<String, FacadeHeadBean> facadesBeanMapb = this.facadesBeanMap;
        Map<String, List<FacadeHeadBean>> facadesPKGMapb = this.facadesPKGMap;
        Map<String, List<FacadeHeadBean>> facadesModlenameMapb = this.facadesModlenameMap;
        try {
            if (this.swithch) {
                ArrayList<URL> suburls = new ArrayList<URL>();
                suburls.addAll(new PathParser().expandPaths(System.getProperty("EAS_HOME") + "/server/metas/sp//*.jar"));
                suburls.add(new URL("file:" + System.getProperty("EAS_HOME") + "/server/metas/sp/"));
                this.loadfacadesSet(REGEX_PACAGE_FACADE, suburls);
            } else {
                this.loadfacadesSet(REGEX_PACAGE_FACADE);
            }
        }
        catch (Exception e) {
            this.facadesBeanMap = facadesBeanMapb;
            this.facadesPKGMap = facadesPKGMapb;
            this.facadesModlenameMap = facadesModlenameMapb;
            throw new BOSException(e.getMessage());
        }
    }

    private void traverse(String regex, String pack, File dir) throws BOSException {
        pack = pack != null ? pack + "." : "";
        for (File f : dir.listFiles()) {
            String name = f.getName();
            if (f.isDirectory()) {
                this.traverse(regex, pack + name, f);
                continue;
            }
            if (!name.endsWith(".facade") || !name.matches(regex)) continue;
            this.facadesBeanMap.put(name, new XmlFacadeParser().parse(f.getPath()));
        }
    }

    private boolean traverse(String regex, JarEntry entry) {
        String name;
        return !entry.isDirectory() && (name = entry.getName()).endsWith(".facade") && name.matches(regex);
    }

    public static FacadeFileScan getInstance() {
        return instance;
    }

    public List<FacadeHeadBean> getFacadeListByDomainLongNumber(String domainLongNumber) throws BOSException {
        List<FacadeHeadBean> lfhb = this.getFacadeListByModule(domainLongNumber);
        return lfhb;
    }

    public List<FacadeHeadBean> searchAPI(String regex) throws BOSException {
        if (null == regex || "".equals(regex)) {
            return null;
        }
        if (null == this.facadesModlenameMap) {
            this.getFacadePackage();
        }
        ArrayList<FacadeHeadBean> lsmodlename = new ArrayList<FacadeHeadBean>();
        for (String moduleLongNumber : this.facadesModlenameMap.keySet()) {
            for (FacadeHeadBean fhb : this.facadesModlenameMap.get(moduleLongNumber)) {
                String t = new StringBuffer(fhb.get_alias()).append(fhb.get_description()).append(fhb.get_facadename()).toString();
                if (!t.contains(regex)) continue;
                lsmodlename.add(fhb);
            }
        }
        return lsmodlename;
    }

    static {
        instance = null;
        try {
            URL url = new URL("file:" + System.getProperty("EAS_HOME") + "/server/metas/");
            if (null == instance) {
                instance = new FacadeFileScan(url);
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }
}

