/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bsf.facade;

import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.facade.ClientMenuInfo;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class FacadePackMoudleMapping {
    private static final Logger logger = Logger.getLogger(FacadePackMoudleMapping.class);
    private static List<ClientMenuInfo> clientMenuLs = new ArrayList<ClientMenuInfo>();
    private static Map<String, ClientMenuInfo> levelOneMap = new HashMap<String, ClientMenuInfo>();
    private static Map<String, String> numberNameMap = new HashMap<String, String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized List<ClientMenuInfo> getClientMenu(Context ctx) {
        if (clientMenuLs.size() > 0) {
            return clientMenuLs;
        }
        if (ctx != null) {
            Connection conn = null;
            Statement stmt = null;
            ResultSet rs = null;
            try {
                Object cmi;
                conn = EJBFactory.getConnection((Context)ctx);
                stmt = conn.createStatement();
                stmt.setQueryTimeout(1);
                rs = stmt.executeQuery("SELECT fid, fname_l2 fname, flongnumber, fparent, flevel FROM t_pm_mainmenuitem WHERE (fmenutype IS NULL OR fmenutype = 10) AND flevel < 3  ORDER BY flevel ASC,forder ASC;");
                while (rs.next()) {
                    ClientMenuInfo p;
                    cmi = new ClientMenuInfo();
                    ((ClientMenuInfo)cmi).setId(rs.getString("fid"));
                    ((ClientMenuInfo)cmi).setLongNumber(rs.getString("flongnumber"));
                    ((ClientMenuInfo)cmi).setName(rs.getString("fname"));
                    ((ClientMenuInfo)cmi).setLevel(rs.getInt("flevel"));
                    ((ClientMenuInfo)cmi).setParent(rs.getString("fparent"));
                    if (((ClientMenuInfo)cmi).getLevel() == 1) {
                        levelOneMap.put(((ClientMenuInfo)cmi).getId(), (ClientMenuInfo)cmi);
                    } else if (((ClientMenuInfo)cmi).getLevel() == 2 && null != (p = levelOneMap.get(((ClientMenuInfo)cmi).getParent()))) {
                        ((ClientMenuInfo)cmi).setLongName(p.getName() + "." + ((ClientMenuInfo)cmi).getName());
                        numberNameMap.put(((ClientMenuInfo)cmi).getLongNumber(), ((ClientMenuInfo)cmi).getLongName());
                    }
                    clientMenuLs.add((ClientMenuInfo)cmi);
                }
                cmi = clientMenuLs;
                SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
                return cmi;
            }
            catch (Exception e) {
                logger.error((Object)"get openapi module error.", (Throwable)e);
            }
            finally {
                SQLUtils.cleanup(rs, (Statement)stmt, (Connection)conn);
            }
        }
        return null;
    }

    public static String getNameByNumber(String longNumber) {
        return numberNameMap.get(longNumber);
    }
}

