/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bsf.facade;

import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.facade.ClientMenuInfo;
import com.kingdee.bos.bsf.facade.FacadeFileScan;
import com.kingdee.bos.bsf.facade.FacadePackMoudleMapping;
import com.kingdee.bos.bsf.facade.PortalContextUtil;
import com.kingdee.bos.bsf.manage.FacadeHeadBean;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

public class OpenAPIModleTree {
    private final Context ctx;

    public OpenAPIModleTree(HttpServletRequest request) {
        this.ctx = PortalContextUtil.getEasContext(request);
    }

    public String getData() throws Exception {
        List<ClientMenuInfo> fpmm = FacadePackMoudleMapping.getClientMenu(this.ctx);
        ArrayList<TreeInfo> roots = new ArrayList<TreeInfo>();
        HashMap<String, TreeInfo> nodes = new HashMap<String, TreeInfo>();
        for (ClientMenuInfo cmi : fpmm) {
            TreeInfo node = new TreeInfo(cmi.getId());
            String p = cmi.getParent();
            if (nodes.get(p) != null) {
                ((TreeInfo)nodes.get(p)).addChild(node);
            } else {
                roots.add(node);
            }
            node.setName(cmi.getName());
            node.setValue(cmi.getLongNumber());
            nodes.put(node.id, node);
        }
        StringBuilder json = new StringBuilder();
        boolean first = true;
        json.append("[");
        for (TreeInfo n : roots) {
            if (!first) {
                json.append(",");
            } else {
                first = false;
            }
            json.append(this.toJson(n));
        }
        json.append("]");
        return json.toString();
    }

    public String getDataOpenAPINeed() throws Exception {
        List<ClientMenuInfo> fpmm = FacadePackMoudleMapping.getClientMenu(this.ctx);
        ArrayList<TreeInfo> roots = new ArrayList<TreeInfo>();
        HashMap<String, TreeInfo> nodes = new HashMap<String, TreeInfo>();
        for (ClientMenuInfo clientMenuInfo : fpmm) {
            TreeInfo node = new TreeInfo(clientMenuInfo.getId());
            String p = clientMenuInfo.getParent();
            if (nodes.get(p) != null) {
                List<FacadeHeadBean> ls = null;
                ls = FacadeFileScan.getInstance().getFacadeListByDomainLongNumber(clientMenuInfo.getLongNumber());
                if (ls != null && ls.size() > 0) {
                    ((TreeInfo)nodes.get(p)).addChild(node);
                }
            } else {
                roots.add(node);
            }
            node.setName(clientMenuInfo.getName());
            node.setValue(clientMenuInfo.getLongNumber());
            nodes.put(node.id, node);
        }
        ArrayList<TreeInfo> needroots = new ArrayList<TreeInfo>();
        for (TreeInfo t : roots) {
            if (!t.hasChildren()) continue;
            needroots.add(t);
        }
        StringBuilder stringBuilder = new StringBuilder();
        boolean first = true;
        stringBuilder.append("[");
        for (TreeInfo n : needroots) {
            if (!first) {
                stringBuilder.append(",");
            } else {
                first = false;
            }
            stringBuilder.append(this.toJson(n));
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    private Object toJson(TreeInfo node) {
        StringBuffer json = new StringBuffer("{name:'");
        json.append(node.getName());
        json.append("', value:'");
        json.append(node.getValue());
        json.append("'");
        if (node.hasChildren()) {
            json.append(", items:[");
            boolean first = true;
            for (TreeInfo n : node.children()) {
                if (!first) {
                    json.append(",");
                } else {
                    first = false;
                }
                json.append(this.toJson(n));
            }
            json.append("]");
        }
        json.append("}");
        return json;
    }

    static class TreeInfo {
        final String id;
        private List<TreeInfo> children;
        private String name;
        private String value;

        TreeInfo(String id) {
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        boolean hasChildren() {
            return this.children != null;
        }

        public void addChild(TreeInfo child) {
            if (this.children == null) {
                this.children = new ArrayList<TreeInfo>();
            }
            this.children.add(child);
        }

        public List<TreeInfo> children() {
            return this.children;
        }

        public boolean equals(Object obj) {
            return this.id == ((TreeInfo)obj).id;
        }

        public String toString() {
            return this.name;
        }
    }
}

