/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bsf.facade;

import com.kingdee.bos.Context;
import com.kingdee.bos.framework.session.SessionManager;
import java.lang.reflect.Method;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;

public class PortalContextUtil {
    private static Logger logger = Logger.getLogger(PortalContextUtil.class);

    public static Context getEasContext(HttpServletRequest request) {
        HttpSession session = request.getSession();
        Context ctx = (Context)session.getAttribute("pureWebContext");
        if (ctx != null) {
            return ctx;
        }
        return PortalContextUtil.getRealEasContext(request);
    }

    private static Context getRealEasContext(HttpServletRequest request) {
        HttpSession session = request.getSession();
        Object webContext = session.getAttribute("easWebContextSessionId");
        Context ctx = null;
        if (webContext != null) {
            Object re = PortalContextUtil.dynCallFunction(webContext, "getSessionId", null);
            if (re != null) {
                String sessionID = re.toString();
                try {
                    ctx = SessionManager.getInstance().getSession(sessionID).getContext();
                }
                catch (Exception e) {
                    logger.error((Object)("[Eas portal]get eas user server context fails. context is null." + e.getMessage()));
                }
            }
        } else {
            logger.error((Object)"[Eas portal]webContext is null.");
        }
        return ctx;
    }

    public static String getContextPath(HttpServletRequest request) {
        String contextPath = request.getContextPath();
        if (contextPath == null || contextPath.equals("/")) {
            contextPath = "";
        }
        return contextPath;
    }

    private static Object dynCallFunction(Object destObj, String funcName, Object[] args) {
        if (destObj == null || funcName == null) {
            return null;
        }
        Method method = null;
        try {
            Class[] paramType = null;
            if (args != null && args.length > 0) {
                int max = args.length;
                paramType = new Class[max];
                for (int i = 0; i < max; ++i) {
                    paramType[i] = args[i].getClass();
                }
            }
            if ((method = PortalContextUtil.getDynObjectFunction(destObj, funcName, paramType)) != null) {
                return method.invoke(destObj, args);
            }
        }
        catch (Exception e) {
            logger.error((Object)("DynCall function error! function=" + funcName + ", args=" + args + ", object=" + destObj), (Throwable)e);
        }
        return null;
    }

    private static Method getDynObjectFunction(Object destObj, String funcName, Class<?>[] paramsType) {
        if (destObj == null || funcName == null) {
            return null;
        }
        Method method = null;
        try {
            method = paramsType != null && paramsType.length > 0 ? destObj.getClass().getMethod(funcName, paramsType) : destObj.getClass().getMethod(funcName, null);
            return method;
        }
        catch (Throwable e) {
            logger.error((Object)("The function [" + funcName + "] is not exist!  object=" + destObj), e);
            return null;
        }
    }
}

