/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bsf.facade;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.bsf.facade.DescriptionPrase;
import com.kingdee.bos.bsf.manage.FacadeHeadBean;
import com.kingdee.bos.bsf.manage.FacadeMethodBean;
import com.kingdee.bos.bsf.manage.FdMethodExceptionBean;
import com.kingdee.bos.bsf.manage.FdMethodParameterBean;
import com.kingdee.bos.bsf.parsing.XmlFileReader;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jdom2.Attribute;
import org.jdom2.Element;

public class XmlFacadeParser {
    static final String METHODS = "methods";
    static final String METHOD = "method";
    static final String RESOURCE = "resource";
    static final String DESCRIPTION = "description";
    static final String NAME = "name";
    static final String ALIAS = "alias";
    static final String PACKAGE = "package";
    static final String USERDEFINED = "userDefined";
    static final String BUSINESSIMPLNAME = "businessImplName";
    static final String PARAMETERS = "parameters";
    static final String PARAMETER = "parameter";
    static final String EXCEPTIONS = "exceptions";
    static final String EXCEPTION = "exception";
    static final String DATATYPE = "dataType";
    static String locate = "zh_CN";
    public static final String MENUMODLE = "menumodle";
    public static final String RETURNDESC = "returndesc";
    public static final String INVOKEDEMO = "invokedemo";
    private Map<String, String> resourceMap = new HashMap<String, String>();

    public FacadeHeadBean parse(String path) throws BOSException {
        XmlFileReader reader = new XmlFileReader();
        Element root = reader.read(path);
        return this.doParse(root);
    }

    public FacadeHeadBean parse(InputStream is) throws BOSException {
        XmlFileReader reader = new XmlFileReader();
        Element root = reader.read(is);
        return this.doParse(root);
    }

    private FacadeHeadBean doParse(Element root) {
        FacadeHeadBean facade = new FacadeHeadBean();
        Iterator iter = root.getChildren().iterator();
        for (Object e : root.getChildren()) {
            if (!RESOURCE.equals(((Element)e).getName())) continue;
            this.parseResource((Element)e);
        }
        while (iter.hasNext()) {
            Element element = (Element)iter.next();
            String name = element.getName();
            if (METHODS.equals(name)) {
                this.parseMethods(element, facade);
                continue;
            }
            if (DESCRIPTION.equals(name)) {
                Map<String, String> map = DescriptionPrase.praseDescription(this.resourceMap.get(element.getText()));
                if (map.get(DESCRIPTION) == null) {
                    facade.set_description(this.resourceMap.get(element.getText()));
                    continue;
                }
                facade.set_description(this.praseDesc(map.get(DESCRIPTION)));
                facade.set_menuModle(map.get(MENUMODLE));
                continue;
            }
            if (NAME.equals(name)) {
                facade.set_facadename(element.getText());
                continue;
            }
            if (ALIAS.equals(name)) {
                facade.set_alias(this.resourceMap.get(element.getText()));
                continue;
            }
            if (PACKAGE.equals(name)) {
                facade.set_package(element.getText());
                continue;
            }
            if (USERDEFINED.equals(name)) {
                facade.set_userDefined(element.getText());
                continue;
            }
            if (!BUSINESSIMPLNAME.equals(name)) continue;
            facade.set_businessImplName(element.getText());
        }
        this.resourceMap.clear();
        return facade;
    }

    private void parseResource(Element root) {
        for (Element element : root.getChildren()) {
            String name = element.getName();
            if (!"rs".equals(name)) continue;
            String key = element.getAttribute("key").getValue();
            for (Element langelement : element.getChildren()) {
                if (!locate.equals(langelement.getAttribute("locale").getValue())) continue;
                this.resourceMap.put(key, langelement.getAttribute("value").getValue());
            }
        }
    }

    private void parseMethods(Element root, FacadeHeadBean facade) {
        for (Element element : root.getChildren()) {
            String name = element.getName();
            if (!METHOD.equals(name)) continue;
            this.parseMethod(element, facade);
        }
    }

    private void parseMethod(Element root, FacadeHeadBean facade) {
        FacadeMethodBean method = new FacadeMethodBean(facade);
        for (Element element : root.getChildren()) {
            String name = element.getName();
            if (PARAMETERS.equals(name)) {
                this.parseParameters(element, method);
                continue;
            }
            if (EXCEPTIONS.equals(name)) {
                this.parseExceptions(element, method);
                continue;
            }
            if (NAME.equals(name)) {
                method.set_name(element.getText());
                continue;
            }
            if (DESCRIPTION.equals(name)) {
                Map<String, String> map = DescriptionPrase.praseDescription(this.resourceMap.get(element.getText()));
                if (map.get(DESCRIPTION) == null) {
                    method.set_description(this.resourceMap.get(element.getText()));
                    continue;
                }
                String invokeDemo = map.get(INVOKEDEMO);
                method.set_description(this.praseDesc(map.get(DESCRIPTION)));
                method.set_invokeDemo(this.praseDesc(invokeDemo));
                method.set_returnDesc(this.praseDesc(map.get(RETURNDESC)));
                continue;
            }
            if (!"returnValueType".equals(name)) continue;
            method.set_returnValueType(element.getText());
        }
        facade.getMethods().add(method);
    }

    private String praseDesc(String str) {
        StringBuffer sb = new StringBuffer();
        if (str != null) {
            char[] indo;
            for (char c : indo = str.replace("{BR}", "\r").toCharArray()) {
                if (c == ' ') {
                    sb.append("&nbsp");
                    continue;
                }
                if (c == '\n' || c == '\r') {
                    sb.append("<br>");
                    continue;
                }
                if (c == '\t') {
                    sb.append("&emsp;");
                    continue;
                }
                sb.append(c);
            }
        }
        return sb.toString();
    }

    private void parseParameters(Element root, FacadeMethodBean method) {
        for (Element element : root.getChildren()) {
            String name = element.getName();
            if (!PARAMETER.equals(name)) continue;
            this.parseParameter(element, method);
        }
    }

    private void parseParameter(Element root, FacadeMethodBean method) {
        FdMethodParameterBean parameter = new FdMethodParameterBean();
        for (Element element : root.getChildren()) {
            String name = element.getName();
            if (NAME.equals(name)) {
                parameter.set_name(element.getText());
                continue;
            }
            if (DESCRIPTION.equals(name)) {
                parameter.set_description(this.praseDesc(this.resourceMap.get(element.getText())));
                continue;
            }
            if (!DATATYPE.equals(name)) continue;
            parameter.set_datatype(element.getText());
        }
        method.getParameters().add(parameter);
    }

    private void parseExceptions(Element root, FacadeMethodBean method) {
        for (Element element : root.getChildren()) {
            String name = element.getName();
            if (EXCEPTION.equals(name)) {
                this.parseBizException(element, method);
                continue;
            }
            if (!"bizException".equals(name)) continue;
            this.parseBizException(element, method);
        }
    }

    private void parseBizException(Element root, FacadeMethodBean method) {
        FdMethodExceptionBean exception = new FdMethodExceptionBean();
        for (Element element : root.getChildren()) {
            String name = element.getName();
            if (!"key".equals(name)) continue;
            Attribute ab = element.getAttribute(NAME);
            if (PACKAGE.equals(ab.getValue())) {
                exception.set_package(element.getAttribute("value").getValue());
            }
            if (!NAME.equals(ab.getValue())) continue;
            exception.set_name(element.getAttribute("value").getValue());
        }
        method.getExceptions().add(exception);
    }
}

