/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bsf.manage;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.asm.Type;
import com.kingdee.bos.bsf.manage.CompositeDesc;
import com.kingdee.bos.bsf.manage.TypeAdapter;
import com.kingdee.bos.bsf.type.TypeUtils;
import com.kingdee.bos.json.JSONUtils;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.util.enums.Enum;
import com.kingdee.util.enums.EnumUtils;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;

abstract class AbstractTypeAdapter
implements TypeAdapter {
    protected final Context ctx;
    protected final CompositeDesc composite;
    static Object OBJECT = new Object();
    static String STRING = "s";
    static StringBuffer STRINGBUFFER = new StringBuffer("sb");

    AbstractTypeAdapter(Context ctx, CompositeDesc composite) {
        this.ctx = ctx;
        this.composite = composite;
    }

    protected String convert2Json(Object obj, StringBuffer append) throws BOSException {
        String json = JSONUtils.convertObjectToJson((Context)this.ctx, (Object)obj);
        json = json.replaceAll("\\[\\]", "null");
        json = json.replaceAll(",?\"\\w+\":\\s*null", "");
        if (append != null && append.length() > 0) {
            int last = json.lastIndexOf("}");
            json = json.indexOf(":") > 0 ? json.substring(0, last) + "," + append + json.substring(last) : json.substring(0, last) + append + json.substring(last);
        }
        return json;
    }

    protected Object getDefaultValue(String typeDesc) throws BOSException {
        Type t = Type.getType((String)typeDesc);
        switch (t.getSort()) {
            case 1: {
                return true;
            }
            case 3: {
                return 1;
            }
            case 2: {
                return Character.valueOf('a');
            }
            case 4: {
                return 1;
            }
            case 5: {
                return 1;
            }
            case 6: {
                return 1.0;
            }
            case 8: {
                return 1.0;
            }
            case 7: {
                return 1;
            }
            case 0: 
            case 9: {
                return null;
            }
            case 10: {
                if (Type.getDescriptor(String.class).equals(typeDesc)) {
                    return STRING;
                }
                if (Type.getDescriptor(Object.class).equals(typeDesc)) {
                    return OBJECT;
                }
                if (Type.getDescriptor(StringBuffer.class).equals(typeDesc)) {
                    return STRINGBUFFER;
                }
                if (Type.getDescriptor(Integer.class).equals(typeDesc)) {
                    return 1;
                }
                if (Type.getDescriptor(Boolean.class).equals(typeDesc)) {
                    return Boolean.TRUE;
                }
                if (Type.getDescriptor(Byte.class).equals(typeDesc)) {
                    return (byte)0;
                }
                if (Type.getDescriptor(Short.class).equals(typeDesc)) {
                    return (short)1;
                }
                if (Type.getDescriptor(Long.class).equals(typeDesc)) {
                    return 1L;
                }
                if (Type.getDescriptor(Double.class).equals(typeDesc)) {
                    return 1.0;
                }
                if (Type.getDescriptor(Float.class).equals(typeDesc)) {
                    return Float.valueOf(1.0f);
                }
                if (Type.getDescriptor(BOSUuid.class).equals(typeDesc)) {
                    return BOSUuid.read((String)"qzkAAAABB5TVUrTQ");
                }
                if (Type.getDescriptor(Enum.class).equals(typeDesc)) {
                    List enums = EnumUtils.getEnumList(TypeUtils.getClass(this.composite.toComposite(), typeDesc));
                    if (enums == null || enums.size() <= 0) break;
                    return enums.get(0);
                }
                if (Type.getDescriptor(Date.class).equals(typeDesc)) {
                    return new Date();
                }
                if (Type.getDescriptor(Time.class).equals(typeDesc)) {
                    return new Time(System.currentTimeMillis());
                }
                if (!Type.getDescriptor(Timestamp.class).equals(typeDesc)) break;
                return new Timestamp(System.currentTimeMillis());
            }
        }
        return new Ref(typeDesc);
    }

    protected static class Ref {
        final String value;

        Ref(String name) {
            this.value = "$" + name + "$";
        }

        public String toString() {
            return this.value;
        }
    }
}

