/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bsf.manage;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.bsf.deploy.BSFDeployer;
import com.kingdee.bos.bsf.deploy.BSFDeployerFactory;
import com.kingdee.bos.bsf.deploy.ClusterManager;
import com.kingdee.bos.bsf.deploy.FileUtils;
import com.kingdee.bos.bsf.manage.IBSFAdmin;
import com.kingdee.bos.bsf.service.Configuration;
import com.kingdee.bos.orm.template.ORMObject;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;

public class BSFAdmin
extends ORMObject
implements IBSFAdmin {
    public BSFAdmin() {
        this.registerInterface(IBSFAdmin.class, this);
    }

    @Override
    public void install(final String[] packs) throws BOSException {
        if (packs == null || packs.length == 0) {
            ClusterManager.INSTANCE.install();
            return;
        }
        final String[] md52 = BSFDeployerFactory.getLocalInstance().check(packs, null, null);
        this.schedule(new Work(){

            @Override
            public void execute(String url) throws BOSException {
                BSFDeployerFactory.getRemoteInstance(url).check(packs, md52, ClusterManager.getLocalHost());
            }
        });
        BSFDeployerFactory.getLocalInstance().install(packs);
        this.schedule(new Work(){

            @Override
            public void execute(String url) throws BOSException {
                BSFDeployerFactory.getRemoteInstance(url).install(packs);
            }
        });
        ClusterManager.INSTANCE.install();
    }

    @Override
    public boolean install(File zipFile, String md52) throws BOSException {
        if (zipFile == null || md52 == null) {
            return false;
        }
        String[] hosts = this.getHosts();
        if (hosts.length > 1) {
            return false;
        }
        if (zipFile.exists() && md52.equals(FileUtils.md5(zipFile))) {
            BSFDeployer.getInstance().install(zipFile);
            ClusterManager.INSTANCE.install();
            return true;
        }
        return false;
    }

    @Override
    public void uninstall(final String module, final String version) throws BOSException {
        ClusterManager.INSTANCE.uninstall(module, version);
        BSFDeployerFactory.getLocalInstance().uninstall(module, version);
        this.schedule(new Work(){

            @Override
            public void execute(String url) throws BOSException {
                BSFDeployerFactory.getRemoteInstance(url).uninstall(module, version);
            }
        });
    }

    @Override
    public void enable(final String module, final String version) throws BOSException {
        BSFDeployerFactory.getLocalInstance().enable(module, version);
        this.schedule(new Work(){

            @Override
            public void execute(String url) throws BOSException {
                BSFDeployerFactory.getRemoteInstance(url).enable(module, version);
            }
        });
        ClusterManager.INSTANCE.enable(module, version);
    }

    @Override
    public void disable(final String module, final String version) throws BOSException {
        BSFDeployerFactory.getLocalInstance().disable(module, version);
        this.schedule(new Work(){

            @Override
            public void execute(String url) throws BOSException {
                BSFDeployerFactory.getRemoteInstance(url).disable(module, version);
            }
        });
        ClusterManager.INSTANCE.disable(module, version);
    }

    @Override
    public String[] listPacks() throws BOSException {
        File repo = Configuration.getRepositoryDir();
        if (repo.exists()) {
            File[] files;
            ArrayList<String> packs = new ArrayList<String>();
            for (File f : files = repo.listFiles()) {
                if (!f.isFile()) continue;
                packs.add(f.getName());
            }
            return packs.toArray(new String[0]);
        }
        return new String[0];
    }

    @Override
    public String pullModule(final String module, final String version) throws BOSException {
        String fileName = BSFDeployerFactory.getLocalInstance().pullModule(module, version);
        this.schedule(new Work(){

            @Override
            public void execute(String url) throws BOSException {
                BSFDeployerFactory.getRemoteInstance(url).pullModule(module, version);
            }
        });
        return fileName;
    }

    void schedule(Work w) throws BOSException {
        String[] hosts = this.getHosts();
        if (hosts.length > 1) {
            String[] urls;
            HashSet<String> accessed = new HashSet<String>();
            for (String url : urls = ClusterManager.getUrls(true, true)) {
                String host = ClusterManager.getHost(url);
                if (accessed.contains(host)) continue;
                w.execute(url);
                accessed.add(host);
            }
        }
    }

    @Override
    public String[] getHosts() throws BOSException {
        return ClusterManager.getHosts();
    }

    static interface Work {
        public void execute(String var1) throws BOSException;
    }
}

