/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bsf.manage;

import com.kingdee.bos.bsf.Composite;
import java.io.Serializable;

public class CompositeDesc
implements Serializable,
Comparable<CompositeDesc> {
    private static final long serialVersionUID = -2659147220080589488L;
    private final String module;
    private final String version;
    private int state;
    private String alias;
    private String description;
    private boolean isFacade = false;

    public CompositeDesc(String module, String version) {
        this.module = module;
        this.version = version;
    }

    public boolean isFacade() {
        return this.isFacade;
    }

    public void setFacade(boolean isFacade) {
        this.isFacade = isFacade;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getModule() {
        return this.module;
    }

    public String getVersion() {
        return this.version;
    }

    public String toString() {
        return this.module + "/" + this.version;
    }

    @Override
    public int compareTo(CompositeDesc o) {
        int v = this.module.compareTo(o.module);
        if (v == 0) {
            int[] vs = this.getVersion(this.version);
            int[] ovs = this.getVersion(o.version);
            for (int i = 0; i < vs.length && v == 0; ++i) {
                v = this.compare(vs[i], ovs[i]);
            }
        }
        return v;
    }

    int compare(int a, int b) {
        if (a == b) {
            return 0;
        }
        if (a > b) {
            return 1;
        }
        return -1;
    }

    int[] getVersion(String version) {
        String[] numbers = version.replaceAll("([0]+)([1-9])", "$2").split("\\.");
        int major = 0;
        int minor = 0;
        int revision = 0;
        int build = 0;
        if (numbers.length > 0) {
            major = this.convert2Int(numbers[0]);
        }
        if (numbers.length > 1) {
            minor = this.convert2Int(numbers[1]);
        }
        if (numbers.length > 2) {
            revision = this.convert2Int(numbers[2]);
        }
        if (numbers.length > 3) {
            build = this.convert2Int(numbers[3]);
        }
        return new int[]{major, minor, revision, build};
    }

    private int convert2Int(String s) {
        if (s == null) {
            return 0;
        }
        try {
            return Integer.valueOf(s);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public int getState() {
        return this.state;
    }

    public void setState(int state) {
        this.state = state;
    }

    public Composite toComposite() {
        return Composite.getInstance(this.module, this.version);
    }
}

