/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bsf.manage;

import com.kingdee.util.StringUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import org.apache.log4j.Logger;

public class Console
implements Runnable {
    private static final Logger logger = Logger.getLogger(Console.class);
    private static final int PORT = 10090;
    private static Console console = null;
    private ServerSocket server;

    public static void start() {
        if (console == null) {
            console = new Console();
            Thread t = new Thread((Runnable)console, "console Server");
            t.setDaemon(true);
            t.start();
        }
    }

    public static void stop() {
        if (console != null) {
            console.close();
        }
    }

    private Console() {
        ServerSocket ss = null;
        int port = 10090;
        while (ss == null && port <= 10093) {
            try {
                ss = new ServerSocket(port);
            }
            catch (Throwable e) {
                ss = null;
                logger.error((Object)("Script Server start error. port:" + port), e);
                ++port;
            }
        }
        this.server = ss;
    }

    private void close() {
        if (this.server != null) {
            try {
                this.server.close();
            }
            catch (IOException e) {
                logger.error((Object)"Script Server close error.", (Throwable)e);
            }
            this.server = null;
        }
    }

    @Override
    public void run() {
        while (this.server != null) {
            try {
                new Thread(new Worker(this.server.accept())).start();
            }
            catch (IOException e) {
                logger.error((Object)"Script Server service failed.", (Throwable)e);
                try {
                    this.server.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.server = null;
                break;
            }
        }
    }

    public static void reload(String module) {
    }

    private static class Worker
    implements Runnable {
        private final Socket client;
        private final PrintWriter out;
        private final BufferedReader in;

        private Worker(Socket client) throws IOException {
            this.client = client;
            this.out = new PrintWriter(client.getOutputStream(), false);
            this.out.print("eas->");
            this.out.flush();
            this.in = new BufferedReader(new InputStreamReader(client.getInputStream()));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                StringBuffer buffer = null;
                while (true) {
                    String input;
                    try {
                        input = this.in.readLine();
                    }
                    catch (IOException e) {
                        this.out.println("Read Script Error and will exit.");
                        this.out.flush();
                        break;
                    }
                    if (input == null) continue;
                    if ("quit".equals(input)) {
                        break;
                    }
                    if ("begin".equals(input)) {
                        buffer = new StringBuffer();
                        this.out.print(">");
                        this.out.flush();
                        continue;
                    }
                    if ("end".equals(input) && buffer != null) {
                        input = buffer.toString();
                        buffer = null;
                    }
                    if (buffer != null) {
                        buffer.append(input);
                        buffer.append("\n");
                        this.out.print(">");
                        this.out.flush();
                        continue;
                    }
                    try {
                        Object result = this.eval(input);
                        this.out.println(result);
                        this.out.print("eas->");
                        this.out.flush();
                    }
                    catch (Exception ex) {
                        this.out.println("Error. " + ex.getMessage());
                        this.out.println(StringUtils.stackToString((Exception)ex));
                        this.out.println("Script:");
                        this.out.println(input);
                        this.out.print("eas->");
                        this.out.flush();
                    }
                }
            }
            finally {
                this.close();
            }
        }

        private Object eval(String script) {
            Console.reload(script);
            return null;
        }

        public void close() {
            try {
                this.in.close();
            }
            catch (IOException e) {
                logger.error((Object)"Script Server close error.", (Throwable)e);
            }
            finally {
                this.out.close();
                try {
                    this.client.close();
                }
                catch (IOException e) {
                    logger.error((Object)"Script Server close error.", (Throwable)e);
                }
            }
        }
    }
}

