/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bsf.manage;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.bsf.Composite;
import com.kingdee.bos.bsf.Domain;
import com.kingdee.bos.bsf.ServiceRegistry;
import com.kingdee.bos.bsf.ServiceRepositoryFactory;
import com.kingdee.bos.bsf.deploy.FileUtils;
import com.kingdee.bos.bsf.manage.IndexFiles;
import com.kingdee.bos.bsf.manage.ServiceViewException;
import com.kingdee.bos.bsf.parsing.ComponentMetadata;
import com.kingdee.bos.bsf.parsing.ComponentParser;
import com.kingdee.bos.bsf.parsing.OperationMetadata;
import com.kingdee.bos.bsf.parsing.POJOMetadata;
import com.kingdee.bos.bsf.parsing.POJOParser;
import com.kingdee.bos.bsf.parsing.ParamMetadata;
import com.kingdee.bos.bsf.parsing.Properties;
import com.kingdee.bos.bsf.parsing.ServiceMetadata;
import com.kingdee.bos.bsf.service.Configuration;
import com.kingdee.bos.bsf.service.IServiceRepositoryLoader;
import com.kingdee.bos.json.Kson;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

class DocumentManager {
    private static final Logger logger = Logger.getLogger(DocumentManager.class);
    static final String KEY = "key";
    static final String ALIAS = "alias";
    static final String INTERFACE = "interface";
    static final String DESCRIPTION = "description";
    static final String RETURN_TYPE = "returnType";
    static final String TYPE = "type";
    private static final String TYPES = "$types";
    static final String INDEXES = "$indexes";
    static final String DATA_FILE = ".data";

    public static DocumentManager getInstance() {
        return new DocumentManager();
    }

    private DocumentManager() {
    }

    public static String getUri(String composite, String service, String operation, String param) {
        String uri = composite;
        uri = service == null ? uri : uri + "/" + service;
        uri = operation == null ? uri : uri + "/" + operation;
        uri = param == null ? uri : uri + "/" + param;
        return uri;
    }

    public String[] listKeys(String uri) throws BOSException {
        File f = uri == null ? Configuration.getDocumentDir() : new File(Configuration.getDocumentDir(), uri);
        if (!f.exists()) {
            throw new ServiceViewException("Document not exists. Refresh document and try again. uri:" + uri);
        }
        File[] subs = f.listFiles();
        ArrayList<String> keys = new ArrayList<String>(subs.length);
        for (File s : subs) {
            if (!s.isDirectory() || s.getName().charAt(0) == '$') continue;
            keys.add(s.getName());
        }
        return keys.toArray(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties getDoc(String uri) throws BOSException {
        if (uri == null) {
            return null;
        }
        File f = new File(Configuration.getDocumentDir(), uri + "/" + DATA_FILE);
        Properties data = new Properties();
        Reader input = null;
        try {
            try {
                input = new InputStreamReader((InputStream)new FileInputStream(f), "UTF-8");
                data.load(input);
            }
            finally {
                if (input != null) {
                    input.close();
                }
            }
        }
        catch (Exception e) {
            throw new ServiceViewException("get document error. uri:" + uri, e);
        }
        return data;
    }

    void genDoc() throws BOSException {
        FileUtils.clear(Configuration.getDocumentDir());
        Domain.getInstance(Composite.OLD_BSF);
        Composite[] composites = Domain.utility.getUtility(IServiceRepositoryLoader.class).getComposites();
        boolean error = false;
        StringBuffer msg = new StringBuffer();
        for (Composite c : composites) {
            if (c.isInner()) continue;
            try {
                this.genDoc(c);
            }
            catch (Exception e) {
                error = true;
                msg.append(c);
                msg.append(";");
                logger.error((Object)("gen doc error. module:" + c), (Throwable)e);
            }
        }
        new IndexFiles(new File(Configuration.getDocumentDir(), INDEXES), Configuration.getDocumentDir()).index();
        if (error) {
            throw new ServiceViewException("gen doc error, check server log for detail. modules:" + msg);
        }
    }

    void genDoc(Composite composite) throws BOSException {
        List<ServiceRegistry> registries = Domain.utility.getUtility(ServiceRepositoryFactory.class).getInstance(composite).getServiceRegistries();
        URL home = Domain.utility.getUtility(ServiceRepositoryFactory.class).getInstance(composite).getHome();
        String key = composite.toString().replace('/', '-');
        Properties data = new Properties();
        data.put(KEY, key);
        if (composite.getAlias() != null) {
            data.put(ALIAS, composite.getAlias());
        }
        if (composite.getDescription() != null) {
            data.put(DESCRIPTION, composite.getDescription());
        }
        File module = this.mkDir(new File(Configuration.getDocumentDir(), key), data);
        ComponentParser parser = new ComponentParser(home);
        block0: for (ServiceRegistry r : registries) {
            ComponentMetadata component = parser.parse(r.getClassName(), true);
            for (ServiceMetadata s : component.listService()) {
                if (!r.getName().equals(s.getName()) && (!r.getName().endsWith(s.getName()) || r.getName().indexOf(component.getName() + "$") != 0)) continue;
                data = new Properties();
                data.put(KEY, r.getName());
                data.put(INTERFACE, r.getInterfaceName());
                data.put(DESCRIPTION, s.getDescription() + (component.getDescription() == null ? "" : "\r\n<br>\r\n" + component.getDescription()));
                File service = this.mkDir(new File(module, r.getName()), data);
                for (OperationMetadata o : s.listOperation()) {
                    data = new Properties();
                    data.put(KEY, o.getName());
                    data.put(RETURN_TYPE, o.getReturnType());
                    if (o.getDescription() != null) {
                        data.put(DESCRIPTION, o.getDescription());
                    }
                    File operation = this.mkDir(new File(service, o.getName()), data);
                    for (ParamMetadata p : o.listParam()) {
                        data = new Properties();
                        data.put(TYPE, p.getSignature());
                        if (p.getDescription() != null) {
                            data.put(DESCRIPTION, p.getDescription());
                        }
                        this.mkDir(new File(operation, p.getName()), data);
                    }
                }
                continue block0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File mkDir(File dir, Properties data) throws BOSException {
        if (!dir.exists()) {
            dir.mkdir();
        }
        try {
            File desc = new File(dir, DATA_FILE);
            try (Writer out = null;){
                out = new OutputStreamWriter((OutputStream)new FileOutputStream(desc), "UTF-8");
                data.store(out, null);
            }
        }
        catch (Exception e) {
            throw new ServiceViewException("create document error. dir:" + dir.getName(), e);
        }
        return dir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public POJOMetadata getPOJOMetadata(Composite composite, String type) throws BOSException {
        File types = new File(Configuration.getDocumentDir(), composite.toString().replace('/', '-') + "/" + TYPES);
        if (!types.exists()) {
            types.mkdirs();
        }
        File t = new File(types, type);
        String json = null;
        if (t.exists()) {
            FilterInputStream input = null;
            try {
                try {
                    input = new DataInputStream(new FileInputStream(t));
                    json = ((DataInputStream)input).readUTF();
                }
                finally {
                    if (input != null) {
                        input.close();
                    }
                }
            }
            catch (Exception e) {
                throw new ServiceViewException("get type error. uri:" + type, e);
            }
            return (POJOMetadata)Kson.getGson().fromJson(json, POJOMetadata.class);
        }
        URL home = Domain.utility.getUtility(ServiceRepositoryFactory.class).getInstance(composite).getHome();
        POJOParser parser = new POJOParser(home);
        POJOMetadata pojo = parser.parse(type);
        try (FilterOutputStream out = null;){
            out = new DataOutputStream(new FileOutputStream(t));
            ((DataOutputStream)out).writeUTF(Kson.getGson().toJson((Object)pojo));
        }
        catch (Exception e) {
            throw new ServiceViewException("get type error. uri:" + type, e);
        }
        return pojo;
    }
}

