/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bsf.manage;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.manage.AbstractTypeAdapter;
import com.kingdee.bos.bsf.manage.CompositeDesc;
import com.kingdee.bos.bsf.manage.TypeDesc;
import com.kingdee.bos.bsf.type.TypeUtils;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.resource.BizEnumInfo;
import com.kingdee.bos.metadata.resource.BizEnumValueCollection;
import com.kingdee.util.enums.Enum;
import com.kingdee.util.enums.EnumUtils;
import com.kingdee.util.enums.IntEnum;
import com.kingdee.util.enums.StringEnum;

class EnumTypeAdapter
extends AbstractTypeAdapter {
    EnumTypeAdapter(Context ctx, CompositeDesc composite) {
        super(ctx, composite);
    }

    @Override
    public TypeDesc get(String typeDesc) throws BOSException {
        Class<?> clazz = TypeUtils.getClass(this.composite.toComposite(), typeDesc);
        TypeDesc type = new TypeDesc(typeDesc);
        BizEnumInfo bizEnum = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)this.ctx).getEnum((IMetaDataPK)MetaDataPK.create((String)TypeUtils.getClassName(typeDesc)));
        StringBuffer desc = new StringBuffer();
        if (bizEnum != null && bizEnum.getAlias() != null) {
            desc.append(bizEnum.getAlias());
            desc.append("\n");
            BizEnumValueCollection enumCol = bizEnum.getEnumValue();
            int n = enumCol.size();
            for (int j = 0; j < n; ++j) {
                desc.append(enumCol.get(j).getValue());
                desc.append(" - ");
                desc.append(enumCol.get(j).getAlias());
                desc.append("\n");
            }
        } else {
            for (Object e : EnumUtils.getEnumList(clazz)) {
                desc.append(((Enum)e).getName());
                desc.append(" - ");
                desc.append(((Enum)e).getAlias());
                desc.append("\n");
            }
        }
        String json = null;
        if (IntEnum.class.isAssignableFrom(TypeUtils.getClass(this.composite.toComposite(), typeDesc))) {
            IntEnum e = (IntEnum)EnumUtils.getEnumList(clazz).get(0);
            json = String.valueOf(e.getValue());
        } else if (StringEnum.class.isAssignableFrom(clazz)) {
            StringEnum e = (StringEnum)EnumUtils.getEnumList(clazz).get(0);
            json = e.getValue();
        }
        type.setDescription(desc.toString());
        type.setJson(json);
        return type;
    }
}

