/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bsf.manage;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.bsf.deploy.FileUtils;
import com.kingdee.bos.bsf.manage.ServiceViewException;
import com.kingdee.bos.bsf.parsing.Properties;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Date;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.lucene.ep.analysis.Analyzer;
import org.apache.lucene.ep.analysis.standard.StandardAnalyzer;
import org.apache.lucene.ep.document.Document;
import org.apache.lucene.ep.document.Field;
import org.apache.lucene.ep.document.Fieldable;
import org.apache.lucene.ep.index.IndexWriter;
import org.apache.lucene.ep.store.Directory;
import org.apache.lucene.ep.store.FSDirectory;
import org.apache.lucene.ep.util.Version;

class IndexFiles {
    private static final Logger logger = Logger.getLogger(IndexFiles.class);
    private final File indexDir;
    private final File docDir;

    IndexFiles(File indexDir, File docDir) {
        this.indexDir = indexDir;
        this.docDir = docDir;
    }

    public void index() throws BOSException {
        if (this.indexDir.exists()) {
            FileUtils.delete(this.indexDir);
        }
        if (!this.docDir.exists() || !this.docDir.canRead()) {
            logger.info((Object)("Document directory '" + this.docDir.getAbsolutePath() + "' does not exist or is not readable, please check the path"));
            System.exit(1);
        }
        Date start = new Date();
        IndexWriter writer = null;
        try {
            try {
                writer = new IndexWriter((Directory)FSDirectory.open((File)this.indexDir), (Analyzer)new StandardAnalyzer(Version.LUCENE_29), true, IndexWriter.MaxFieldLength.LIMITED);
                logger.info((Object)("Indexing to directory '" + this.indexDir + "'..."));
                this.indexDoc(writer, this.docDir);
                logger.info((Object)"Optimizing...");
                writer.optimize();
            }
            finally {
                if (writer != null) {
                    writer.close();
                }
            }
        }
        catch (Exception e) {
            throw new ServiceViewException("index document error. path:" + this.docDir.getAbsolutePath(), e);
        }
        Date end = new Date();
        logger.info((Object)(end.getTime() - start.getTime() + " total milliseconds"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void indexDoc(IndexWriter writer, File dir) throws Exception {
        if (!dir.canRead()) {
            return;
        }
        if (dir.isDirectory() && dir.canRead() && dir.getName().charAt(0) != '$') {
            File df;
            File[] files = dir.listFiles();
            if (files != null) {
                for (File f : files) {
                    this.indexDoc(writer, f);
                }
            }
            if ((df = new File(dir, ".data")).exists()) {
                Properties data = new Properties();
                try (Reader input = null;){
                    input = new InputStreamReader((InputStream)new FileInputStream(df), "UTF-8");
                    data.load(input);
                }
                this.indexData(writer, this.getURI(dir), data);
            }
        }
    }

    private String getURI(File dir) {
        return dir.getAbsolutePath().substring(this.docDir.getAbsolutePath().length() + 1).replace('\\', '/');
    }

    private void indexData(IndexWriter writer, String uri, Properties data) throws Exception {
        Document doc = new Document();
        Field pathField = new Field("uri", uri, Field.Store.YES, Field.Index.NOT_ANALYZED);
        doc.add((Fieldable)pathField);
        for (Map.Entry entry : data.entrySet()) {
            doc.add((Fieldable)new Field((String)entry.getKey(), (String)entry.getValue(), Field.Store.YES, Field.Index.ANALYZED));
        }
        writer.addDocument(doc);
    }
}

