/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bsf.manage;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.asm.Type;
import com.kingdee.bos.bsf.manage.AbstractTypeAdapter;
import com.kingdee.bos.bsf.manage.CompositeDesc;
import com.kingdee.bos.bsf.manage.FieldDesc;
import com.kingdee.bos.bsf.manage.TypeDesc;
import com.kingdee.bos.bsf.manage.TypeRef;
import com.kingdee.bos.bsf.type.TypeUtils;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.MDHostType;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.resource.BizEnumInfo;
import com.kingdee.bos.metadata.resource.BizEnumValueCollection;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.Uuid;
import com.kingdee.util.enums.Enum;
import java.math.BigDecimal;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;

class ObjectValueTypeAdapter
extends AbstractTypeAdapter {
    ObjectValueTypeAdapter(Context ctx, CompositeDesc composite) {
        super(ctx, composite);
    }

    @Override
    public TypeDesc get(String typeDesc) throws BOSException {
        IObjectValue instance = (IObjectValue)TypeUtils.newInstance(this.composite.toComposite(), typeDesc);
        BOSObjectType bosType = instance.getBOSType();
        TypeDesc type = new TypeDesc(typeDesc);
        StringBuffer refs = new StringBuffer();
        EntityObjectInfo entity = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)this.ctx).getEntity(bosType);
        if (entity != null) {
            type.setDescription(entity.getAlias());
            PropertyCollection props = entity.getPropertiesRuntime();
            if (props != null) {
                TypeRef tr = null;
                StringBuffer desc = null;
                int size = props.size();
                for (int i = 0; i < size; ++i) {
                    PropertyInfo prop = props.get(i);
                    if (prop instanceof OwnPropertyInfo) {
                        DataType dt = ((OwnPropertyInfo)prop).getDataType();
                        if (DataType.ENUM.equals((Object)dt)) {
                            BizEnumInfo bizEnum = ((OwnPropertyInfo)prop).getEnumType(MDHostType.RUNTIME_SERVER);
                            tr = new TypeRef(this.composite, bizEnum.getFullName(), false);
                            BizEnumValueCollection enumCol = bizEnum.getEnumValue();
                            desc = new StringBuffer();
                            int n = enumCol.size();
                            for (int j = 0; j < n; ++j) {
                                desc.append(enumCol.get(j).getValue());
                                desc.append(" - ");
                                desc.append(enumCol.get(j).getAlias());
                                desc.append(" ");
                            }
                            if (refs.length() != 0) {
                                refs.append(",");
                            }
                            refs.append(prop.getName());
                            refs.append(":");
                            refs.append(new AbstractTypeAdapter.Ref(bizEnum.getFullName()));
                        } else {
                            tr = new TypeRef(this.composite, dt.toString(), false);
                            instance.put(prop.getName(), this.getDefaultValue(Type.getDescriptor(this.getJavaType(dt))));
                        }
                    } else {
                        EntityObjectInfo child = ((LinkPropertyInfo)prop).getRelationship().getChildObject(entity);
                        tr = new TypeRef(this.composite, child.getObjectValueClassRuntime(), true);
                        if (refs.length() != 0) {
                            refs.append(",");
                        }
                        refs.append("\"");
                        refs.append(prop.getName());
                        refs.append("\"");
                        refs.append(":");
                        refs.append(new AbstractTypeAdapter.Ref(child.getObjectValueClassRuntime()));
                    }
                    FieldDesc fd = new FieldDesc(prop.getName(), tr);
                    fd.setDescription(prop.getAlias() + (desc == null ? "" : " : " + desc.toString()));
                    type.getFields().add(fd);
                    desc = null;
                }
            }
            type.setJson(this.convert2Json(instance, refs));
        }
        return type;
    }

    Class<?> getJavaType(DataType dt) {
        if (dt.equals((Object)DataType.SHORT)) {
            return Short.TYPE;
        }
        if (dt.equals((Object)DataType.INTEGER)) {
            return Integer.TYPE;
        }
        if (dt.equals((Object)DataType.LONG)) {
            return Long.TYPE;
        }
        if (dt.equals((Object)DataType.FLOAT)) {
            return Float.TYPE;
        }
        if (dt.equals((Object)DataType.DOUBLE)) {
            return Double.TYPE;
        }
        if (dt.equals((Object)DataType.DECIMAL)) {
            return BigDecimal.class;
        }
        if (dt.equals((Object)DataType.DATE)) {
            return Date.class;
        }
        if (dt.equals((Object)DataType.TIME)) {
            return Time.class;
        }
        if (dt.equals((Object)DataType.TIMESTAMP)) {
            return Timestamp.class;
        }
        if (dt.equals((Object)DataType.CHAR)) {
            return Character.TYPE;
        }
        if (dt.equals((Object)DataType.BOOLEAN)) {
            return Boolean.TYPE;
        }
        if (dt.equals((Object)DataType.BYTE)) {
            return Byte.TYPE;
        }
        if (dt.equals((Object)DataType.STRING)) {
            return String.class;
        }
        if (dt.equals((Object)DataType.OBJECTPK)) {
            return IObjectPK.class;
        }
        if (dt.equals((Object)DataType.BOSUUID)) {
            return BOSUuid.class;
        }
        if (dt.equals((Object)DataType.UUID)) {
            return Uuid.class;
        }
        if (dt.equals((Object)DataType.ENUM)) {
            return Enum.class;
        }
        if (dt.equals((Object)DataType.OBJECTVALUE)) {
            return IObjectValue.class;
        }
        if (dt.equals((Object)DataType.OBJECTCOLLECTION)) {
            return IObjectCollection.class;
        }
        if (dt.equals((Object)DataType.ROWSET)) {
            return IRowSet.class;
        }
        if (dt.equals((Object)DataType.BYTEARRAY)) {
            return byte[].class;
        }
        return null;
    }
}

