/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bsf.manage;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.bsf.manage.DocumentIndex;
import com.kingdee.bos.bsf.manage.ServiceViewException;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.util.ArrayList;
import org.apache.lucene.ep.analysis.Analyzer;
import org.apache.lucene.ep.analysis.standard.StandardAnalyzer;
import org.apache.lucene.ep.document.Document;
import org.apache.lucene.ep.index.IndexReader;
import org.apache.lucene.ep.queryParser.QueryParser;
import org.apache.lucene.ep.search.Collector;
import org.apache.lucene.ep.search.IndexSearcher;
import org.apache.lucene.ep.search.Query;
import org.apache.lucene.ep.search.ScoreDoc;
import org.apache.lucene.ep.search.TopScoreDocCollector;
import org.apache.lucene.ep.store.Directory;
import org.apache.lucene.ep.store.FSDirectory;
import org.apache.lucene.ep.util.Version;

class SearchFiles {
    private final File indexDir;

    SearchFiles(File indexDir) {
        this.indexDir = indexDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DocumentIndex[] search(String input) throws BOSException {
        if (StringUtils.isEmpty((String)input)) {
            return new DocumentIndex[0];
        }
        ArrayList<DocumentIndex> result = new ArrayList<DocumentIndex>();
        try (IndexReader reader = null;){
            reader = IndexReader.open((Directory)FSDirectory.open((File)this.indexDir), (boolean)true);
            IndexSearcher searcher = new IndexSearcher(reader);
            StandardAnalyzer analyzer = new StandardAnalyzer(Version.LUCENE_29);
            Query query = null;
            QueryParser parser = new QueryParser(Version.LUCENE_29, "description", (Analyzer)analyzer);
            query = parser.parse(input);
            int DISPLAY_NUM = 50;
            TopScoreDocCollector collector = TopScoreDocCollector.create((int)50, (boolean)false);
            searcher.search(query, (Collector)collector);
            ScoreDoc[] hits = collector.topDocs().scoreDocs;
            int numTotalHits = collector.getTotalHits();
            int size = numTotalHits > 50 ? 50 : numTotalHits;
            for (int i = 0; i < size; ++i) {
                Document doc = searcher.doc(hits[i].doc);
                result.add(new DocumentIndex(doc.get("uri"), doc.get("description")));
            }
        }
        catch (Exception e) {
            throw new ServiceViewException("search document error. input:" + input, e);
        }
        return result.toArray(new DocumentIndex[0]);
    }
}

