/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bsf.manage;

import com.kingdee.bos.AbstractBOSObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.facade.FacadeFileScan;
import com.kingdee.bos.bsf.manage.ArrayTypeAdapter;
import com.kingdee.bos.bsf.manage.CommonTypeAdapter;
import com.kingdee.bos.bsf.manage.CompositeDesc;
import com.kingdee.bos.bsf.manage.DocumentIndex;
import com.kingdee.bos.bsf.manage.DocumentManager;
import com.kingdee.bos.bsf.manage.EnumTypeAdapter;
import com.kingdee.bos.bsf.manage.FacadeHeadBean;
import com.kingdee.bos.bsf.manage.FacadeMethodBean;
import com.kingdee.bos.bsf.manage.FdMethodExceptionBean;
import com.kingdee.bos.bsf.manage.FdMethodParameterBean;
import com.kingdee.bos.bsf.manage.IServiceView;
import com.kingdee.bos.bsf.manage.ObjectCollectionTypeAdapter;
import com.kingdee.bos.bsf.manage.ObjectValueTypeAdapter;
import com.kingdee.bos.bsf.manage.OperationDesc;
import com.kingdee.bos.bsf.manage.ParamDesc;
import com.kingdee.bos.bsf.manage.ReturnDesc;
import com.kingdee.bos.bsf.manage.SearchFiles;
import com.kingdee.bos.bsf.manage.ServiceDesc;
import com.kingdee.bos.bsf.manage.TypeDesc;
import com.kingdee.bos.bsf.manage.TypeRef;
import com.kingdee.bos.bsf.parsing.Properties;
import com.kingdee.bos.bsf.service.Configuration;
import com.kingdee.bos.bsf.type.TypeUtils;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.util.enums.Enum;
import java.io.File;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class ServiceView
extends AbstractBOSObject
implements IServiceView {
    private static final BOSObjectType BOSTYPE = BOSObjectType.create((String)"BSFSV");

    public ServiceView() {
        this.registerInterface(IServiceView.class, this);
    }

    public ServiceView(Context ctx) {
        super(ctx);
        this.registerInterface(IServiceView.class, this);
    }

    public BOSObjectType getType() {
        return BOSTYPE;
    }

    @Override
    public List<CompositeDesc> listComposites() throws BOSException {
        CompositeDesc d;
        String[] keys = DocumentManager.getInstance().listKeys(null);
        ArrayList<CompositeDesc> descs = new ArrayList<CompositeDesc>(keys.length);
        for (String s : keys) {
            int index = s.lastIndexOf(45);
            d = new CompositeDesc(s.substring(0, index), s.substring(index + 1));
            Properties data = DocumentManager.getInstance().getDoc(DocumentManager.getUri(s, null, null, null));
            d.setAlias(data.getProperty("alias"));
            d.setDescription(data.getProperty("description"));
            d.setState(d.toComposite().getState());
            descs.add(d);
        }
        FacadeFileScan ffs = FacadeFileScan.getInstance();
        Set<String> facadeset = ffs.getFacadePackage();
        for (String packageName : facadeset) {
            d = new CompositeDesc(packageName, "OpenAPI");
            d.setAlias(packageName + "   alias");
            d.setDescription(packageName + "   description");
            d.setState(1);
            d.setFacade(true);
            descs.add(d);
        }
        return descs;
    }

    @Override
    public List<ServiceDesc> listServices(CompositeDesc composite) throws BOSException {
        if ("OpenAPI".equals(composite.getModule())) {
            String pkg = composite.getVersion();
            List<FacadeHeadBean> ls = FacadeFileScan.getInstance().getFacadeListByPackage(pkg);
            ArrayList<ServiceDesc> descs = new ArrayList<ServiceDesc>(ls.size());
            for (FacadeHeadBean fhb : ls) {
                ServiceDesc d = new ServiceDesc(composite, fhb.get_facadename());
                d.setDescription(fhb.get_description());
                d.setAlias(fhb.get_alias());
                descs.add(d);
            }
            return descs;
        }
        if ("MenuOpenAPI".equals(composite.getModule())) {
            String domainLongNumber = composite.getVersion();
            List<FacadeHeadBean> ls = null;
            ls = FacadeFileScan.getInstance().getFacadeListByDomainLongNumber(domainLongNumber);
            ArrayList<ServiceDesc> descs = new ArrayList<ServiceDesc>(ls.size());
            for (FacadeHeadBean fhb : ls) {
                ServiceDesc d = new ServiceDesc(composite, fhb.get_package() + "." + fhb.get_facadename());
                d.setDescription(fhb.get_description());
                d.setAlias(fhb.get_alias());
                descs.add(d);
            }
            return descs;
        }
        String m = composite.getModule() + "-" + composite.getVersion();
        String[] keys = DocumentManager.getInstance().listKeys(DocumentManager.getUri(m, null, null, null));
        ArrayList<ServiceDesc> descs = new ArrayList<ServiceDesc>(keys.length);
        for (String s : keys) {
            Properties data = DocumentManager.getInstance().getDoc(DocumentManager.getUri(m, s, null, null));
            ServiceDesc d = new ServiceDesc(composite, s);
            d.setDescription(data.getProperty("description"));
            descs.add(d);
        }
        return descs;
    }

    @Override
    public List<OperationDesc> listOperations(ServiceDesc service) throws BOSException {
        CompositeDesc composite = service.getComposite();
        if ("OpenAPI".equals(composite.getModule())) {
            String pkg = composite.getVersion();
            String facadename = service.getName();
            FacadeHeadBean fhb = FacadeFileScan.getInstance().getFacadeBean(pkg.replace(".", "/") + "/" + facadename + ".facade");
            List<FacadeMethodBean> methods = fhb.getMethods();
            ArrayList<OperationDesc> descs = new ArrayList<OperationDesc>(methods.size());
            for (FacadeMethodBean fmb : methods) {
                OperationDesc d = new OperationDesc(fmb.get_name(), fmb.get_description());
                descs.add(d);
            }
            return descs;
        }
        if ("MenuOpenAPI".equals(composite.getModule())) {
            String facadename = service.getName();
            FacadeHeadBean fhb = FacadeFileScan.getInstance().getFacadeBean(facadename.replace(".", "/") + ".facade");
            List<FacadeMethodBean> methods = fhb.getMethods();
            ArrayList<OperationDesc> descs = new ArrayList<OperationDesc>(methods.size());
            for (FacadeMethodBean fmb : methods) {
                OperationDesc d = new OperationDesc(fmb.get_name(), fmb.get_description());
                descs.add(d);
            }
            return descs;
        }
        String m = composite.getModule() + "-" + composite.getVersion();
        String[] keys = DocumentManager.getInstance().listKeys(DocumentManager.getUri(m, service.getName(), null, null));
        ArrayList<OperationDesc> descs = new ArrayList<OperationDesc>(keys.length);
        for (String s : keys) {
            Properties data = DocumentManager.getInstance().getDoc(DocumentManager.getUri(m, service.getName(), s, null));
            OperationDesc d = new OperationDesc(s, data.getProperty("description"));
            this.buildParam(service, d);
            d.setResult(new ReturnDesc(new TypeRef(composite, data.getProperty("returnType"))));
            descs.add(d);
        }
        return descs;
    }

    void buildParam(ServiceDesc service, OperationDesc oprt) throws BOSException {
        String[] keys;
        CompositeDesc composite = service.getComposite();
        String m = composite.getModule() + "-" + composite.getVersion();
        for (String s : keys = DocumentManager.getInstance().listKeys(DocumentManager.getUri(m, service.getName(), oprt.getName(), null))) {
            Properties data = DocumentManager.getInstance().getDoc(DocumentManager.getUri(m, service.getName(), oprt.getName(), s));
            ParamDesc p = new ParamDesc(s, new TypeRef(service.getComposite(), data.getProperty("type")));
            p.setDescription(data.getProperty("description"));
            oprt.getParams().add(p);
        }
    }

    @Override
    public TypeDesc getType(TypeRef typeRef) throws BOSException {
        if (!typeRef.isLink()) {
            TypeDesc typeDesc = new TypeDesc(typeRef.getName());
            typeDesc.setDescription(typeRef.getName());
            return typeDesc;
        }
        Class<?> clazz = TypeUtils.getClass(typeRef.composite.toComposite(), typeRef.getName());
        if (Collection.class.isAssignableFrom(clazz)) {
            TypeDesc typeDesc = new TypeDesc(typeRef.getName());
            typeDesc.setDescription(typeRef.getName());
            typeDesc.setJson("[{...},{...},...]");
            return typeDesc;
        }
        if (clazz.isInterface()) {
            TypeDesc typeDesc = new TypeDesc(typeRef.getName());
            typeDesc.setDescription(typeRef.getName());
            return typeDesc;
        }
        if (clazz.isArray()) {
            return new ArrayTypeAdapter(this.getContext(), typeRef.composite).get(typeRef.getName());
        }
        if (IObjectValue.class.isAssignableFrom(clazz)) {
            return new ObjectValueTypeAdapter(this.getContext(), typeRef.composite).get(typeRef.getName());
        }
        if (IObjectCollection.class.isAssignableFrom(clazz)) {
            return new ObjectCollectionTypeAdapter(this.getContext(), typeRef.composite).get(typeRef.getName());
        }
        if (Enum.class.isAssignableFrom(clazz)) {
            return new EnumTypeAdapter(this.getContext(), typeRef.composite).get(typeRef.getName());
        }
        return new CommonTypeAdapter(this.getContext(), typeRef.composite).get(typeRef.getName());
    }

    @Override
    public int refreshDocument() throws BOSException {
        DocumentManager.getInstance().genDoc();
        return 0;
    }

    @Override
    public DocumentIndex[] search(String input) throws BOSException {
        return new SearchFiles(new File(Configuration.getDocumentDir(), "$indexes")).search(input);
    }

    @Override
    public FacadeMethodBean getFacadeMethodBean(String facadefullname, String methodSpc) throws BOSException, MalformedURLException {
        FacadeMethodBean fmb = FacadeFileScan.getInstance().getFacadeMethodBean(facadefullname, methodSpc);
        List<FdMethodParameterBean> fp = fmb.getParameters();
        for (int i = 0; i < fp.size(); ++i) {
            fp.get(i).setSeq(i);
        }
        List<FdMethodExceptionBean> fe = fmb.getExceptions();
        for (int i = 0; i < fe.size(); ++i) {
            fe.get(i).setSeq(i);
        }
        return fmb;
    }

    @Override
    public int refreshOpenAPI() throws BOSException {
        FacadeFileScan.getInstance().reloadfacade();
        return 0;
    }

    @Override
    public FacadeHeadBean getFacadeBean(String facadefullname) throws BOSException {
        return FacadeFileScan.getInstance().getFacadeBean(facadefullname);
    }

    @Override
    public List<ServiceDesc> searchOpenAPI(String module, String inputStr) throws BOSException {
        List<FacadeHeadBean> ls = null;
        ls = FacadeFileScan.getInstance().searchAPI(inputStr);
        ArrayList<ServiceDesc> descs = new ArrayList<ServiceDesc>(ls.size());
        for (FacadeHeadBean fhb : ls) {
            ServiceDesc d = new ServiceDesc(new CompositeDesc(module, fhb.get_menuModle()), fhb.get_package() + "." + fhb.get_facadename());
            d.setDescription(fhb.get_description());
            d.setAlias(fhb.get_alias());
            descs.add(d);
        }
        return descs;
    }
}

