/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bsf.parsing;

import com.kingdee.bos.asm.AnnotationVisitor;
import com.kingdee.bos.asm.ClassReader;
import com.kingdee.bos.asm.ClassVisitor;
import com.kingdee.bos.bsf.parsing.ComponentMetadata;
import com.kingdee.bos.bsf.parsing.ServiceClassVisitor;
import com.kingdee.bos.bsf.parsing.ServiceMetadata;
import java.io.IOException;
import java.io.InputStream;
import org.apache.log4j.Logger;

class ComponentAnnotationVisitor
extends AnnotationVisitor {
    private static Logger logger = Logger.getLogger(ComponentAnnotationVisitor.class);
    private final ComponentMetadata component;
    private final ClassLoader classLoader;

    public ComponentAnnotationVisitor(ClassLoader classLoader, ComponentMetadata component) {
        super(262144);
        this.component = component;
        this.classLoader = classLoader;
    }

    public void visit(String name, Object value) {
        if ("name".equals(name) && !"".equals(value)) {
            this.component.setName((String)value);
        }
    }

    public AnnotationVisitor visitArray(String name) {
        return new ArrayAnnotationVisitor();
    }

    class ArrayAnnotationVisitor
    extends AnnotationVisitor {
        public ArrayAnnotationVisitor() {
            super(262144);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void visit(String name, Object value) {
            String s = (String)value;
            if (s == null || s.length() == 0) {
                return;
            }
            ServiceMetadata service = new ServiceMetadata(s);
            service.enableDescription = ((ComponentAnnotationVisitor)ComponentAnnotationVisitor.this).component.enableDescription;
            ServiceClassVisitor cv = new ServiceClassVisitor(service);
            InputStream in = null;
            try {
                in = ComponentAnnotationVisitor.this.classLoader.getResourceAsStream(s.replace('.', '/') + ".class");
                ClassReader cr = new ClassReader(in);
                cr.accept((ClassVisitor)cv, 7);
                ComponentAnnotationVisitor.this.component.addService(service);
            }
            catch (IOException e) {
                logger.error((Object)("parse service error. service:" + s), (Throwable)e);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        logger.error((Object)("service parse error. class:" + s), (Throwable)e);
                    }
                }
            }
        }
    }
}

