/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bsf.parsing;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.asm.ClassReader;
import com.kingdee.bos.asm.ClassVisitor;
import com.kingdee.bos.bsf.parsing.ComponentClassVisitor;
import com.kingdee.bos.bsf.parsing.ComponentMetadata;
import com.kingdee.bos.bsf.parsing.PathParser;
import com.kingdee.bos.bsf.parsing.ServiceParseException;
import com.kingdee.bos.bsf.service.Configuration;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class ComponentParser {
    private final List<URL> urls = new ArrayList<URL>();
    private final ClassLoader classLoader;

    public ComponentParser(URL home) throws BOSException {
        try {
            this.urls.add(new URL(home, "classes/"));
            this.urls.addAll(new PathParser().expandPaths(new File(new URL(home, "lib/*.jar").toURI()).getAbsolutePath()));
        }
        catch (Exception e) {
            throw new ServiceParseException("service parse error. can't find jars. url:" + home, e);
        }
        this.classLoader = new URLClassLoader(this.urls.toArray(new URL[0]), ClassLoader.getSystemClassLoader());
    }

    public ComponentMetadata parse(String className, boolean enableDescription) throws BOSException {
        ComponentMetadata component = new ComponentMetadata(className);
        component.enableDescription = enableDescription;
        InputStream in = null;
        try {
            in = this.classLoader.getResourceAsStream(className.replace('.', '/') + ".class");
            ComponentClassVisitor cv = new ComponentClassVisitor(this.classLoader, component);
            ClassReader cr = new ClassReader(in);
            cr.accept((ClassVisitor)cv, 7);
        }
        catch (Exception e) {
            throw new ServiceParseException("service parse error. class:" + className, e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    throw new ServiceParseException("service parse error. class:" + className, e);
                }
            }
        }
        return component;
    }

    public Set<String> getClasses(String regex) throws BOSException {
        HashSet<String> classes = new HashSet<String>();
        for (URL url : this.urls) {
            File file = Configuration.toFile(url);
            if (!file.exists()) continue;
            if (file.isFile()) {
                JarFile jarFile = null;
                try {
                    jarFile = new JarFile(file);
                    Enumeration<JarEntry> entries = jarFile.entries();
                    while (entries.hasMoreElements()) {
                        this.traverse(classes, regex, entries.nextElement());
                    }
                    continue;
                }
                catch (IOException e) {
                    throw new ServiceParseException("service parse error. file:" + file.getPath(), e);
                }
                finally {
                    if (jarFile == null) continue;
                    try {
                        jarFile.close();
                        continue;
                    }
                    catch (IOException iOException) {}
                }
            }
            this.traverse(classes, regex, null, file);
        }
        return classes;
    }

    private void traverse(Set<String> classes, String regex, String pack, File dir) {
        pack = pack != null ? pack + "." : "";
        for (File f : dir.listFiles()) {
            String name = f.getName();
            if (f.isDirectory()) {
                this.traverse(classes, regex, pack + name, f);
                continue;
            }
            if (!name.endsWith(".class") || !(name = pack + name.substring(0, name.lastIndexOf(".class"))).matches(regex)) continue;
            classes.add(name);
        }
    }

    private void traverse(Set<String> classes, String regex, JarEntry entry) {
        String name;
        if (!entry.isDirectory() && (name = entry.getName()).endsWith(".class") && (name = name.substring(0, name.lastIndexOf(".class")).replace('/', '.')).matches(regex)) {
            classes.add(name);
        }
    }
}

